// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents the base path that callers of the API must provide as part of the URL after the domain name.
 * <div class="remarks">A custom domain name plus a BasePathMapping specification identifies a deployed RestApi in a given stage of the owner Account.</div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Use Custom Domain Names
 * </div>
 */
class GetBasePathMappingResponse private constructor(builder: BuilderImpl) {
    /**
     * The base path name that callers of the API must provide as part of the URL after the domain name.
     */
    val basePath: String? = builder.basePath
    /**
     * The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * The name of the associated stage.
     */
    val stage: String? = builder.stage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetBasePathMappingResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetBasePathMappingResponse(")
        append("basePath=$basePath,")
        append("restApiId=$restApiId,")
        append("stage=$stage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = basePath?.hashCode() ?: 0
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetBasePathMappingResponse

        if (basePath != other.basePath) return false
        if (restApiId != other.restApiId) return false
        if (stage != other.stage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetBasePathMappingResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetBasePathMappingResponse
        /**
         * The base path name that callers of the API must provide as part of the URL after the domain name.
         */
        fun basePath(basePath: String): FluentBuilder
        /**
         * The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * The name of the associated stage.
         */
        fun stage(stage: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The base path name that callers of the API must provide as part of the URL after the domain name.
         */
        var basePath: String?
        /**
         * The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * The name of the associated stage.
         */
        var stage: String?

        fun build(): GetBasePathMappingResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var basePath: String? = null
        override var restApiId: String? = null
        override var stage: String? = null

        constructor(x: GetBasePathMappingResponse) : this() {
            this.basePath = x.basePath
            this.restApiId = x.restApiId
            this.stage = x.stage
        }

        override fun build(): GetBasePathMappingResponse = GetBasePathMappingResponse(this)
        override fun basePath(basePath: String): FluentBuilder = apply { this.basePath = basePath }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun stage(stage: String): FluentBuilder = apply { this.stage = stage }
    }
}
