// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a collection of API keys as represented by an ApiKeys resource.
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html">Use API Keys
 * </div>
 */
class GetApiKeysResponse private constructor(builder: BuilderImpl) {
    /**
     * The current page of elements from this collection.
     */
    val items: List<ApiKey>? = builder.items
    /**
     * The current pagination position in the paged result set.
     */
    val position: String? = builder.position
    /**
     * A list of warning messages logged during the import of API keys when the failOnWarnings option is set to true.
     */
    val warnings: List<String>? = builder.warnings

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetApiKeysResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetApiKeysResponse(")
        append("items=$items,")
        append("position=$position,")
        append("warnings=$warnings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetApiKeysResponse

        if (items != other.items) return false
        if (position != other.position) return false
        if (warnings != other.warnings) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetApiKeysResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetApiKeysResponse
        /**
         * The current page of elements from this collection.
         */
        fun items(items: List<ApiKey>): FluentBuilder
        /**
         * The current pagination position in the paged result set.
         */
        fun position(position: String): FluentBuilder
        /**
         * A list of warning messages logged during the import of API keys when the failOnWarnings option is set to true.
         */
        fun warnings(warnings: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The current page of elements from this collection.
         */
        var items: List<ApiKey>?
        /**
         * The current pagination position in the paged result set.
         */
        var position: String?
        /**
         * A list of warning messages logged during the import of API keys when the failOnWarnings option is set to true.
         */
        var warnings: List<String>?

        fun build(): GetApiKeysResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<ApiKey>? = null
        override var position: String? = null
        override var warnings: List<String>? = null

        constructor(x: GetApiKeysResponse) : this() {
            this.items = x.items
            this.position = x.position
            this.warnings = x.warnings
        }

        override fun build(): GetApiKeysResponse = GetApiKeysResponse(this)
        override fun items(items: List<ApiKey>): FluentBuilder = apply { this.items = items }
        override fun position(position: String): FluentBuilder = apply { this.position = position }
        override fun warnings(warnings: List<String>): FluentBuilder = apply { this.warnings = warnings }
    }
}
