// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The endpoint configuration to indicate the types of endpoints an API (RestApi) or its custom domain name (DomainName) has.
 */
class EndpointConfiguration private constructor(builder: BuilderImpl) {
    /**
     * A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is "EDGE". For a regional API and its custom domain name, the endpoint type is REGIONAL. For a private API, the endpoint type is PRIVATE.
     */
    val types: List<EndpointType>? = builder.types
    /**
     * A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes. It is only supported for PRIVATE endpoint type.
     */
    val vpcEndpointIds: List<String>? = builder.vpcEndpointIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EndpointConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointConfiguration(")
        append("types=$types,")
        append("vpcEndpointIds=$vpcEndpointIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = types?.hashCode() ?: 0
        result = 31 * result + (vpcEndpointIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EndpointConfiguration

        if (types != other.types) return false
        if (vpcEndpointIds != other.vpcEndpointIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EndpointConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EndpointConfiguration
        /**
         * A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is "EDGE". For a regional API and its custom domain name, the endpoint type is REGIONAL. For a private API, the endpoint type is PRIVATE.
         */
        fun types(types: List<EndpointType>): FluentBuilder
        /**
         * A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes. It is only supported for PRIVATE endpoint type.
         */
        fun vpcEndpointIds(vpcEndpointIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is "EDGE". For a regional API and its custom domain name, the endpoint type is REGIONAL. For a private API, the endpoint type is PRIVATE.
         */
        var types: List<EndpointType>?
        /**
         * A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes. It is only supported for PRIVATE endpoint type.
         */
        var vpcEndpointIds: List<String>?

        fun build(): EndpointConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var types: List<EndpointType>? = null
        override var vpcEndpointIds: List<String>? = null

        constructor(x: EndpointConfiguration) : this() {
            this.types = x.types
            this.vpcEndpointIds = x.vpcEndpointIds
        }

        override fun build(): EndpointConfiguration = EndpointConfiguration(this)
        override fun types(types: List<EndpointType>): FluentBuilder = apply { this.types = types }
        override fun vpcEndpointIds(vpcEndpointIds: List<String>): FluentBuilder = apply { this.vpcEndpointIds = vpcEndpointIds }
    }
}
