// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A documentation part for a targeted API entity.
 * <div class="remarks">
 * A documentation part consists of a content map (properties) and a target (location). The target specifies an API entity to which the documentation content applies. The supported API entity types are API, AUTHORIZER, MODEL, RESOURCE, METHOD, PATH_PARAMETER, QUERY_PARAMETER, REQUEST_HEADER, REQUEST_BODY, RESPONSE, RESPONSE_HEADER, and RESPONSE_BODY. Valid location fields depend on the API entity type. All valid fields are not required.
 * The content map is a JSON string of API-specific key-value pairs. Although an API can use any shape for the content map, only the OpenAPI-compliant documentation fields will be injected into the associated API entity definition in the exported OpenAPI definition file.</div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API, DocumentationParts
 * </div>
 */
class DocumentationPart private constructor(builder: BuilderImpl) {
    /**
     * The DocumentationPart identifier, generated by API Gateway when the DocumentationPart is created.
     */
    val id: String? = builder.id
    /**
     * The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.
     */
    val location: DocumentationPartLocation? = builder.location
    /**
     * A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., "{ \"description\": \"The API does ...\" }".  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of x-amazon-apigateway-documentation.
     */
    val properties: String? = builder.properties

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DocumentationPart = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentationPart(")
        append("id=$id,")
        append("location=$location,")
        append("properties=$properties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DocumentationPart

        if (id != other.id) return false
        if (location != other.location) return false
        if (properties != other.properties) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DocumentationPart = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DocumentationPart
        /**
         * The DocumentationPart identifier, generated by API Gateway when the DocumentationPart is created.
         */
        fun id(id: String): FluentBuilder
        /**
         * The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.
         */
        fun location(location: DocumentationPartLocation): FluentBuilder
        /**
         * A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., "{ \"description\": \"The API does ...\" }".  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of x-amazon-apigateway-documentation.
         */
        fun properties(properties: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The DocumentationPart identifier, generated by API Gateway when the DocumentationPart is created.
         */
        var id: String?
        /**
         * The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.
         */
        var location: DocumentationPartLocation?
        /**
         * A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., "{ \"description\": \"The API does ...\" }".  Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of x-amazon-apigateway-documentation.
         */
        var properties: String?

        fun build(): DocumentationPart
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.DocumentationPartLocation] inside the given [block]
         */
        fun location(block: DocumentationPartLocation.DslBuilder.() -> kotlin.Unit) {
            this.location = DocumentationPartLocation.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var id: String? = null
        override var location: DocumentationPartLocation? = null
        override var properties: String? = null

        constructor(x: DocumentationPart) : this() {
            this.id = x.id
            this.location = x.location
            this.properties = x.properties
        }

        override fun build(): DocumentationPart = DocumentationPart(this)
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun location(location: DocumentationPartLocation): FluentBuilder = apply { this.location = location }
        override fun properties(properties: String): FluentBuilder = apply { this.properties = properties }
    }
}
