// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The input configuration for a canary deployment.
 */
class DeploymentCanarySettings private constructor(builder: BuilderImpl) {
    /**
     * The percentage (0.0-100.0) of traffic routed to the canary deployment.
     */
    val percentTraffic: Double = builder.percentTraffic
    /**
     * A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
     */
    val stageVariableOverrides: Map<String, String>? = builder.stageVariableOverrides
    /**
     * A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
     */
    val useStageCache: Boolean = builder.useStageCache

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeploymentCanarySettings = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentCanarySettings(")
        append("percentTraffic=$percentTraffic,")
        append("stageVariableOverrides=$stageVariableOverrides,")
        append("useStageCache=$useStageCache)")
    }

    override fun hashCode(): kotlin.Int {
        var result = percentTraffic.hashCode()
        result = 31 * result + (stageVariableOverrides?.hashCode() ?: 0)
        result = 31 * result + (useStageCache.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeploymentCanarySettings

        if (percentTraffic != other.percentTraffic) return false
        if (stageVariableOverrides != other.stageVariableOverrides) return false
        if (useStageCache != other.useStageCache) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeploymentCanarySettings = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeploymentCanarySettings
        /**
         * The percentage (0.0-100.0) of traffic routed to the canary deployment.
         */
        fun percentTraffic(percentTraffic: Double): FluentBuilder
        /**
         * A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
         */
        fun stageVariableOverrides(stageVariableOverrides: Map<String, String>): FluentBuilder
        /**
         * A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
         */
        fun useStageCache(useStageCache: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The percentage (0.0-100.0) of traffic routed to the canary deployment.
         */
        var percentTraffic: Double
        /**
         * A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
         */
        var stageVariableOverrides: Map<String, String>?
        /**
         * A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
         */
        var useStageCache: Boolean

        fun build(): DeploymentCanarySettings
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var percentTraffic: Double = 0.0
        override var stageVariableOverrides: Map<String, String>? = null
        override var useStageCache: Boolean = false

        constructor(x: DeploymentCanarySettings) : this() {
            this.percentTraffic = x.percentTraffic
            this.stageVariableOverrides = x.stageVariableOverrides
            this.useStageCache = x.useStageCache
        }

        override fun build(): DeploymentCanarySettings = DeploymentCanarySettings(this)
        override fun percentTraffic(percentTraffic: Double): FluentBuilder = apply { this.percentTraffic = percentTraffic }
        override fun stageVariableOverrides(stageVariableOverrides: Map<String, String>): FluentBuilder = apply { this.stageVariableOverrides = stageVariableOverrides }
        override fun useStageCache(useStageCache: Boolean): FluentBuilder = apply { this.useStageCache = useStageCache }
    }
}
