// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.
 */
class CreateVpcLinkRequest private constructor(builder: BuilderImpl) {
    /**
     * The description of the VPC link.
     */
    val description: String? = builder.description
    /**
     * &#91;Required&#93; The name used to label and identify the VPC link.
     */
    val name: String? = builder.name
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * &#91;Required&#93; The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.
     */
    val targetArns: List<String>? = builder.targetArns

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateVpcLinkRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVpcLinkRequest(")
        append("description=$description,")
        append("name=$name,")
        append("tags=$tags,")
        append("targetArns=$targetArns)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateVpcLinkRequest

        if (description != other.description) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (targetArns != other.targetArns) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateVpcLinkRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateVpcLinkRequest
        /**
         * The description of the VPC link.
         */
        fun description(description: String): FluentBuilder
        /**
         * &#91;Required&#93; The name used to label and identify the VPC link.
         */
        fun name(name: String): FluentBuilder
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * &#91;Required&#93; The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.
         */
        fun targetArns(targetArns: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description of the VPC link.
         */
        var description: String?
        /**
         * &#91;Required&#93; The name used to label and identify the VPC link.
         */
        var name: String?
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        var tags: Map<String, String>?
        /**
         * &#91;Required&#93; The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.
         */
        var targetArns: List<String>?

        fun build(): CreateVpcLinkRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var name: String? = null
        override var tags: Map<String, String>? = null
        override var targetArns: List<String>? = null

        constructor(x: CreateVpcLinkRequest) : this() {
            this.description = x.description
            this.name = x.name
            this.tags = x.tags
            this.targetArns = x.targetArns
        }

        override fun build(): CreateVpcLinkRequest = CreateVpcLinkRequest(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun targetArns(targetArns: List<String>): FluentBuilder = apply { this.targetArns = targetArns }
    }
}
