// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a usage plan than can specify who can assess associated API stages with specified request limits and quotas.
 * <div class="remarks">
 * In a usage plan, you associate an API by specifying the API's Id and a stage name of the specified API. You add plan customers by adding API keys to the plan.
 * </div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans
 * </div>
 */
class CreateUsagePlanResponse private constructor(builder: BuilderImpl) {
    /**
     * The associated API stages of a usage plan.
     */
    val apiStages: List<ApiStage>? = builder.apiStages
    /**
     * The description of a usage plan.
     */
    val description: String? = builder.description
    /**
     * The identifier of a UsagePlan resource.
     */
    val id: String? = builder.id
    /**
     * The name of a usage plan.
     */
    val name: String? = builder.name
    /**
     * The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
     */
    val productCode: String? = builder.productCode
    /**
     * The maximum number of permitted requests per a given unit time interval.
     */
    val quota: QuotaSettings? = builder.quota
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The request throttle limits of a usage plan.
     */
    val throttle: ThrottleSettings? = builder.throttle

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateUsagePlanResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUsagePlanResponse(")
        append("apiStages=$apiStages,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("productCode=$productCode,")
        append("quota=$quota,")
        append("tags=$tags,")
        append("throttle=$throttle)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiStages?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (productCode?.hashCode() ?: 0)
        result = 31 * result + (quota?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throttle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateUsagePlanResponse

        if (apiStages != other.apiStages) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (productCode != other.productCode) return false
        if (quota != other.quota) return false
        if (tags != other.tags) return false
        if (throttle != other.throttle) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateUsagePlanResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateUsagePlanResponse
        /**
         * The associated API stages of a usage plan.
         */
        fun apiStages(apiStages: List<ApiStage>): FluentBuilder
        /**
         * The description of a usage plan.
         */
        fun description(description: String): FluentBuilder
        /**
         * The identifier of a UsagePlan resource.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of a usage plan.
         */
        fun name(name: String): FluentBuilder
        /**
         * The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
         */
        fun productCode(productCode: String): FluentBuilder
        /**
         * The maximum number of permitted requests per a given unit time interval.
         */
        fun quota(quota: QuotaSettings): FluentBuilder
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The request throttle limits of a usage plan.
         */
        fun throttle(throttle: ThrottleSettings): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The associated API stages of a usage plan.
         */
        var apiStages: List<ApiStage>?
        /**
         * The description of a usage plan.
         */
        var description: String?
        /**
         * The identifier of a UsagePlan resource.
         */
        var id: String?
        /**
         * The name of a usage plan.
         */
        var name: String?
        /**
         * The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
         */
        var productCode: String?
        /**
         * The maximum number of permitted requests per a given unit time interval.
         */
        var quota: QuotaSettings?
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>?
        /**
         * The request throttle limits of a usage plan.
         */
        var throttle: ThrottleSettings?

        fun build(): CreateUsagePlanResponse
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.QuotaSettings] inside the given [block]
         */
        fun quota(block: QuotaSettings.DslBuilder.() -> kotlin.Unit) {
            this.quota = QuotaSettings.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.ThrottleSettings] inside the given [block]
         */
        fun throttle(block: ThrottleSettings.DslBuilder.() -> kotlin.Unit) {
            this.throttle = ThrottleSettings.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiStages: List<ApiStage>? = null
        override var description: String? = null
        override var id: String? = null
        override var name: String? = null
        override var productCode: String? = null
        override var quota: QuotaSettings? = null
        override var tags: Map<String, String>? = null
        override var throttle: ThrottleSettings? = null

        constructor(x: CreateUsagePlanResponse) : this() {
            this.apiStages = x.apiStages
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.productCode = x.productCode
            this.quota = x.quota
            this.tags = x.tags
            this.throttle = x.throttle
        }

        override fun build(): CreateUsagePlanResponse = CreateUsagePlanResponse(this)
        override fun apiStages(apiStages: List<ApiStage>): FluentBuilder = apply { this.apiStages = apiStages }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun productCode(productCode: String): FluentBuilder = apply { this.productCode = productCode }
        override fun quota(quota: QuotaSettings): FluentBuilder = apply { this.quota = quota }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun throttle(throttle: ThrottleSettings): FluentBuilder = apply { this.throttle = throttle }
    }
}
