// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The POST request to create a usage plan with the name, description, throttle limits and quota limits, as well as the associated API stages, specified in the payload.
 */
class CreateUsagePlanRequest private constructor(builder: BuilderImpl) {
    /**
     * The associated API stages of the usage plan.
     */
    val apiStages: List<ApiStage>? = builder.apiStages
    /**
     * The description of the usage plan.
     */
    val description: String? = builder.description
    /**
     * &#91;Required&#93; The name of the usage plan.
     */
    val name: String? = builder.name
    /**
     * The quota of the usage plan.
     */
    val quota: QuotaSettings? = builder.quota
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The throttling limits of the usage plan.
     */
    val throttle: ThrottleSettings? = builder.throttle

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateUsagePlanRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUsagePlanRequest(")
        append("apiStages=$apiStages,")
        append("description=$description,")
        append("name=$name,")
        append("quota=$quota,")
        append("tags=$tags,")
        append("throttle=$throttle)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiStages?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (quota?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throttle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateUsagePlanRequest

        if (apiStages != other.apiStages) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (quota != other.quota) return false
        if (tags != other.tags) return false
        if (throttle != other.throttle) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateUsagePlanRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateUsagePlanRequest
        /**
         * The associated API stages of the usage plan.
         */
        fun apiStages(apiStages: List<ApiStage>): FluentBuilder
        /**
         * The description of the usage plan.
         */
        fun description(description: String): FluentBuilder
        /**
         * &#91;Required&#93; The name of the usage plan.
         */
        fun name(name: String): FluentBuilder
        /**
         * The quota of the usage plan.
         */
        fun quota(quota: QuotaSettings): FluentBuilder
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The throttling limits of the usage plan.
         */
        fun throttle(throttle: ThrottleSettings): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The associated API stages of the usage plan.
         */
        var apiStages: List<ApiStage>?
        /**
         * The description of the usage plan.
         */
        var description: String?
        /**
         * &#91;Required&#93; The name of the usage plan.
         */
        var name: String?
        /**
         * The quota of the usage plan.
         */
        var quota: QuotaSettings?
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        var tags: Map<String, String>?
        /**
         * The throttling limits of the usage plan.
         */
        var throttle: ThrottleSettings?

        fun build(): CreateUsagePlanRequest
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.QuotaSettings] inside the given [block]
         */
        fun quota(block: QuotaSettings.DslBuilder.() -> kotlin.Unit) {
            this.quota = QuotaSettings.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.ThrottleSettings] inside the given [block]
         */
        fun throttle(block: ThrottleSettings.DslBuilder.() -> kotlin.Unit) {
            this.throttle = ThrottleSettings.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiStages: List<ApiStage>? = null
        override var description: String? = null
        override var name: String? = null
        override var quota: QuotaSettings? = null
        override var tags: Map<String, String>? = null
        override var throttle: ThrottleSettings? = null

        constructor(x: CreateUsagePlanRequest) : this() {
            this.apiStages = x.apiStages
            this.description = x.description
            this.name = x.name
            this.quota = x.quota
            this.tags = x.tags
            this.throttle = x.throttle
        }

        override fun build(): CreateUsagePlanRequest = CreateUsagePlanRequest(this)
        override fun apiStages(apiStages: List<ApiStage>): FluentBuilder = apply { this.apiStages = apiStages }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun quota(quota: QuotaSettings): FluentBuilder = apply { this.quota = quota }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun throttle(throttle: ThrottleSettings): FluentBuilder = apply { this.throttle = throttle }
    }
}
