// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Requests API Gateway to create a Stage resource.
 */
class CreateStageRequest private constructor(builder: BuilderImpl) {
    /**
     * Whether cache clustering is enabled for the stage.
     */
    val cacheClusterEnabled: Boolean = builder.cacheClusterEnabled
    /**
     * The stage's cache cluster size.
     */
    val cacheClusterSize: CacheClusterSize? = builder.cacheClusterSize
    /**
     * The canary deployment settings of this stage.
     */
    val canarySettings: CanarySettings? = builder.canarySettings
    /**
     * &#91;Required&#93; The identifier of the Deployment resource for the Stage resource.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * The description of the Stage resource.
     */
    val description: String? = builder.description
    /**
     * The version of the associated API documentation.
     */
    val documentationVersion: String? = builder.documentationVersion
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * &#91;Required&#93; The name for the Stage resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
     */
    val stageName: String? = builder.stageName
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * Specifies whether active tracing with X-ray is enabled for the Stage.
     */
    val tracingEnabled: Boolean = builder.tracingEnabled
    /**
     * A map that defines the stage variables for the new Stage resource. Variable names
     * can have alphanumeric and underscore characters, and the values must match
     * &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
     */
    val variables: Map<String, String>? = builder.variables

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateStageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStageRequest(")
        append("cacheClusterEnabled=$cacheClusterEnabled,")
        append("cacheClusterSize=$cacheClusterSize,")
        append("canarySettings=$canarySettings,")
        append("deploymentId=$deploymentId,")
        append("description=$description,")
        append("documentationVersion=$documentationVersion,")
        append("restApiId=$restApiId,")
        append("stageName=$stageName,")
        append("tags=$tags,")
        append("tracingEnabled=$tracingEnabled,")
        append("variables=$variables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheClusterEnabled.hashCode()
        result = 31 * result + (cacheClusterSize?.hashCode() ?: 0)
        result = 31 * result + (canarySettings?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (documentationVersion?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tracingEnabled.hashCode())
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateStageRequest

        if (cacheClusterEnabled != other.cacheClusterEnabled) return false
        if (cacheClusterSize != other.cacheClusterSize) return false
        if (canarySettings != other.canarySettings) return false
        if (deploymentId != other.deploymentId) return false
        if (description != other.description) return false
        if (documentationVersion != other.documentationVersion) return false
        if (restApiId != other.restApiId) return false
        if (stageName != other.stageName) return false
        if (tags != other.tags) return false
        if (tracingEnabled != other.tracingEnabled) return false
        if (variables != other.variables) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateStageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateStageRequest
        /**
         * Whether cache clustering is enabled for the stage.
         */
        fun cacheClusterEnabled(cacheClusterEnabled: Boolean): FluentBuilder
        /**
         * The stage's cache cluster size.
         */
        fun cacheClusterSize(cacheClusterSize: CacheClusterSize): FluentBuilder
        /**
         * The canary deployment settings of this stage.
         */
        fun canarySettings(canarySettings: CanarySettings): FluentBuilder
        /**
         * &#91;Required&#93; The identifier of the Deployment resource for the Stage resource.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * The description of the Stage resource.
         */
        fun description(description: String): FluentBuilder
        /**
         * The version of the associated API documentation.
         */
        fun documentationVersion(documentationVersion: String): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * &#91;Required&#93; The name for the Stage resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
         */
        fun stageName(stageName: String): FluentBuilder
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * Specifies whether active tracing with X-ray is enabled for the Stage.
         */
        fun tracingEnabled(tracingEnabled: Boolean): FluentBuilder
        /**
         * A map that defines the stage variables for the new Stage resource. Variable names
         * can have alphanumeric and underscore characters, and the values must match
         * &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
         */
        fun variables(variables: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Whether cache clustering is enabled for the stage.
         */
        var cacheClusterEnabled: Boolean
        /**
         * The stage's cache cluster size.
         */
        var cacheClusterSize: CacheClusterSize?
        /**
         * The canary deployment settings of this stage.
         */
        var canarySettings: CanarySettings?
        /**
         * &#91;Required&#93; The identifier of the Deployment resource for the Stage resource.
         */
        var deploymentId: String?
        /**
         * The description of the Stage resource.
         */
        var description: String?
        /**
         * The version of the associated API documentation.
         */
        var documentationVersion: String?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * &#91;Required&#93; The name for the Stage resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
         */
        var stageName: String?
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        var tags: Map<String, String>?
        /**
         * Specifies whether active tracing with X-ray is enabled for the Stage.
         */
        var tracingEnabled: Boolean
        /**
         * A map that defines the stage variables for the new Stage resource. Variable names
         * can have alphanumeric and underscore characters, and the values must match
         * &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
         */
        var variables: Map<String, String>?

        fun build(): CreateStageRequest
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.CanarySettings] inside the given [block]
         */
        fun canarySettings(block: CanarySettings.DslBuilder.() -> kotlin.Unit) {
            this.canarySettings = CanarySettings.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cacheClusterEnabled: Boolean = false
        override var cacheClusterSize: CacheClusterSize? = null
        override var canarySettings: CanarySettings? = null
        override var deploymentId: String? = null
        override var description: String? = null
        override var documentationVersion: String? = null
        override var restApiId: String? = null
        override var stageName: String? = null
        override var tags: Map<String, String>? = null
        override var tracingEnabled: Boolean = false
        override var variables: Map<String, String>? = null

        constructor(x: CreateStageRequest) : this() {
            this.cacheClusterEnabled = x.cacheClusterEnabled
            this.cacheClusterSize = x.cacheClusterSize
            this.canarySettings = x.canarySettings
            this.deploymentId = x.deploymentId
            this.description = x.description
            this.documentationVersion = x.documentationVersion
            this.restApiId = x.restApiId
            this.stageName = x.stageName
            this.tags = x.tags
            this.tracingEnabled = x.tracingEnabled
            this.variables = x.variables
        }

        override fun build(): CreateStageRequest = CreateStageRequest(this)
        override fun cacheClusterEnabled(cacheClusterEnabled: Boolean): FluentBuilder = apply { this.cacheClusterEnabled = cacheClusterEnabled }
        override fun cacheClusterSize(cacheClusterSize: CacheClusterSize): FluentBuilder = apply { this.cacheClusterSize = cacheClusterSize }
        override fun canarySettings(canarySettings: CanarySettings): FluentBuilder = apply { this.canarySettings = canarySettings }
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun documentationVersion(documentationVersion: String): FluentBuilder = apply { this.documentationVersion = documentationVersion }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun stageName(stageName: String): FluentBuilder = apply { this.stageName = stageName }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun tracingEnabled(tracingEnabled: Boolean): FluentBuilder = apply { this.tracingEnabled = tracingEnabled }
        override fun variables(variables: Map<String, String>): FluentBuilder = apply { this.variables = variables }
    }
}
