// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A set of validation rules for incoming Method requests.
 * <div class="remarks">
 * In OpenAPI, a RequestValidator of an API is defined by the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.requestValidator.html">x-amazon-apigateway-request-validators.requestValidator object. It the referenced using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validator">x-amazon-apigateway-request-validator property.
 * </div>
 * <div class="seeAlso"><a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html">Enable Basic Request Validation in API Gateway</div>
 */
class CreateRequestValidatorResponse private constructor(builder: BuilderImpl) {
    /**
     * The identifier of this RequestValidator.
     */
    val id: String? = builder.id
    /**
     * The name of this RequestValidator
     */
    val name: String? = builder.name
    /**
     * A Boolean flag to indicate whether to validate a request body according to the configured Model schema.
     */
    val validateRequestBody: Boolean = builder.validateRequestBody
    /**
     * A Boolean flag to indicate whether to validate request parameters (true) or not (false).
     */
    val validateRequestParameters: Boolean = builder.validateRequestParameters

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateRequestValidatorResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRequestValidatorResponse(")
        append("id=$id,")
        append("name=$name,")
        append("validateRequestBody=$validateRequestBody,")
        append("validateRequestParameters=$validateRequestParameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (validateRequestBody.hashCode())
        result = 31 * result + (validateRequestParameters.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateRequestValidatorResponse

        if (id != other.id) return false
        if (name != other.name) return false
        if (validateRequestBody != other.validateRequestBody) return false
        if (validateRequestParameters != other.validateRequestParameters) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateRequestValidatorResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateRequestValidatorResponse
        /**
         * The identifier of this RequestValidator.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of this RequestValidator
         */
        fun name(name: String): FluentBuilder
        /**
         * A Boolean flag to indicate whether to validate a request body according to the configured Model schema.
         */
        fun validateRequestBody(validateRequestBody: Boolean): FluentBuilder
        /**
         * A Boolean flag to indicate whether to validate request parameters (true) or not (false).
         */
        fun validateRequestParameters(validateRequestParameters: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of this RequestValidator.
         */
        var id: String?
        /**
         * The name of this RequestValidator
         */
        var name: String?
        /**
         * A Boolean flag to indicate whether to validate a request body according to the configured Model schema.
         */
        var validateRequestBody: Boolean
        /**
         * A Boolean flag to indicate whether to validate request parameters (true) or not (false).
         */
        var validateRequestParameters: Boolean

        fun build(): CreateRequestValidatorResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var id: String? = null
        override var name: String? = null
        override var validateRequestBody: Boolean = false
        override var validateRequestParameters: Boolean = false

        constructor(x: CreateRequestValidatorResponse) : this() {
            this.id = x.id
            this.name = x.name
            this.validateRequestBody = x.validateRequestBody
            this.validateRequestParameters = x.validateRequestParameters
        }

        override fun build(): CreateRequestValidatorResponse = CreateRequestValidatorResponse(this)
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun validateRequestBody(validateRequestBody: Boolean): FluentBuilder = apply { this.validateRequestBody = validateRequestBody }
        override fun validateRequestParameters(validateRequestParameters: Boolean): FluentBuilder = apply { this.validateRequestParameters = validateRequestParameters }
    }
}
