// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request to add a new Model to an existing RestApi resource.
 */
class CreateModelRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;Required&#93; The content-type for the model.
     */
    val contentType: String? = builder.contentType
    /**
     * The description of the model.
     */
    val description: String? = builder.description
    /**
     * &#91;Required&#93; The name of the model. Must be alphanumeric.
     */
    val name: String? = builder.name
    /**
     * &#91;Required&#93; The RestApi identifier under which the Model will be created.
     */
    val restApiId: String? = builder.restApiId
    /**
     * The schema for the model. For application/json models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4 model.
     */
    val schema: String? = builder.schema

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateModelRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelRequest(")
        append("contentType=$contentType,")
        append("description=$description,")
        append("name=$name,")
        append("restApiId=$restApiId,")
        append("schema=$schema)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentType?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateModelRequest

        if (contentType != other.contentType) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (restApiId != other.restApiId) return false
        if (schema != other.schema) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateModelRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateModelRequest
        /**
         * &#91;Required&#93; The content-type for the model.
         */
        fun contentType(contentType: String): FluentBuilder
        /**
         * The description of the model.
         */
        fun description(description: String): FluentBuilder
        /**
         * &#91;Required&#93; The name of the model. Must be alphanumeric.
         */
        fun name(name: String): FluentBuilder
        /**
         * &#91;Required&#93; The RestApi identifier under which the Model will be created.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * The schema for the model. For application/json models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4 model.
         */
        fun schema(schema: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;Required&#93; The content-type for the model.
         */
        var contentType: String?
        /**
         * The description of the model.
         */
        var description: String?
        /**
         * &#91;Required&#93; The name of the model. Must be alphanumeric.
         */
        var name: String?
        /**
         * &#91;Required&#93; The RestApi identifier under which the Model will be created.
         */
        var restApiId: String?
        /**
         * The schema for the model. For application/json models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4 model.
         */
        var schema: String?

        fun build(): CreateModelRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var contentType: String? = null
        override var description: String? = null
        override var name: String? = null
        override var restApiId: String? = null
        override var schema: String? = null

        constructor(x: CreateModelRequest) : this() {
            this.contentType = x.contentType
            this.description = x.description
            this.name = x.name
            this.restApiId = x.restApiId
            this.schema = x.schema
        }

        override fun build(): CreateModelRequest = CreateModelRequest(this)
        override fun contentType(contentType: String): FluentBuilder = apply { this.contentType = contentType }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun schema(schema: String): FluentBuilder = apply { this.schema = schema }
    }
}
