// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A request to create a new domain name.
 */
class CreateDomainNameRequest private constructor(builder: BuilderImpl) {
    /**
     * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * &#91;Deprecated&#93; The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.
     */
    val certificateBody: String? = builder.certificateBody
    /**
     * &#91;Deprecated&#93; The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.
     */
    val certificateChain: String? = builder.certificateChain
    /**
     * The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.
     */
    val certificateName: String? = builder.certificateName
    /**
     * &#91;Deprecated&#93; Your edge-optimized endpoint's domain name certificate's private key.
     */
    val certificatePrivateKey: String? = builder.certificatePrivateKey
    /**
     * &#91;Required&#93; The name of the DomainName resource.
     */
    val domainName: String? = builder.domainName
    /**
     * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
     */
    val endpointConfiguration: EndpointConfiguration? = builder.endpointConfiguration
    /**
     * If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.
     */
    val mutualTlsAuthentication: MutualTlsAuthenticationInput? = builder.mutualTlsAuthentication
    /**
     * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.
     */
    val ownershipVerificationCertificateArn: String? = builder.ownershipVerificationCertificateArn
    /**
     * The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.
     */
    val regionalCertificateArn: String? = builder.regionalCertificateArn
    /**
     * The user-friendly name of the certificate that will be used by regional endpoint for this domain name.
     */
    val regionalCertificateName: String? = builder.regionalCertificateName
    /**
     * The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are TLS_1_0 and TLS_1_2.
     */
    val securityPolicy: SecurityPolicy? = builder.securityPolicy
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDomainNameRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDomainNameRequest(")
        append("certificateArn=$certificateArn,")
        append("certificateBody=$certificateBody,")
        append("certificateChain=$certificateChain,")
        append("certificateName=$certificateName,")
        append("certificatePrivateKey=$certificatePrivateKey,")
        append("domainName=$domainName,")
        append("endpointConfiguration=$endpointConfiguration,")
        append("mutualTlsAuthentication=$mutualTlsAuthentication,")
        append("ownershipVerificationCertificateArn=$ownershipVerificationCertificateArn,")
        append("regionalCertificateArn=$regionalCertificateArn,")
        append("regionalCertificateName=$regionalCertificateName,")
        append("securityPolicy=$securityPolicy,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateBody?.hashCode() ?: 0)
        result = 31 * result + (certificateChain?.hashCode() ?: 0)
        result = 31 * result + (certificateName?.hashCode() ?: 0)
        result = 31 * result + (certificatePrivateKey?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (endpointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (mutualTlsAuthentication?.hashCode() ?: 0)
        result = 31 * result + (ownershipVerificationCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (regionalCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (regionalCertificateName?.hashCode() ?: 0)
        result = 31 * result + (securityPolicy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDomainNameRequest

        if (certificateArn != other.certificateArn) return false
        if (certificateBody != other.certificateBody) return false
        if (certificateChain != other.certificateChain) return false
        if (certificateName != other.certificateName) return false
        if (certificatePrivateKey != other.certificatePrivateKey) return false
        if (domainName != other.domainName) return false
        if (endpointConfiguration != other.endpointConfiguration) return false
        if (mutualTlsAuthentication != other.mutualTlsAuthentication) return false
        if (ownershipVerificationCertificateArn != other.ownershipVerificationCertificateArn) return false
        if (regionalCertificateArn != other.regionalCertificateArn) return false
        if (regionalCertificateName != other.regionalCertificateName) return false
        if (securityPolicy != other.securityPolicy) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDomainNameRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDomainNameRequest
        /**
         * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * &#91;Deprecated&#93; The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.
         */
        fun certificateBody(certificateBody: String): FluentBuilder
        /**
         * &#91;Deprecated&#93; The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.
         */
        fun certificateChain(certificateChain: String): FluentBuilder
        /**
         * The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.
         */
        fun certificateName(certificateName: String): FluentBuilder
        /**
         * &#91;Deprecated&#93; Your edge-optimized endpoint's domain name certificate's private key.
         */
        fun certificatePrivateKey(certificatePrivateKey: String): FluentBuilder
        /**
         * &#91;Required&#93; The name of the DomainName resource.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
         */
        fun endpointConfiguration(endpointConfiguration: EndpointConfiguration): FluentBuilder
        /**
         * If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.
         */
        fun mutualTlsAuthentication(mutualTlsAuthentication: MutualTlsAuthenticationInput): FluentBuilder
        /**
         * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.
         */
        fun ownershipVerificationCertificateArn(ownershipVerificationCertificateArn: String): FluentBuilder
        /**
         * The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.
         */
        fun regionalCertificateArn(regionalCertificateArn: String): FluentBuilder
        /**
         * The user-friendly name of the certificate that will be used by regional endpoint for this domain name.
         */
        fun regionalCertificateName(regionalCertificateName: String): FluentBuilder
        /**
         * The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are TLS_1_0 and TLS_1_2.
         */
        fun securityPolicy(securityPolicy: SecurityPolicy): FluentBuilder
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
         */
        var certificateArn: String?
        /**
         * &#91;Deprecated&#93; The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.
         */
        var certificateBody: String?
        /**
         * &#91;Deprecated&#93; The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.
         */
        var certificateChain: String?
        /**
         * The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.
         */
        var certificateName: String?
        /**
         * &#91;Deprecated&#93; Your edge-optimized endpoint's domain name certificate's private key.
         */
        var certificatePrivateKey: String?
        /**
         * &#91;Required&#93; The name of the DomainName resource.
         */
        var domainName: String?
        /**
         * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
         */
        var endpointConfiguration: EndpointConfiguration?
        /**
         * If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.
         */
        var mutualTlsAuthentication: MutualTlsAuthenticationInput?
        /**
         * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.
         */
        var ownershipVerificationCertificateArn: String?
        /**
         * The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.
         */
        var regionalCertificateArn: String?
        /**
         * The user-friendly name of the certificate that will be used by regional endpoint for this domain name.
         */
        var regionalCertificateName: String?
        /**
         * The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are TLS_1_0 and TLS_1_2.
         */
        var securityPolicy: SecurityPolicy?
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        var tags: Map<String, String>?

        fun build(): CreateDomainNameRequest
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration] inside the given [block]
         */
        fun endpointConfiguration(block: EndpointConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.endpointConfiguration = EndpointConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthenticationInput] inside the given [block]
         */
        fun mutualTlsAuthentication(block: MutualTlsAuthenticationInput.DslBuilder.() -> kotlin.Unit) {
            this.mutualTlsAuthentication = MutualTlsAuthenticationInput.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateArn: String? = null
        override var certificateBody: String? = null
        override var certificateChain: String? = null
        override var certificateName: String? = null
        override var certificatePrivateKey: String? = null
        override var domainName: String? = null
        override var endpointConfiguration: EndpointConfiguration? = null
        override var mutualTlsAuthentication: MutualTlsAuthenticationInput? = null
        override var ownershipVerificationCertificateArn: String? = null
        override var regionalCertificateArn: String? = null
        override var regionalCertificateName: String? = null
        override var securityPolicy: SecurityPolicy? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateDomainNameRequest) : this() {
            this.certificateArn = x.certificateArn
            this.certificateBody = x.certificateBody
            this.certificateChain = x.certificateChain
            this.certificateName = x.certificateName
            this.certificatePrivateKey = x.certificatePrivateKey
            this.domainName = x.domainName
            this.endpointConfiguration = x.endpointConfiguration
            this.mutualTlsAuthentication = x.mutualTlsAuthentication
            this.ownershipVerificationCertificateArn = x.ownershipVerificationCertificateArn
            this.regionalCertificateArn = x.regionalCertificateArn
            this.regionalCertificateName = x.regionalCertificateName
            this.securityPolicy = x.securityPolicy
            this.tags = x.tags
        }

        override fun build(): CreateDomainNameRequest = CreateDomainNameRequest(this)
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun certificateBody(certificateBody: String): FluentBuilder = apply { this.certificateBody = certificateBody }
        override fun certificateChain(certificateChain: String): FluentBuilder = apply { this.certificateChain = certificateChain }
        override fun certificateName(certificateName: String): FluentBuilder = apply { this.certificateName = certificateName }
        override fun certificatePrivateKey(certificatePrivateKey: String): FluentBuilder = apply { this.certificatePrivateKey = certificatePrivateKey }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun endpointConfiguration(endpointConfiguration: EndpointConfiguration): FluentBuilder = apply { this.endpointConfiguration = endpointConfiguration }
        override fun mutualTlsAuthentication(mutualTlsAuthentication: MutualTlsAuthenticationInput): FluentBuilder = apply { this.mutualTlsAuthentication = mutualTlsAuthentication }
        override fun ownershipVerificationCertificateArn(ownershipVerificationCertificateArn: String): FluentBuilder = apply { this.ownershipVerificationCertificateArn = ownershipVerificationCertificateArn }
        override fun regionalCertificateArn(regionalCertificateArn: String): FluentBuilder = apply { this.regionalCertificateArn = regionalCertificateArn }
        override fun regionalCertificateName(regionalCertificateName: String): FluentBuilder = apply { this.regionalCertificateName = regionalCertificateName }
        override fun securityPolicy(securityPolicy: SecurityPolicy): FluentBuilder = apply { this.securityPolicy = securityPolicy }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
