// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An immutable representation of a RestApi resource that can be called by users using Stages. A deployment must be associated with a Stage for it to be callable over the Internet.
 * <div class="remarks">To create a deployment, call POST on the Deployments resource of a RestApi.
 * To view, update, or delete a deployment, call GET, PATCH, or DELETE on the specified deployment resource (/restapis/{restapi_id}/deployments/{deployment_id}).</div>
 * <div class="seeAlso">RestApi, Deployments, Stage,
 * <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html">AWS CLI,
 * <a href="https://aws.amazon.com/tools/">AWS SDKs
 * </div>
 */
class CreateDeploymentResponse private constructor(builder: BuilderImpl) {
    /**
     * A summary of the RestApi at the date and time that the deployment resource was created.
     */
    val apiSummary: Map<String, Map<String, MethodSnapshot>>? = builder.apiSummary
    /**
     * The date and time that the deployment resource was created.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The description for the deployment resource.
     */
    val description: String? = builder.description
    /**
     * The identifier for the deployment resource.
     */
    val id: String? = builder.id

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDeploymentResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentResponse(")
        append("apiSummary=$apiSummary,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("id=$id)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiSummary?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDeploymentResponse

        if (apiSummary != other.apiSummary) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (id != other.id) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDeploymentResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDeploymentResponse
        /**
         * A summary of the RestApi at the date and time that the deployment resource was created.
         */
        fun apiSummary(apiSummary: Map<String, Map<String, MethodSnapshot>>): FluentBuilder
        /**
         * The date and time that the deployment resource was created.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The description for the deployment resource.
         */
        fun description(description: String): FluentBuilder
        /**
         * The identifier for the deployment resource.
         */
        fun id(id: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A summary of the RestApi at the date and time that the deployment resource was created.
         */
        var apiSummary: Map<String, Map<String, MethodSnapshot>>?
        /**
         * The date and time that the deployment resource was created.
         */
        var createdDate: Instant?
        /**
         * The description for the deployment resource.
         */
        var description: String?
        /**
         * The identifier for the deployment resource.
         */
        var id: String?

        fun build(): CreateDeploymentResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiSummary: Map<String, Map<String, MethodSnapshot>>? = null
        override var createdDate: Instant? = null
        override var description: String? = null
        override var id: String? = null

        constructor(x: CreateDeploymentResponse) : this() {
            this.apiSummary = x.apiSummary
            this.createdDate = x.createdDate
            this.description = x.description
            this.id = x.id
        }

        override fun build(): CreateDeploymentResponse = CreateDeploymentResponse(this)
        override fun apiSummary(apiSummary: Map<String, Map<String, MethodSnapshot>>): FluentBuilder = apply { this.apiSummary = apiSummary }
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
    }
}
