// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Requests API Gateway to create a Deployment resource.
 */
class CreateDeploymentRequest private constructor(builder: BuilderImpl) {
    /**
     * Enables a cache cluster for the Stage resource specified in the input.
     */
    val cacheClusterEnabled: Boolean? = builder.cacheClusterEnabled
    /**
     * Specifies the cache cluster size for the Stage resource specified in the input, if a cache cluster is enabled.
     */
    val cacheClusterSize: CacheClusterSize? = builder.cacheClusterSize
    /**
     * The input configuration for the canary deployment when the deployment is a canary release deployment.
     */
    val canarySettings: DeploymentCanarySettings? = builder.canarySettings
    /**
     * The description for the Deployment resource to create.
     */
    val description: String? = builder.description
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * The description of the Stage resource for the Deployment resource to create.
     */
    val stageDescription: String? = builder.stageDescription
    /**
     * The name of the Stage resource for the Deployment resource to create.
     */
    val stageName: String? = builder.stageName
    /**
     * Specifies whether active tracing with X-ray is enabled for the Stage.
     */
    val tracingEnabled: Boolean? = builder.tracingEnabled
    /**
     * A map that defines the stage variables for the Stage resource that is associated
     * with the new deployment. Variable names can have alphanumeric and underscore characters, and the values
     * must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
     */
    val variables: Map<String, String>? = builder.variables

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDeploymentRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentRequest(")
        append("cacheClusterEnabled=$cacheClusterEnabled,")
        append("cacheClusterSize=$cacheClusterSize,")
        append("canarySettings=$canarySettings,")
        append("description=$description,")
        append("restApiId=$restApiId,")
        append("stageDescription=$stageDescription,")
        append("stageName=$stageName,")
        append("tracingEnabled=$tracingEnabled,")
        append("variables=$variables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheClusterEnabled?.hashCode() ?: 0
        result = 31 * result + (cacheClusterSize?.hashCode() ?: 0)
        result = 31 * result + (canarySettings?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageDescription?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (tracingEnabled?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDeploymentRequest

        if (cacheClusterEnabled != other.cacheClusterEnabled) return false
        if (cacheClusterSize != other.cacheClusterSize) return false
        if (canarySettings != other.canarySettings) return false
        if (description != other.description) return false
        if (restApiId != other.restApiId) return false
        if (stageDescription != other.stageDescription) return false
        if (stageName != other.stageName) return false
        if (tracingEnabled != other.tracingEnabled) return false
        if (variables != other.variables) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDeploymentRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDeploymentRequest
        /**
         * Enables a cache cluster for the Stage resource specified in the input.
         */
        fun cacheClusterEnabled(cacheClusterEnabled: Boolean): FluentBuilder
        /**
         * Specifies the cache cluster size for the Stage resource specified in the input, if a cache cluster is enabled.
         */
        fun cacheClusterSize(cacheClusterSize: CacheClusterSize): FluentBuilder
        /**
         * The input configuration for the canary deployment when the deployment is a canary release deployment.
         */
        fun canarySettings(canarySettings: DeploymentCanarySettings): FluentBuilder
        /**
         * The description for the Deployment resource to create.
         */
        fun description(description: String): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * The description of the Stage resource for the Deployment resource to create.
         */
        fun stageDescription(stageDescription: String): FluentBuilder
        /**
         * The name of the Stage resource for the Deployment resource to create.
         */
        fun stageName(stageName: String): FluentBuilder
        /**
         * Specifies whether active tracing with X-ray is enabled for the Stage.
         */
        fun tracingEnabled(tracingEnabled: Boolean): FluentBuilder
        /**
         * A map that defines the stage variables for the Stage resource that is associated
         * with the new deployment. Variable names can have alphanumeric and underscore characters, and the values
         * must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
         */
        fun variables(variables: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Enables a cache cluster for the Stage resource specified in the input.
         */
        var cacheClusterEnabled: Boolean?
        /**
         * Specifies the cache cluster size for the Stage resource specified in the input, if a cache cluster is enabled.
         */
        var cacheClusterSize: CacheClusterSize?
        /**
         * The input configuration for the canary deployment when the deployment is a canary release deployment.
         */
        var canarySettings: DeploymentCanarySettings?
        /**
         * The description for the Deployment resource to create.
         */
        var description: String?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * The description of the Stage resource for the Deployment resource to create.
         */
        var stageDescription: String?
        /**
         * The name of the Stage resource for the Deployment resource to create.
         */
        var stageName: String?
        /**
         * Specifies whether active tracing with X-ray is enabled for the Stage.
         */
        var tracingEnabled: Boolean?
        /**
         * A map that defines the stage variables for the Stage resource that is associated
         * with the new deployment. Variable names can have alphanumeric and underscore characters, and the values
         * must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
         */
        var variables: Map<String, String>?

        fun build(): CreateDeploymentRequest
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings] inside the given [block]
         */
        fun canarySettings(block: DeploymentCanarySettings.DslBuilder.() -> kotlin.Unit) {
            this.canarySettings = DeploymentCanarySettings.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cacheClusterEnabled: Boolean? = null
        override var cacheClusterSize: CacheClusterSize? = null
        override var canarySettings: DeploymentCanarySettings? = null
        override var description: String? = null
        override var restApiId: String? = null
        override var stageDescription: String? = null
        override var stageName: String? = null
        override var tracingEnabled: Boolean? = null
        override var variables: Map<String, String>? = null

        constructor(x: CreateDeploymentRequest) : this() {
            this.cacheClusterEnabled = x.cacheClusterEnabled
            this.cacheClusterSize = x.cacheClusterSize
            this.canarySettings = x.canarySettings
            this.description = x.description
            this.restApiId = x.restApiId
            this.stageDescription = x.stageDescription
            this.stageName = x.stageName
            this.tracingEnabled = x.tracingEnabled
            this.variables = x.variables
        }

        override fun build(): CreateDeploymentRequest = CreateDeploymentRequest(this)
        override fun cacheClusterEnabled(cacheClusterEnabled: Boolean): FluentBuilder = apply { this.cacheClusterEnabled = cacheClusterEnabled }
        override fun cacheClusterSize(cacheClusterSize: CacheClusterSize): FluentBuilder = apply { this.cacheClusterSize = cacheClusterSize }
        override fun canarySettings(canarySettings: DeploymentCanarySettings): FluentBuilder = apply { this.canarySettings = canarySettings }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun stageDescription(stageDescription: String): FluentBuilder = apply { this.stageDescription = stageDescription }
        override fun stageName(stageName: String): FluentBuilder = apply { this.stageName = stageName }
        override fun tracingEnabled(tracingEnabled: Boolean): FluentBuilder = apply { this.tracingEnabled = tracingEnabled }
        override fun variables(variables: Map<String, String>): FluentBuilder = apply { this.variables = variables }
    }
}
