// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Requests API Gateway to create a new BasePathMapping resource.
 */
class CreateBasePathMappingRequest private constructor(builder: BuilderImpl) {
    /**
     * The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.
     */
    val basePath: String? = builder.basePath
    /**
     * &#91;Required&#93; The domain name of the BasePathMapping resource to create.
     */
    val domainName: String? = builder.domainName
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.
     */
    val stage: String? = builder.stage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateBasePathMappingRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBasePathMappingRequest(")
        append("basePath=$basePath,")
        append("domainName=$domainName,")
        append("restApiId=$restApiId,")
        append("stage=$stage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = basePath?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateBasePathMappingRequest

        if (basePath != other.basePath) return false
        if (domainName != other.domainName) return false
        if (restApiId != other.restApiId) return false
        if (stage != other.stage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateBasePathMappingRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateBasePathMappingRequest
        /**
         * The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.
         */
        fun basePath(basePath: String): FluentBuilder
        /**
         * &#91;Required&#93; The domain name of the BasePathMapping resource to create.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.
         */
        fun stage(stage: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.
         */
        var basePath: String?
        /**
         * &#91;Required&#93; The domain name of the BasePathMapping resource to create.
         */
        var domainName: String?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.
         */
        var stage: String?

        fun build(): CreateBasePathMappingRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var basePath: String? = null
        override var domainName: String? = null
        override var restApiId: String? = null
        override var stage: String? = null

        constructor(x: CreateBasePathMappingRequest) : this() {
            this.basePath = x.basePath
            this.domainName = x.domainName
            this.restApiId = x.restApiId
            this.stage = x.stage
        }

        override fun build(): CreateBasePathMappingRequest = CreateBasePathMappingRequest(this)
        override fun basePath(basePath: String): FluentBuilder = apply { this.basePath = basePath }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun stage(stage: String): FluentBuilder = apply { this.stage = stage }
    }
}
