// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request to create an ApiKey resource.
 */
class CreateApiKeyRequest private constructor(builder: BuilderImpl) {
    /**
     * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     */
    val customerId: String? = builder.customerId
    /**
     * The description of the ApiKey.
     */
    val description: String? = builder.description
    /**
     * Specifies whether the ApiKey can be used by callers.
     */
    val enabled: Boolean = builder.enabled
    /**
     * Specifies whether (true) or not (false) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
     */
    val generateDistinctId: Boolean = builder.generateDistinctId
    /**
     * The name of the ApiKey.
     */
    val name: String? = builder.name
    /**
     * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
     */
    val stageKeys: List<StageKey>? = builder.stageKeys
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * Specifies a value of the API key. <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateApiKeyRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApiKeyRequest(")
        append("customerId=$customerId,")
        append("description=$description,")
        append("enabled=$enabled,")
        append("generateDistinctId=$generateDistinctId,")
        append("name=$name,")
        append("stageKeys=$stageKeys,")
        append("tags=$tags,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (generateDistinctId.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stageKeys?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateApiKeyRequest

        if (customerId != other.customerId) return false
        if (description != other.description) return false
        if (enabled != other.enabled) return false
        if (generateDistinctId != other.generateDistinctId) return false
        if (name != other.name) return false
        if (stageKeys != other.stageKeys) return false
        if (tags != other.tags) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateApiKeyRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateApiKeyRequest
        /**
         * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         */
        fun customerId(customerId: String): FluentBuilder
        /**
         * The description of the ApiKey.
         */
        fun description(description: String): FluentBuilder
        /**
         * Specifies whether the ApiKey can be used by callers.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * Specifies whether (true) or not (false) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
         */
        fun generateDistinctId(generateDistinctId: Boolean): FluentBuilder
        /**
         * The name of the ApiKey.
         */
        fun name(name: String): FluentBuilder
        /**
         * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
         */
        fun stageKeys(stageKeys: List<StageKey>): FluentBuilder
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * Specifies a value of the API key. <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         */
        var customerId: String?
        /**
         * The description of the ApiKey.
         */
        var description: String?
        /**
         * Specifies whether the ApiKey can be used by callers.
         */
        var enabled: Boolean
        /**
         * Specifies whether (true) or not (false) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
         */
        var generateDistinctId: Boolean
        /**
         * The name of the ApiKey.
         */
        var name: String?
        /**
         * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
         */
        var stageKeys: List<StageKey>?
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        var tags: Map<String, String>?
        /**
         * Specifies a value of the API key. <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
         */
        var value: String?

        fun build(): CreateApiKeyRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var customerId: String? = null
        override var description: String? = null
        override var enabled: Boolean = false
        override var generateDistinctId: Boolean = false
        override var name: String? = null
        override var stageKeys: List<StageKey>? = null
        override var tags: Map<String, String>? = null
        override var value: String? = null

        constructor(x: CreateApiKeyRequest) : this() {
            this.customerId = x.customerId
            this.description = x.description
            this.enabled = x.enabled
            this.generateDistinctId = x.generateDistinctId
            this.name = x.name
            this.stageKeys = x.stageKeys
            this.tags = x.tags
            this.value = x.value
        }

        override fun build(): CreateApiKeyRequest = CreateApiKeyRequest(this)
        override fun customerId(customerId: String): FluentBuilder = apply { this.customerId = customerId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun generateDistinctId(generateDistinctId: Boolean): FluentBuilder = apply { this.generateDistinctId = generateDistinctId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun stageKeys(stageKeys: List<StageKey>): FluentBuilder = apply { this.stageKeys = stageKeys }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
