// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Configuration settings of a canary deployment.
 */
class CanarySettings private constructor(builder: BuilderImpl) {
    /**
     * The ID of the canary deployment.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * The percent (0-100) of traffic diverted to a canary deployment.
     */
    val percentTraffic: Double = builder.percentTraffic
    /**
     * Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
     */
    val stageVariableOverrides: Map<String, String>? = builder.stageVariableOverrides
    /**
     * A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
     */
    val useStageCache: Boolean = builder.useStageCache

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CanarySettings = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CanarySettings(")
        append("deploymentId=$deploymentId,")
        append("percentTraffic=$percentTraffic,")
        append("stageVariableOverrides=$stageVariableOverrides,")
        append("useStageCache=$useStageCache)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (percentTraffic.hashCode())
        result = 31 * result + (stageVariableOverrides?.hashCode() ?: 0)
        result = 31 * result + (useStageCache.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CanarySettings

        if (deploymentId != other.deploymentId) return false
        if (percentTraffic != other.percentTraffic) return false
        if (stageVariableOverrides != other.stageVariableOverrides) return false
        if (useStageCache != other.useStageCache) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CanarySettings = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CanarySettings
        /**
         * The ID of the canary deployment.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * The percent (0-100) of traffic diverted to a canary deployment.
         */
        fun percentTraffic(percentTraffic: Double): FluentBuilder
        /**
         * Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
         */
        fun stageVariableOverrides(stageVariableOverrides: Map<String, String>): FluentBuilder
        /**
         * A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
         */
        fun useStageCache(useStageCache: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the canary deployment.
         */
        var deploymentId: String?
        /**
         * The percent (0-100) of traffic diverted to a canary deployment.
         */
        var percentTraffic: Double
        /**
         * Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
         */
        var stageVariableOverrides: Map<String, String>?
        /**
         * A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
         */
        var useStageCache: Boolean

        fun build(): CanarySettings
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deploymentId: String? = null
        override var percentTraffic: Double = 0.0
        override var stageVariableOverrides: Map<String, String>? = null
        override var useStageCache: Boolean = false

        constructor(x: CanarySettings) : this() {
            this.deploymentId = x.deploymentId
            this.percentTraffic = x.percentTraffic
            this.stageVariableOverrides = x.stageVariableOverrides
            this.useStageCache = x.useStageCache
        }

        override fun build(): CanarySettings = CanarySettings(this)
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun percentTraffic(percentTraffic: Double): FluentBuilder = apply { this.percentTraffic = percentTraffic }
        override fun stageVariableOverrides(stageVariableOverrides: Map<String, String>): FluentBuilder = apply { this.stageVariableOverrides = stageVariableOverrides }
        override fun useStageCache(useStageCache: Boolean): FluentBuilder = apply { this.useStageCache = useStageCache }
    }
}
