// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * API stage name of the associated API stage in a usage plan.
 */
class ApiStage private constructor(builder: BuilderImpl) {
    /**
     * API Id of the associated API stage in a usage plan.
     */
    val apiId: String? = builder.apiId
    /**
     * API stage name of the associated API stage in a usage plan.
     */
    val stage: String? = builder.stage
    /**
     * Map containing method level throttling information for API stage in a usage plan.
     */
    val throttle: Map<String, ThrottleSettings>? = builder.throttle

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ApiStage = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ApiStage(")
        append("apiId=$apiId,")
        append("stage=$stage,")
        append("throttle=$throttle)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (stage?.hashCode() ?: 0)
        result = 31 * result + (throttle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApiStage

        if (apiId != other.apiId) return false
        if (stage != other.stage) return false
        if (throttle != other.throttle) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ApiStage = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ApiStage
        /**
         * API Id of the associated API stage in a usage plan.
         */
        fun apiId(apiId: String): FluentBuilder
        /**
         * API stage name of the associated API stage in a usage plan.
         */
        fun stage(stage: String): FluentBuilder
        /**
         * Map containing method level throttling information for API stage in a usage plan.
         */
        fun throttle(throttle: Map<String, ThrottleSettings>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * API Id of the associated API stage in a usage plan.
         */
        var apiId: String?
        /**
         * API stage name of the associated API stage in a usage plan.
         */
        var stage: String?
        /**
         * Map containing method level throttling information for API stage in a usage plan.
         */
        var throttle: Map<String, ThrottleSettings>?

        fun build(): ApiStage
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiId: String? = null
        override var stage: String? = null
        override var throttle: Map<String, ThrottleSettings>? = null

        constructor(x: ApiStage) : this() {
            this.apiId = x.apiId
            this.stage = x.stage
            this.throttle = x.throttle
        }

        override fun build(): ApiStage = ApiStage(this)
        override fun apiId(apiId: String): FluentBuilder = apply { this.apiId = apiId }
        override fun stage(stage: String): FluentBuilder = apply { this.stage = stage }
        override fun throttle(throttle: Map<String, ThrottleSettings>): FluentBuilder = apply { this.throttle = throttle }
    }
}
