// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A resource that can be distributed to callers for executing Method resources that require an API key. API keys can be mapped to any Stage on any RestApi, which indicates that the callers with the API key can make requests to that stage.
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html">Use API Keys
 * </div>
 */
class ApiKey private constructor(builder: BuilderImpl) {
    /**
     * The timestamp when the API Key was created.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     */
    val customerId: String? = builder.customerId
    /**
     * The description of the API Key.
     */
    val description: String? = builder.description
    /**
     * Specifies whether the API Key can be used by callers.
     */
    val enabled: Boolean = builder.enabled
    /**
     * The identifier of the API Key.
     */
    val id: String? = builder.id
    /**
     * The timestamp when the API Key was last updated.
     */
    val lastUpdatedDate: Instant? = builder.lastUpdatedDate
    /**
     * The name of the API Key.
     */
    val name: String? = builder.name
    /**
     * A list of Stage resources that are associated with the ApiKey resource.
     */
    val stageKeys: List<String>? = builder.stageKeys
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The value of the API Key.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ApiKey = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ApiKey(")
        append("createdDate=$createdDate,")
        append("customerId=$customerId,")
        append("description=$description,")
        append("enabled=$enabled,")
        append("id=$id,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("name=$name,")
        append("stageKeys=$stageKeys,")
        append("tags=$tags,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (customerId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stageKeys?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApiKey

        if (createdDate != other.createdDate) return false
        if (customerId != other.customerId) return false
        if (description != other.description) return false
        if (enabled != other.enabled) return false
        if (id != other.id) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (name != other.name) return false
        if (stageKeys != other.stageKeys) return false
        if (tags != other.tags) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ApiKey = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ApiKey
        /**
         * The timestamp when the API Key was created.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         */
        fun customerId(customerId: String): FluentBuilder
        /**
         * The description of the API Key.
         */
        fun description(description: String): FluentBuilder
        /**
         * Specifies whether the API Key can be used by callers.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * The identifier of the API Key.
         */
        fun id(id: String): FluentBuilder
        /**
         * The timestamp when the API Key was last updated.
         */
        fun lastUpdatedDate(lastUpdatedDate: Instant): FluentBuilder
        /**
         * The name of the API Key.
         */
        fun name(name: String): FluentBuilder
        /**
         * A list of Stage resources that are associated with the ApiKey resource.
         */
        fun stageKeys(stageKeys: List<String>): FluentBuilder
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The value of the API Key.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The timestamp when the API Key was created.
         */
        var createdDate: Instant?
        /**
         * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         */
        var customerId: String?
        /**
         * The description of the API Key.
         */
        var description: String?
        /**
         * Specifies whether the API Key can be used by callers.
         */
        var enabled: Boolean
        /**
         * The identifier of the API Key.
         */
        var id: String?
        /**
         * The timestamp when the API Key was last updated.
         */
        var lastUpdatedDate: Instant?
        /**
         * The name of the API Key.
         */
        var name: String?
        /**
         * A list of Stage resources that are associated with the ApiKey resource.
         */
        var stageKeys: List<String>?
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>?
        /**
         * The value of the API Key.
         */
        var value: String?

        fun build(): ApiKey
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdDate: Instant? = null
        override var customerId: String? = null
        override var description: String? = null
        override var enabled: Boolean = false
        override var id: String? = null
        override var lastUpdatedDate: Instant? = null
        override var name: String? = null
        override var stageKeys: List<String>? = null
        override var tags: Map<String, String>? = null
        override var value: String? = null

        constructor(x: ApiKey) : this() {
            this.createdDate = x.createdDate
            this.customerId = x.customerId
            this.description = x.description
            this.enabled = x.enabled
            this.id = x.id
            this.lastUpdatedDate = x.lastUpdatedDate
            this.name = x.name
            this.stageKeys = x.stageKeys
            this.tags = x.tags
            this.value = x.value
        }

        override fun build(): ApiKey = ApiKey(this)
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun customerId(customerId: String): FluentBuilder = apply { this.customerId = customerId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdatedDate(lastUpdatedDate: Instant): FluentBuilder = apply { this.lastUpdatedDate = lastUpdatedDate }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun stageKeys(stageKeys: List<String>): FluentBuilder = apply { this.stageKeys = stageKeys }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
