// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Access log settings, including the access log format and access log destination ARN.
 */
class AccessLogSettings private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with amazon-apigateway-.
     */
    val destinationArn: String? = builder.destinationArn
    /**
     * A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables. The format must include at least $context.requestId.
     */
    val format: String? = builder.format

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AccessLogSettings = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AccessLogSettings(")
        append("destinationArn=$destinationArn,")
        append("format=$format)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationArn?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AccessLogSettings

        if (destinationArn != other.destinationArn) return false
        if (format != other.format) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AccessLogSettings = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AccessLogSettings
        /**
         * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with amazon-apigateway-.
         */
        fun destinationArn(destinationArn: String): FluentBuilder
        /**
         * A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables. The format must include at least $context.requestId.
         */
        fun format(format: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with amazon-apigateway-.
         */
        var destinationArn: String?
        /**
         * A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables. The format must include at least $context.requestId.
         */
        var format: String?

        fun build(): AccessLogSettings
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var destinationArn: String? = null
        override var format: String? = null

        constructor(x: AccessLogSettings) : this() {
            this.destinationArn = x.destinationArn
            this.format = x.format
        }

        override fun build(): AccessLogSettings = AccessLogSettings(this)
        override fun destinationArn(destinationArn: String): FluentBuilder = apply { this.destinationArn = destinationArn }
        override fun format(format: String): FluentBuilder = apply { this.format = format }
    }
}
