// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.apigateway.model.*
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.middleware.RetryFeature
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation

private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

internal fun registerCreateApiKeyMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateApiKeyRequest,CreateApiKeyResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateAuthorizerMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateAuthorizerRequest,CreateAuthorizerResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateBasePathMappingMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateBasePathMappingRequest,CreateBasePathMappingResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateDeploymentMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateDeploymentRequest,CreateDeploymentResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateDocumentationPartMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateDocumentationPartRequest,CreateDocumentationPartResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateDocumentationVersionMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateDocumentationVersionRequest,CreateDocumentationVersionResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateDomainNameMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateDomainNameRequest,CreateDomainNameResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateModelMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateModelRequest,CreateModelResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateRequestValidatorMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateRequestValidatorRequest,CreateRequestValidatorResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateResourceMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateResourceRequest,CreateResourceResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateRestApiMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateRestApiRequest,CreateRestApiResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateStageMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateStageRequest,CreateStageResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateUsagePlanMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateUsagePlanRequest,CreateUsagePlanResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateUsagePlanKeyMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateUsagePlanKeyRequest,CreateUsagePlanKeyResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerCreateVpcLinkMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<CreateVpcLinkRequest,CreateVpcLinkResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteApiKeyMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteApiKeyRequest,DeleteApiKeyResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteAuthorizerMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteAuthorizerRequest,DeleteAuthorizerResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteBasePathMappingMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteBasePathMappingRequest,DeleteBasePathMappingResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteClientCertificateMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteClientCertificateRequest,DeleteClientCertificateResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteDeploymentMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteDeploymentRequest,DeleteDeploymentResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteDocumentationPartMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteDocumentationPartRequest,DeleteDocumentationPartResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteDocumentationVersionMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteDocumentationVersionRequest,DeleteDocumentationVersionResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteDomainNameMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteDomainNameRequest,DeleteDomainNameResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteGatewayResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteGatewayResponseRequest,DeleteGatewayResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteIntegrationMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteIntegrationRequest,DeleteIntegrationResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteIntegrationResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteIntegrationResponseRequest,DeleteIntegrationResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteMethodMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteMethodRequest,DeleteMethodResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteMethodResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteMethodResponseRequest,DeleteMethodResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteModelMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteModelRequest,DeleteModelResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteRequestValidatorMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteRequestValidatorRequest,DeleteRequestValidatorResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteResourceMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteResourceRequest,DeleteResourceResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteRestApiMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteRestApiRequest,DeleteRestApiResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteStageMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteStageRequest,DeleteStageResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteUsagePlanMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteUsagePlanRequest,DeleteUsagePlanResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteUsagePlanKeyMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteUsagePlanKeyRequest,DeleteUsagePlanKeyResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerDeleteVpcLinkMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<DeleteVpcLinkRequest,DeleteVpcLinkResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerFlushStageAuthorizersCacheMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<FlushStageAuthorizersCacheRequest,FlushStageAuthorizersCacheResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerFlushStageCacheMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<FlushStageCacheRequest,FlushStageCacheResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGenerateClientCertificateMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GenerateClientCertificateRequest,GenerateClientCertificateResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetAccountMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetAccountRequest,GetAccountResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetApiKeyMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetApiKeyRequest,GetApiKeyResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetApiKeysMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetApiKeysRequest,GetApiKeysResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetAuthorizerMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetAuthorizerRequest,GetAuthorizerResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetAuthorizersMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetAuthorizersRequest,GetAuthorizersResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetBasePathMappingMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetBasePathMappingRequest,GetBasePathMappingResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetBasePathMappingsMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetBasePathMappingsRequest,GetBasePathMappingsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetClientCertificateMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetClientCertificateRequest,GetClientCertificateResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetClientCertificatesMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetClientCertificatesRequest,GetClientCertificatesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetDeploymentMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetDeploymentRequest,GetDeploymentResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetDeploymentsMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetDeploymentsRequest,GetDeploymentsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetDocumentationPartMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetDocumentationPartRequest,GetDocumentationPartResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetDocumentationPartsMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetDocumentationPartsRequest,GetDocumentationPartsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetDocumentationVersionMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetDocumentationVersionRequest,GetDocumentationVersionResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetDocumentationVersionsMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetDocumentationVersionsRequest,GetDocumentationVersionsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetDomainNameMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetDomainNameRequest,GetDomainNameResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetDomainNamesMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetDomainNamesRequest,GetDomainNamesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetExportMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetExportRequest,GetExportResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetGatewayResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetGatewayResponseRequest,GetGatewayResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetGatewayResponsesMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetGatewayResponsesRequest,GetGatewayResponsesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetIntegrationMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetIntegrationRequest,GetIntegrationResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetIntegrationResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetIntegrationResponseRequest,GetIntegrationResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetMethodMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetMethodRequest,GetMethodResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetMethodResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetMethodResponseRequest,GetMethodResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetModelMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetModelRequest,GetModelResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetModelTemplateMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetModelTemplateRequest,GetModelTemplateResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetModelsMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetModelsRequest,GetModelsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetRequestValidatorMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetRequestValidatorRequest,GetRequestValidatorResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetRequestValidatorsMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetRequestValidatorsRequest,GetRequestValidatorsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetResourceMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetResourceRequest,GetResourceResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetResourcesMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetResourcesRequest,GetResourcesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetRestApiMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetRestApiRequest,GetRestApiResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetRestApisMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetRestApisRequest,GetRestApisResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetSdkMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetSdkRequest,GetSdkResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetSdkTypeMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetSdkTypeRequest,GetSdkTypeResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetSdkTypesMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetSdkTypesRequest,GetSdkTypesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetStageMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetStageRequest,GetStageResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetStagesMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetStagesRequest,GetStagesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetTagsMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetTagsRequest,GetTagsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetUsageMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetUsageRequest,GetUsageResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetUsagePlanMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetUsagePlanRequest,GetUsagePlanResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetUsagePlanKeyMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetUsagePlanKeyRequest,GetUsagePlanKeyResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetUsagePlanKeysMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetUsagePlanKeysRequest,GetUsagePlanKeysResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetUsagePlansMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetUsagePlansRequest,GetUsagePlansResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetVpcLinkMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetVpcLinkRequest,GetVpcLinkResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerGetVpcLinksMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<GetVpcLinksRequest,GetVpcLinksResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerImportApiKeysMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<ImportApiKeysRequest,ImportApiKeysResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerImportDocumentationPartsMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<ImportDocumentationPartsRequest,ImportDocumentationPartsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerImportRestApiMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<ImportRestApiRequest,ImportRestApiResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerPutGatewayResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<PutGatewayResponseRequest,PutGatewayResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerPutIntegrationMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<PutIntegrationRequest,PutIntegrationResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerPutIntegrationResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<PutIntegrationResponseRequest,PutIntegrationResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerPutMethodMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<PutMethodRequest,PutMethodResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerPutMethodResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<PutMethodResponseRequest,PutMethodResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerPutRestApiMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<PutRestApiRequest,PutRestApiResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerTagResourceMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<TagResourceRequest,TagResourceResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerTestInvokeAuthorizerMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<TestInvokeAuthorizerRequest,TestInvokeAuthorizerResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerTestInvokeMethodMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<TestInvokeMethodRequest,TestInvokeMethodResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUntagResourceMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UntagResourceRequest,UntagResourceResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateAccountMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateAccountRequest,UpdateAccountResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateApiKeyMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateApiKeyRequest,UpdateApiKeyResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateAuthorizerMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateAuthorizerRequest,UpdateAuthorizerResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateBasePathMappingMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateBasePathMappingRequest,UpdateBasePathMappingResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateClientCertificateMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateClientCertificateRequest,UpdateClientCertificateResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateDeploymentMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateDeploymentRequest,UpdateDeploymentResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateDocumentationPartMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateDocumentationPartRequest,UpdateDocumentationPartResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateDocumentationVersionMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateDocumentationVersionRequest,UpdateDocumentationVersionResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateDomainNameMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateDomainNameRequest,UpdateDomainNameResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateGatewayResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateGatewayResponseRequest,UpdateGatewayResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateIntegrationMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateIntegrationRequest,UpdateIntegrationResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateIntegrationResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateIntegrationResponseRequest,UpdateIntegrationResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateMethodMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateMethodRequest,UpdateMethodResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateMethodResponseMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateMethodResponseRequest,UpdateMethodResponseResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateModelMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateModelRequest,UpdateModelResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateRequestValidatorMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateRequestValidatorRequest,UpdateRequestValidatorResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateResourceMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateResourceRequest,UpdateResourceResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateRestApiMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateRestApiRequest,UpdateRestApiResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateStageMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateStageRequest,UpdateStageResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateUsageMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateUsageRequest,UpdateUsageResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateUsagePlanMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateUsagePlanRequest,UpdateUsagePlanResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}

internal fun registerUpdateVpcLinkMiddleware(config: ApiGatewayClient.Config, op: SdkHttpOperation<UpdateVpcLinkRequest,UpdateVpcLinkResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            append("Accept", "application/json")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "apigateway"
        }
    }
}
