// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.apigateway.model.*
import aws.sdk.kotlin.services.apigateway.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "API Gateway"
const val ServiceApiVersion: String = "2015-07-09"
const val SdkVersion: String = "0.9.2-alpha"

internal class DefaultApiGatewayClient(override val config: ApiGatewayClient.Config) : ApiGatewayClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Create an ApiKey resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</div>
     */
    override suspend fun createApiKey(input: CreateApiKeyRequest): CreateApiKeyResponse {
        val op = SdkHttpOperation.build<CreateApiKeyRequest, CreateApiKeyResponse> {
            serializer = CreateApiKeyOperationSerializer()
            deserializer = CreateApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateApiKey"
            }
        }
        registerCreateApiKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new Authorizer resource to an existing RestApi resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</div>
     */
    override suspend fun createAuthorizer(input: CreateAuthorizerRequest): CreateAuthorizerResponse {
        val op = SdkHttpOperation.build<CreateAuthorizerRequest, CreateAuthorizerResponse> {
            serializer = CreateAuthorizerOperationSerializer()
            deserializer = CreateAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAuthorizer"
            }
        }
        registerCreateAuthorizerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new BasePathMapping resource.
     */
    override suspend fun createBasePathMapping(input: CreateBasePathMappingRequest): CreateBasePathMappingResponse {
        val op = SdkHttpOperation.build<CreateBasePathMappingRequest, CreateBasePathMappingResponse> {
            serializer = CreateBasePathMappingOperationSerializer()
            deserializer = CreateBasePathMappingOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateBasePathMapping"
            }
        }
        registerCreateBasePathMappingMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Deployment resource, which makes a specified RestApi callable over the internet.
     */
    override suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse {
        val op = SdkHttpOperation.build<CreateDeploymentRequest, CreateDeploymentResponse> {
            serializer = CreateDeploymentOperationSerializer()
            deserializer = CreateDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDeployment"
            }
        }
        registerCreateDeploymentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun createDocumentationPart(input: CreateDocumentationPartRequest): CreateDocumentationPartResponse {
        val op = SdkHttpOperation.build<CreateDocumentationPartRequest, CreateDocumentationPartResponse> {
            serializer = CreateDocumentationPartOperationSerializer()
            deserializer = CreateDocumentationPartOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDocumentationPart"
            }
        }
        registerCreateDocumentationPartMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun createDocumentationVersion(input: CreateDocumentationVersionRequest): CreateDocumentationVersionResponse {
        val op = SdkHttpOperation.build<CreateDocumentationVersionRequest, CreateDocumentationVersionResponse> {
            serializer = CreateDocumentationVersionOperationSerializer()
            deserializer = CreateDocumentationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDocumentationVersion"
            }
        }
        registerCreateDocumentationVersionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new domain name.
     */
    override suspend fun createDomainName(input: CreateDomainNameRequest): CreateDomainNameResponse {
        val op = SdkHttpOperation.build<CreateDomainNameRequest, CreateDomainNameResponse> {
            serializer = CreateDomainNameOperationSerializer()
            deserializer = CreateDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDomainName"
            }
        }
        registerCreateDomainNameMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new Model resource to an existing RestApi resource.
     */
    override suspend fun createModel(input: CreateModelRequest): CreateModelResponse {
        val op = SdkHttpOperation.build<CreateModelRequest, CreateModelResponse> {
            serializer = CreateModelOperationSerializer()
            deserializer = CreateModelOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateModel"
            }
        }
        registerCreateModelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a ReqeustValidator of a given RestApi.
     */
    override suspend fun createRequestValidator(input: CreateRequestValidatorRequest): CreateRequestValidatorResponse {
        val op = SdkHttpOperation.build<CreateRequestValidatorRequest, CreateRequestValidatorResponse> {
            serializer = CreateRequestValidatorOperationSerializer()
            deserializer = CreateRequestValidatorOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateRequestValidator"
            }
        }
        registerCreateRequestValidatorMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Resource resource.
     */
    override suspend fun createResource(input: CreateResourceRequest): CreateResourceResponse {
        val op = SdkHttpOperation.build<CreateResourceRequest, CreateResourceResponse> {
            serializer = CreateResourceOperationSerializer()
            deserializer = CreateResourceOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateResource"
            }
        }
        registerCreateResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new RestApi resource.
     */
    override suspend fun createRestApi(input: CreateRestApiRequest): CreateRestApiResponse {
        val op = SdkHttpOperation.build<CreateRestApiRequest, CreateRestApiResponse> {
            serializer = CreateRestApiOperationSerializer()
            deserializer = CreateRestApiOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateRestApi"
            }
        }
        registerCreateRestApiMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Stage resource that references a pre-existing Deployment for the API.
     * <!--   Creates a Stage resource.  -->
     */
    override suspend fun createStage(input: CreateStageRequest): CreateStageResponse {
        val op = SdkHttpOperation.build<CreateStageRequest, CreateStageResponse> {
            serializer = CreateStageOperationSerializer()
            deserializer = CreateStageOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateStage"
            }
        }
        registerCreateStageMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload.
     */
    override suspend fun createUsagePlan(input: CreateUsagePlanRequest): CreateUsagePlanResponse {
        val op = SdkHttpOperation.build<CreateUsagePlanRequest, CreateUsagePlanResponse> {
            serializer = CreateUsagePlanOperationSerializer()
            deserializer = CreateUsagePlanOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateUsagePlan"
            }
        }
        registerCreateUsagePlanMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a usage plan key for adding an existing API key to a usage plan.
     */
    override suspend fun createUsagePlanKey(input: CreateUsagePlanKeyRequest): CreateUsagePlanKeyResponse {
        val op = SdkHttpOperation.build<CreateUsagePlanKeyRequest, CreateUsagePlanKeyResponse> {
            serializer = CreateUsagePlanKeyOperationSerializer()
            deserializer = CreateUsagePlanKeyOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateUsagePlanKey"
            }
        }
        registerCreateUsagePlanKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.
     */
    override suspend fun createVpcLink(input: CreateVpcLinkRequest): CreateVpcLinkResponse {
        val op = SdkHttpOperation.build<CreateVpcLinkRequest, CreateVpcLinkResponse> {
            serializer = CreateVpcLinkOperationSerializer()
            deserializer = CreateVpcLinkOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreateVpcLink"
            }
        }
        registerCreateVpcLinkMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the ApiKey resource.
     */
    override suspend fun deleteApiKey(input: DeleteApiKeyRequest): DeleteApiKeyResponse {
        val op = SdkHttpOperation.build<DeleteApiKeyRequest, DeleteApiKeyResponse> {
            serializer = DeleteApiKeyOperationSerializer()
            deserializer = DeleteApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteApiKey"
            }
        }
        registerDeleteApiKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Authorizer resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</div>
     */
    override suspend fun deleteAuthorizer(input: DeleteAuthorizerRequest): DeleteAuthorizerResponse {
        val op = SdkHttpOperation.build<DeleteAuthorizerRequest, DeleteAuthorizerResponse> {
            serializer = DeleteAuthorizerOperationSerializer()
            deserializer = DeleteAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteAuthorizer"
            }
        }
        registerDeleteAuthorizerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the BasePathMapping resource.
     */
    override suspend fun deleteBasePathMapping(input: DeleteBasePathMappingRequest): DeleteBasePathMappingResponse {
        val op = SdkHttpOperation.build<DeleteBasePathMappingRequest, DeleteBasePathMappingResponse> {
            serializer = DeleteBasePathMappingOperationSerializer()
            deserializer = DeleteBasePathMappingOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteBasePathMapping"
            }
        }
        registerDeleteBasePathMappingMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the ClientCertificate resource.
     */
    override suspend fun deleteClientCertificate(input: DeleteClientCertificateRequest): DeleteClientCertificateResponse {
        val op = SdkHttpOperation.build<DeleteClientCertificateRequest, DeleteClientCertificateResponse> {
            serializer = DeleteClientCertificateOperationSerializer()
            deserializer = DeleteClientCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteClientCertificate"
            }
        }
        registerDeleteClientCertificateMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Deployment resource. Deleting a deployment will only succeed if there are no Stage resources associated with it.
     */
    override suspend fun deleteDeployment(input: DeleteDeploymentRequest): DeleteDeploymentResponse {
        val op = SdkHttpOperation.build<DeleteDeploymentRequest, DeleteDeploymentResponse> {
            serializer = DeleteDeploymentOperationSerializer()
            deserializer = DeleteDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteDeployment"
            }
        }
        registerDeleteDeploymentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun deleteDocumentationPart(input: DeleteDocumentationPartRequest): DeleteDocumentationPartResponse {
        val op = SdkHttpOperation.build<DeleteDocumentationPartRequest, DeleteDocumentationPartResponse> {
            serializer = DeleteDocumentationPartOperationSerializer()
            deserializer = DeleteDocumentationPartOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteDocumentationPart"
            }
        }
        registerDeleteDocumentationPartMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun deleteDocumentationVersion(input: DeleteDocumentationVersionRequest): DeleteDocumentationVersionResponse {
        val op = SdkHttpOperation.build<DeleteDocumentationVersionRequest, DeleteDocumentationVersionResponse> {
            serializer = DeleteDocumentationVersionOperationSerializer()
            deserializer = DeleteDocumentationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteDocumentationVersion"
            }
        }
        registerDeleteDocumentationVersionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the DomainName resource.
     */
    override suspend fun deleteDomainName(input: DeleteDomainNameRequest): DeleteDomainNameResponse {
        val op = SdkHttpOperation.build<DeleteDomainNameRequest, DeleteDomainNameResponse> {
            serializer = DeleteDomainNameOperationSerializer()
            deserializer = DeleteDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteDomainName"
            }
        }
        registerDeleteDomainNameMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it with the default settings.
     */
    override suspend fun deleteGatewayResponse(input: DeleteGatewayResponseRequest): DeleteGatewayResponseResponse {
        val op = SdkHttpOperation.build<DeleteGatewayResponseRequest, DeleteGatewayResponseResponse> {
            serializer = DeleteGatewayResponseOperationSerializer()
            deserializer = DeleteGatewayResponseOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteGatewayResponse"
            }
        }
        registerDeleteGatewayResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a delete integration.
     */
    override suspend fun deleteIntegration(input: DeleteIntegrationRequest): DeleteIntegrationResponse {
        val op = SdkHttpOperation.build<DeleteIntegrationRequest, DeleteIntegrationResponse> {
            serializer = DeleteIntegrationOperationSerializer()
            deserializer = DeleteIntegrationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteIntegration"
            }
        }
        registerDeleteIntegrationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a delete integration response.
     */
    override suspend fun deleteIntegrationResponse(input: DeleteIntegrationResponseRequest): DeleteIntegrationResponseResponse {
        val op = SdkHttpOperation.build<DeleteIntegrationResponseRequest, DeleteIntegrationResponseResponse> {
            serializer = DeleteIntegrationResponseOperationSerializer()
            deserializer = DeleteIntegrationResponseOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteIntegrationResponse"
            }
        }
        registerDeleteIntegrationResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Method resource.
     */
    override suspend fun deleteMethod(input: DeleteMethodRequest): DeleteMethodResponse {
        val op = SdkHttpOperation.build<DeleteMethodRequest, DeleteMethodResponse> {
            serializer = DeleteMethodOperationSerializer()
            deserializer = DeleteMethodOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteMethod"
            }
        }
        registerDeleteMethodMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing MethodResponse resource.
     */
    override suspend fun deleteMethodResponse(input: DeleteMethodResponseRequest): DeleteMethodResponseResponse {
        val op = SdkHttpOperation.build<DeleteMethodResponseRequest, DeleteMethodResponseResponse> {
            serializer = DeleteMethodResponseOperationSerializer()
            deserializer = DeleteMethodResponseOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteMethodResponse"
            }
        }
        registerDeleteMethodResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a model.
     */
    override suspend fun deleteModel(input: DeleteModelRequest): DeleteModelResponse {
        val op = SdkHttpOperation.build<DeleteModelRequest, DeleteModelResponse> {
            serializer = DeleteModelOperationSerializer()
            deserializer = DeleteModelOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteModel"
            }
        }
        registerDeleteModelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a RequestValidator of a given RestApi.
     */
    override suspend fun deleteRequestValidator(input: DeleteRequestValidatorRequest): DeleteRequestValidatorResponse {
        val op = SdkHttpOperation.build<DeleteRequestValidatorRequest, DeleteRequestValidatorResponse> {
            serializer = DeleteRequestValidatorOperationSerializer()
            deserializer = DeleteRequestValidatorOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteRequestValidator"
            }
        }
        registerDeleteRequestValidatorMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Resource resource.
     */
    override suspend fun deleteResource(input: DeleteResourceRequest): DeleteResourceResponse {
        val op = SdkHttpOperation.build<DeleteResourceRequest, DeleteResourceResponse> {
            serializer = DeleteResourceOperationSerializer()
            deserializer = DeleteResourceOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteResource"
            }
        }
        registerDeleteResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified API.
     */
    override suspend fun deleteRestApi(input: DeleteRestApiRequest): DeleteRestApiResponse {
        val op = SdkHttpOperation.build<DeleteRestApiRequest, DeleteRestApiResponse> {
            serializer = DeleteRestApiOperationSerializer()
            deserializer = DeleteRestApiOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteRestApi"
            }
        }
        registerDeleteRestApiMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Stage resource.
     */
    override suspend fun deleteStage(input: DeleteStageRequest): DeleteStageResponse {
        val op = SdkHttpOperation.build<DeleteStageRequest, DeleteStageResponse> {
            serializer = DeleteStageOperationSerializer()
            deserializer = DeleteStageOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteStage"
            }
        }
        registerDeleteStageMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a usage plan of a given plan Id.
     */
    override suspend fun deleteUsagePlan(input: DeleteUsagePlanRequest): DeleteUsagePlanResponse {
        val op = SdkHttpOperation.build<DeleteUsagePlanRequest, DeleteUsagePlanResponse> {
            serializer = DeleteUsagePlanOperationSerializer()
            deserializer = DeleteUsagePlanOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteUsagePlan"
            }
        }
        registerDeleteUsagePlanMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a usage plan key  and remove the underlying API key from the associated usage plan.
     */
    override suspend fun deleteUsagePlanKey(input: DeleteUsagePlanKeyRequest): DeleteUsagePlanKeyResponse {
        val op = SdkHttpOperation.build<DeleteUsagePlanKeyRequest, DeleteUsagePlanKeyResponse> {
            serializer = DeleteUsagePlanKeyOperationSerializer()
            deserializer = DeleteUsagePlanKeyOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteUsagePlanKey"
            }
        }
        registerDeleteUsagePlanKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing VpcLink of a specified identifier.
     */
    override suspend fun deleteVpcLink(input: DeleteVpcLinkRequest): DeleteVpcLinkResponse {
        val op = SdkHttpOperation.build<DeleteVpcLinkRequest, DeleteVpcLinkResponse> {
            serializer = DeleteVpcLinkOperationSerializer()
            deserializer = DeleteVpcLinkOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteVpcLink"
            }
        }
        registerDeleteVpcLinkMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Flushes all authorizer cache entries on a stage.
     */
    override suspend fun flushStageAuthorizersCache(input: FlushStageAuthorizersCacheRequest): FlushStageAuthorizersCacheResponse {
        val op = SdkHttpOperation.build<FlushStageAuthorizersCacheRequest, FlushStageAuthorizersCacheResponse> {
            serializer = FlushStageAuthorizersCacheOperationSerializer()
            deserializer = FlushStageAuthorizersCacheOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "FlushStageAuthorizersCache"
            }
        }
        registerFlushStageAuthorizersCacheMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Flushes a stage's cache.
     */
    override suspend fun flushStageCache(input: FlushStageCacheRequest): FlushStageCacheResponse {
        val op = SdkHttpOperation.build<FlushStageCacheRequest, FlushStageCacheResponse> {
            serializer = FlushStageCacheOperationSerializer()
            deserializer = FlushStageCacheOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "FlushStageCache"
            }
        }
        registerFlushStageCacheMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Generates a ClientCertificate resource.
     */
    override suspend fun generateClientCertificate(input: GenerateClientCertificateRequest): GenerateClientCertificateResponse {
        val op = SdkHttpOperation.build<GenerateClientCertificateRequest, GenerateClientCertificateResponse> {
            serializer = GenerateClientCertificateOperationSerializer()
            deserializer = GenerateClientCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "GenerateClientCertificate"
            }
        }
        registerGenerateClientCertificateMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the current Account resource.
     */
    override suspend fun getAccount(input: GetAccountRequest): GetAccountResponse {
        val op = SdkHttpOperation.build<GetAccountRequest, GetAccountResponse> {
            serializer = GetAccountOperationSerializer()
            deserializer = GetAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccount"
            }
        }
        registerGetAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the current ApiKey resource.
     */
    override suspend fun getApiKey(input: GetApiKeyRequest): GetApiKeyResponse {
        val op = SdkHttpOperation.build<GetApiKeyRequest, GetApiKeyResponse> {
            serializer = GetApiKeyOperationSerializer()
            deserializer = GetApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApiKey"
            }
        }
        registerGetApiKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the current ApiKeys resource.
     */
    override suspend fun getApiKeys(input: GetApiKeysRequest): GetApiKeysResponse {
        val op = SdkHttpOperation.build<GetApiKeysRequest, GetApiKeysResponse> {
            serializer = GetApiKeysOperationSerializer()
            deserializer = GetApiKeysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApiKeys"
            }
        }
        registerGetApiKeysMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describe an existing Authorizer resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</div>
     */
    override suspend fun getAuthorizer(input: GetAuthorizerRequest): GetAuthorizerResponse {
        val op = SdkHttpOperation.build<GetAuthorizerRequest, GetAuthorizerResponse> {
            serializer = GetAuthorizerOperationSerializer()
            deserializer = GetAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAuthorizer"
            }
        }
        registerGetAuthorizerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describe an existing Authorizers resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</div>
     */
    override suspend fun getAuthorizers(input: GetAuthorizersRequest): GetAuthorizersResponse {
        val op = SdkHttpOperation.build<GetAuthorizersRequest, GetAuthorizersResponse> {
            serializer = GetAuthorizersOperationSerializer()
            deserializer = GetAuthorizersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAuthorizers"
            }
        }
        registerGetAuthorizersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describe a BasePathMapping resource.
     */
    override suspend fun getBasePathMapping(input: GetBasePathMappingRequest): GetBasePathMappingResponse {
        val op = SdkHttpOperation.build<GetBasePathMappingRequest, GetBasePathMappingResponse> {
            serializer = GetBasePathMappingOperationSerializer()
            deserializer = GetBasePathMappingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBasePathMapping"
            }
        }
        registerGetBasePathMappingMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a collection of BasePathMapping resources.
     */
    override suspend fun getBasePathMappings(input: GetBasePathMappingsRequest): GetBasePathMappingsResponse {
        val op = SdkHttpOperation.build<GetBasePathMappingsRequest, GetBasePathMappingsResponse> {
            serializer = GetBasePathMappingsOperationSerializer()
            deserializer = GetBasePathMappingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBasePathMappings"
            }
        }
        registerGetBasePathMappingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the current ClientCertificate resource.
     */
    override suspend fun getClientCertificate(input: GetClientCertificateRequest): GetClientCertificateResponse {
        val op = SdkHttpOperation.build<GetClientCertificateRequest, GetClientCertificateResponse> {
            serializer = GetClientCertificateOperationSerializer()
            deserializer = GetClientCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetClientCertificate"
            }
        }
        registerGetClientCertificateMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a collection of ClientCertificate resources.
     */
    override suspend fun getClientCertificates(input: GetClientCertificatesRequest): GetClientCertificatesResponse {
        val op = SdkHttpOperation.build<GetClientCertificatesRequest, GetClientCertificatesResponse> {
            serializer = GetClientCertificatesOperationSerializer()
            deserializer = GetClientCertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetClientCertificates"
            }
        }
        registerGetClientCertificatesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Deployment resource.
     */
    override suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse {
        val op = SdkHttpOperation.build<GetDeploymentRequest, GetDeploymentResponse> {
            serializer = GetDeploymentOperationSerializer()
            deserializer = GetDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeployment"
            }
        }
        registerGetDeploymentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Deployments collection.
     */
    override suspend fun getDeployments(input: GetDeploymentsRequest): GetDeploymentsResponse {
        val op = SdkHttpOperation.build<GetDeploymentsRequest, GetDeploymentsResponse> {
            serializer = GetDeploymentsOperationSerializer()
            deserializer = GetDeploymentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeployments"
            }
        }
        registerGetDeploymentsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun getDocumentationPart(input: GetDocumentationPartRequest): GetDocumentationPartResponse {
        val op = SdkHttpOperation.build<GetDocumentationPartRequest, GetDocumentationPartResponse> {
            serializer = GetDocumentationPartOperationSerializer()
            deserializer = GetDocumentationPartOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDocumentationPart"
            }
        }
        registerGetDocumentationPartMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun getDocumentationParts(input: GetDocumentationPartsRequest): GetDocumentationPartsResponse {
        val op = SdkHttpOperation.build<GetDocumentationPartsRequest, GetDocumentationPartsResponse> {
            serializer = GetDocumentationPartsOperationSerializer()
            deserializer = GetDocumentationPartsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDocumentationParts"
            }
        }
        registerGetDocumentationPartsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun getDocumentationVersion(input: GetDocumentationVersionRequest): GetDocumentationVersionResponse {
        val op = SdkHttpOperation.build<GetDocumentationVersionRequest, GetDocumentationVersionResponse> {
            serializer = GetDocumentationVersionOperationSerializer()
            deserializer = GetDocumentationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDocumentationVersion"
            }
        }
        registerGetDocumentationVersionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun getDocumentationVersions(input: GetDocumentationVersionsRequest): GetDocumentationVersionsResponse {
        val op = SdkHttpOperation.build<GetDocumentationVersionsRequest, GetDocumentationVersionsResponse> {
            serializer = GetDocumentationVersionsOperationSerializer()
            deserializer = GetDocumentationVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDocumentationVersions"
            }
        }
        registerGetDocumentationVersionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     */
    override suspend fun getDomainName(input: GetDomainNameRequest): GetDomainNameResponse {
        val op = SdkHttpOperation.build<GetDomainNameRequest, GetDomainNameResponse> {
            serializer = GetDomainNameOperationSerializer()
            deserializer = GetDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomainName"
            }
        }
        registerGetDomainNameMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a collection of DomainName resources.
     */
    override suspend fun getDomainNames(input: GetDomainNamesRequest): GetDomainNamesResponse {
        val op = SdkHttpOperation.build<GetDomainNamesRequest, GetDomainNamesResponse> {
            serializer = GetDomainNamesOperationSerializer()
            deserializer = GetDomainNamesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomainNames"
            }
        }
        registerGetDomainNamesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Exports a deployed version of a RestApi in a specified format.
     */
    override suspend fun getExport(input: GetExportRequest): GetExportResponse {
        val op = SdkHttpOperation.build<GetExportRequest, GetExportResponse> {
            serializer = GetExportOperationSerializer()
            deserializer = GetExportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetExport"
            }
        }
        registerGetExportMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a GatewayResponse of a specified response type on the given RestApi.
     */
    override suspend fun getGatewayResponse(input: GetGatewayResponseRequest): GetGatewayResponseResponse {
        val op = SdkHttpOperation.build<GetGatewayResponseRequest, GetGatewayResponseResponse> {
            serializer = GetGatewayResponseOperationSerializer()
            deserializer = GetGatewayResponseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGatewayResponse"
            }
        }
        registerGetGatewayResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the supported response types.
     */
    override suspend fun getGatewayResponses(input: GetGatewayResponsesRequest): GetGatewayResponsesResponse {
        val op = SdkHttpOperation.build<GetGatewayResponsesRequest, GetGatewayResponsesResponse> {
            serializer = GetGatewayResponsesOperationSerializer()
            deserializer = GetGatewayResponsesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGatewayResponses"
            }
        }
        registerGetGatewayResponsesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get the integration settings.
     */
    override suspend fun getIntegration(input: GetIntegrationRequest): GetIntegrationResponse {
        val op = SdkHttpOperation.build<GetIntegrationRequest, GetIntegrationResponse> {
            serializer = GetIntegrationOperationSerializer()
            deserializer = GetIntegrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIntegration"
            }
        }
        registerGetIntegrationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a get integration response.
     */
    override suspend fun getIntegrationResponse(input: GetIntegrationResponseRequest): GetIntegrationResponseResponse {
        val op = SdkHttpOperation.build<GetIntegrationResponseRequest, GetIntegrationResponseResponse> {
            serializer = GetIntegrationResponseOperationSerializer()
            deserializer = GetIntegrationResponseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIntegrationResponse"
            }
        }
        registerGetIntegrationResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describe an existing Method resource.
     */
    override suspend fun getMethod(input: GetMethodRequest): GetMethodResponse {
        val op = SdkHttpOperation.build<GetMethodRequest, GetMethodResponse> {
            serializer = GetMethodOperationSerializer()
            deserializer = GetMethodOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMethod"
            }
        }
        registerGetMethodMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a MethodResponse resource.
     */
    override suspend fun getMethodResponse(input: GetMethodResponseRequest): GetMethodResponseResponse {
        val op = SdkHttpOperation.build<GetMethodResponseRequest, GetMethodResponseResponse> {
            serializer = GetMethodResponseOperationSerializer()
            deserializer = GetMethodResponseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMethodResponse"
            }
        }
        registerGetMethodResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing model defined for a RestApi resource.
     */
    override suspend fun getModel(input: GetModelRequest): GetModelResponse {
        val op = SdkHttpOperation.build<GetModelRequest, GetModelResponse> {
            serializer = GetModelOperationSerializer()
            deserializer = GetModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetModel"
            }
        }
        registerGetModelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     */
    override suspend fun getModelTemplate(input: GetModelTemplateRequest): GetModelTemplateResponse {
        val op = SdkHttpOperation.build<GetModelTemplateRequest, GetModelTemplateResponse> {
            serializer = GetModelTemplateOperationSerializer()
            deserializer = GetModelTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetModelTemplate"
            }
        }
        registerGetModelTemplateMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes existing Models defined for a RestApi resource.
     */
    override suspend fun getModels(input: GetModelsRequest): GetModelsResponse {
        val op = SdkHttpOperation.build<GetModelsRequest, GetModelsResponse> {
            serializer = GetModelsOperationSerializer()
            deserializer = GetModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetModels"
            }
        }
        registerGetModelsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a RequestValidator of a given RestApi.
     */
    override suspend fun getRequestValidator(input: GetRequestValidatorRequest): GetRequestValidatorResponse {
        val op = SdkHttpOperation.build<GetRequestValidatorRequest, GetRequestValidatorResponse> {
            serializer = GetRequestValidatorOperationSerializer()
            deserializer = GetRequestValidatorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRequestValidator"
            }
        }
        registerGetRequestValidatorMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the RequestValidators collection of a given RestApi.
     */
    override suspend fun getRequestValidators(input: GetRequestValidatorsRequest): GetRequestValidatorsResponse {
        val op = SdkHttpOperation.build<GetRequestValidatorsRequest, GetRequestValidatorsResponse> {
            serializer = GetRequestValidatorsOperationSerializer()
            deserializer = GetRequestValidatorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRequestValidators"
            }
        }
        registerGetRequestValidatorsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about a resource.
     */
    override suspend fun getResource(input: GetResourceRequest): GetResourceResponse {
        val op = SdkHttpOperation.build<GetResourceRequest, GetResourceResponse> {
            serializer = GetResourceOperationSerializer()
            deserializer = GetResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResource"
            }
        }
        registerGetResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about a collection of Resource resources.
     */
    override suspend fun getResources(input: GetResourcesRequest): GetResourcesResponse {
        val op = SdkHttpOperation.build<GetResourcesRequest, GetResourcesResponse> {
            serializer = GetResourcesOperationSerializer()
            deserializer = GetResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResources"
            }
        }
        registerGetResourcesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the RestApi resource in the collection.
     */
    override suspend fun getRestApi(input: GetRestApiRequest): GetRestApiResponse {
        val op = SdkHttpOperation.build<GetRestApiRequest, GetRestApiResponse> {
            serializer = GetRestApiOperationSerializer()
            deserializer = GetRestApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRestApi"
            }
        }
        registerGetRestApiMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the RestApis resources for your collection.
     */
    override suspend fun getRestApis(input: GetRestApisRequest): GetRestApisResponse {
        val op = SdkHttpOperation.build<GetRestApisRequest, GetRestApisResponse> {
            serializer = GetRestApisOperationSerializer()
            deserializer = GetRestApisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRestApis"
            }
        }
        registerGetRestApisMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Generates a client SDK for a RestApi and Stage.
     */
    override suspend fun getSdk(input: GetSdkRequest): GetSdkResponse {
        val op = SdkHttpOperation.build<GetSdkRequest, GetSdkResponse> {
            serializer = GetSdkOperationSerializer()
            deserializer = GetSdkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSdk"
            }
        }
        registerGetSdkMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun getSdkType(input: GetSdkTypeRequest): GetSdkTypeResponse {
        val op = SdkHttpOperation.build<GetSdkTypeRequest, GetSdkTypeResponse> {
            serializer = GetSdkTypeOperationSerializer()
            deserializer = GetSdkTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSdkType"
            }
        }
        registerGetSdkTypeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun getSdkTypes(input: GetSdkTypesRequest): GetSdkTypesResponse {
        val op = SdkHttpOperation.build<GetSdkTypesRequest, GetSdkTypesResponse> {
            serializer = GetSdkTypesOperationSerializer()
            deserializer = GetSdkTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSdkTypes"
            }
        }
        registerGetSdkTypesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Stage resource.
     */
    override suspend fun getStage(input: GetStageRequest): GetStageResponse {
        val op = SdkHttpOperation.build<GetStageRequest, GetStageResponse> {
            serializer = GetStageOperationSerializer()
            deserializer = GetStageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetStage"
            }
        }
        registerGetStageMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more Stage resources.
     */
    override suspend fun getStages(input: GetStagesRequest): GetStagesResponse {
        val op = SdkHttpOperation.build<GetStagesRequest, GetStagesResponse> {
            serializer = GetStagesOperationSerializer()
            deserializer = GetStagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetStages"
            }
        }
        registerGetStagesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the Tags collection for a given resource.
     */
    override suspend fun getTags(input: GetTagsRequest): GetTagsResponse {
        val op = SdkHttpOperation.build<GetTagsRequest, GetTagsResponse> {
            serializer = GetTagsOperationSerializer()
            deserializer = GetTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTags"
            }
        }
        registerGetTagsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the usage data of a usage plan in a specified time interval.
     */
    override suspend fun getUsage(input: GetUsageRequest): GetUsageResponse {
        val op = SdkHttpOperation.build<GetUsageRequest, GetUsageResponse> {
            serializer = GetUsageOperationSerializer()
            deserializer = GetUsageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsage"
            }
        }
        registerGetUsageMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a usage plan of a given plan identifier.
     */
    override suspend fun getUsagePlan(input: GetUsagePlanRequest): GetUsagePlanResponse {
        val op = SdkHttpOperation.build<GetUsagePlanRequest, GetUsagePlanResponse> {
            serializer = GetUsagePlanOperationSerializer()
            deserializer = GetUsagePlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsagePlan"
            }
        }
        registerGetUsagePlanMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a usage plan key of a given key identifier.
     */
    override suspend fun getUsagePlanKey(input: GetUsagePlanKeyRequest): GetUsagePlanKeyResponse {
        val op = SdkHttpOperation.build<GetUsagePlanKeyRequest, GetUsagePlanKeyResponse> {
            serializer = GetUsagePlanKeyOperationSerializer()
            deserializer = GetUsagePlanKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsagePlanKey"
            }
        }
        registerGetUsagePlanKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     */
    override suspend fun getUsagePlanKeys(input: GetUsagePlanKeysRequest): GetUsagePlanKeysResponse {
        val op = SdkHttpOperation.build<GetUsagePlanKeysRequest, GetUsagePlanKeysResponse> {
            serializer = GetUsagePlanKeysOperationSerializer()
            deserializer = GetUsagePlanKeysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsagePlanKeys"
            }
        }
        registerGetUsagePlanKeysMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets all the usage plans of the caller's account.
     */
    override suspend fun getUsagePlans(input: GetUsagePlansRequest): GetUsagePlansResponse {
        val op = SdkHttpOperation.build<GetUsagePlansRequest, GetUsagePlansResponse> {
            serializer = GetUsagePlansOperationSerializer()
            deserializer = GetUsagePlansOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsagePlans"
            }
        }
        registerGetUsagePlansMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a specified VPC link under the caller's account in a region.
     */
    override suspend fun getVpcLink(input: GetVpcLinkRequest): GetVpcLinkResponse {
        val op = SdkHttpOperation.build<GetVpcLinkRequest, GetVpcLinkResponse> {
            serializer = GetVpcLinkOperationSerializer()
            deserializer = GetVpcLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVpcLink"
            }
        }
        registerGetVpcLinkMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the VpcLinks collection under the caller's account in a selected region.
     */
    override suspend fun getVpcLinks(input: GetVpcLinksRequest): GetVpcLinksResponse {
        val op = SdkHttpOperation.build<GetVpcLinksRequest, GetVpcLinksResponse> {
            serializer = GetVpcLinksOperationSerializer()
            deserializer = GetVpcLinksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVpcLinks"
            }
        }
        registerGetVpcLinksMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Import API keys from an external source, such as a CSV-formatted file.
     */
    override suspend fun importApiKeys(input: ImportApiKeysRequest): ImportApiKeysResponse {
        val op = SdkHttpOperation.build<ImportApiKeysRequest, ImportApiKeysResponse> {
            serializer = ImportApiKeysOperationSerializer()
            deserializer = ImportApiKeysOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "ImportApiKeys"
            }
        }
        registerImportApiKeysMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun importDocumentationParts(input: ImportDocumentationPartsRequest): ImportDocumentationPartsResponse {
        val op = SdkHttpOperation.build<ImportDocumentationPartsRequest, ImportDocumentationPartsResponse> {
            serializer = ImportDocumentationPartsOperationSerializer()
            deserializer = ImportDocumentationPartsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportDocumentationParts"
            }
        }
        registerImportDocumentationPartsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     */
    override suspend fun importRestApi(input: ImportRestApiRequest): ImportRestApiResponse {
        val op = SdkHttpOperation.build<ImportRestApiRequest, ImportRestApiResponse> {
            serializer = ImportRestApiOperationSerializer()
            deserializer = ImportRestApiOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "ImportRestApi"
            }
        }
        registerImportRestApiMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.
     */
    override suspend fun putGatewayResponse(input: PutGatewayResponseRequest): PutGatewayResponseResponse {
        val op = SdkHttpOperation.build<PutGatewayResponseRequest, PutGatewayResponseResponse> {
            serializer = PutGatewayResponseOperationSerializer()
            deserializer = PutGatewayResponseOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "PutGatewayResponse"
            }
        }
        registerPutGatewayResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sets up a method's integration.
     */
    override suspend fun putIntegration(input: PutIntegrationRequest): PutIntegrationResponse {
        val op = SdkHttpOperation.build<PutIntegrationRequest, PutIntegrationResponse> {
            serializer = PutIntegrationOperationSerializer()
            deserializer = PutIntegrationOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "PutIntegration"
            }
        }
        registerPutIntegrationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a put integration.
     */
    override suspend fun putIntegrationResponse(input: PutIntegrationResponseRequest): PutIntegrationResponseResponse {
        val op = SdkHttpOperation.build<PutIntegrationResponseRequest, PutIntegrationResponseResponse> {
            serializer = PutIntegrationResponseOperationSerializer()
            deserializer = PutIntegrationResponseOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "PutIntegrationResponse"
            }
        }
        registerPutIntegrationResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Add a method to an existing Resource resource.
     */
    override suspend fun putMethod(input: PutMethodRequest): PutMethodResponse {
        val op = SdkHttpOperation.build<PutMethodRequest, PutMethodResponse> {
            serializer = PutMethodOperationSerializer()
            deserializer = PutMethodOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "PutMethod"
            }
        }
        registerPutMethodMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a MethodResponse to an existing Method resource.
     */
    override suspend fun putMethodResponse(input: PutMethodResponseRequest): PutMethodResponseResponse {
        val op = SdkHttpOperation.build<PutMethodResponseRequest, PutMethodResponseResponse> {
            serializer = PutMethodResponseOperationSerializer()
            deserializer = PutMethodResponseOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "PutMethodResponse"
            }
        }
        registerPutMethodResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * A feature of the API Gateway control service for updating an existing API with an input of external API definitions.
     * The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.
     */
    override suspend fun putRestApi(input: PutRestApiRequest): PutRestApiResponse {
        val op = SdkHttpOperation.build<PutRestApiRequest, PutRestApiResponse> {
            serializer = PutRestApiOperationSerializer()
            deserializer = PutRestApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutRestApi"
            }
        }
        registerPutRestApiMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates a tag on a given resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Simulate the execution of an Authorizer in your RestApi with headers, parameters, and an incoming request body.
     * <div class="seeAlso">
     * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer
     * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer
     * </div>
     */
    override suspend fun testInvokeAuthorizer(input: TestInvokeAuthorizerRequest): TestInvokeAuthorizerResponse {
        val op = SdkHttpOperation.build<TestInvokeAuthorizerRequest, TestInvokeAuthorizerResponse> {
            serializer = TestInvokeAuthorizerOperationSerializer()
            deserializer = TestInvokeAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestInvokeAuthorizer"
            }
        }
        registerTestInvokeAuthorizerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Simulate the execution of a Method in your RestApi with headers, parameters, and an incoming request body.
     */
    override suspend fun testInvokeMethod(input: TestInvokeMethodRequest): TestInvokeMethodResponse {
        val op = SdkHttpOperation.build<TestInvokeMethodRequest, TestInvokeMethodResponse> {
            serializer = TestInvokeMethodOperationSerializer()
            deserializer = TestInvokeMethodOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestInvokeMethod"
            }
        }
        registerTestInvokeMethodMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from a given resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about the current Account resource.
     */
    override suspend fun updateAccount(input: UpdateAccountRequest): UpdateAccountResponse {
        val op = SdkHttpOperation.build<UpdateAccountRequest, UpdateAccountResponse> {
            serializer = UpdateAccountOperationSerializer()
            deserializer = UpdateAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAccount"
            }
        }
        registerUpdateAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about an ApiKey resource.
     */
    override suspend fun updateApiKey(input: UpdateApiKeyRequest): UpdateApiKeyResponse {
        val op = SdkHttpOperation.build<UpdateApiKeyRequest, UpdateApiKeyResponse> {
            serializer = UpdateApiKeyOperationSerializer()
            deserializer = UpdateApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApiKey"
            }
        }
        registerUpdateApiKeyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Authorizer resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</div>
     */
    override suspend fun updateAuthorizer(input: UpdateAuthorizerRequest): UpdateAuthorizerResponse {
        val op = SdkHttpOperation.build<UpdateAuthorizerRequest, UpdateAuthorizerResponse> {
            serializer = UpdateAuthorizerOperationSerializer()
            deserializer = UpdateAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAuthorizer"
            }
        }
        registerUpdateAuthorizerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about the BasePathMapping resource.
     */
    override suspend fun updateBasePathMapping(input: UpdateBasePathMappingRequest): UpdateBasePathMappingResponse {
        val op = SdkHttpOperation.build<UpdateBasePathMappingRequest, UpdateBasePathMappingResponse> {
            serializer = UpdateBasePathMappingOperationSerializer()
            deserializer = UpdateBasePathMappingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBasePathMapping"
            }
        }
        registerUpdateBasePathMappingMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about an ClientCertificate resource.
     */
    override suspend fun updateClientCertificate(input: UpdateClientCertificateRequest): UpdateClientCertificateResponse {
        val op = SdkHttpOperation.build<UpdateClientCertificateRequest, UpdateClientCertificateResponse> {
            serializer = UpdateClientCertificateOperationSerializer()
            deserializer = UpdateClientCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateClientCertificate"
            }
        }
        registerUpdateClientCertificateMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about a Deployment resource.
     */
    override suspend fun updateDeployment(input: UpdateDeploymentRequest): UpdateDeploymentResponse {
        val op = SdkHttpOperation.build<UpdateDeploymentRequest, UpdateDeploymentResponse> {
            serializer = UpdateDeploymentOperationSerializer()
            deserializer = UpdateDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDeployment"
            }
        }
        registerUpdateDeploymentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun updateDocumentationPart(input: UpdateDocumentationPartRequest): UpdateDocumentationPartResponse {
        val op = SdkHttpOperation.build<UpdateDocumentationPartRequest, UpdateDocumentationPartResponse> {
            serializer = UpdateDocumentationPartOperationSerializer()
            deserializer = UpdateDocumentationPartOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDocumentationPart"
            }
        }
        registerUpdateDocumentationPartMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override suspend fun updateDocumentationVersion(input: UpdateDocumentationVersionRequest): UpdateDocumentationVersionResponse {
        val op = SdkHttpOperation.build<UpdateDocumentationVersionRequest, UpdateDocumentationVersionResponse> {
            serializer = UpdateDocumentationVersionOperationSerializer()
            deserializer = UpdateDocumentationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDocumentationVersion"
            }
        }
        registerUpdateDocumentationVersionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about the DomainName resource.
     */
    override suspend fun updateDomainName(input: UpdateDomainNameRequest): UpdateDomainNameResponse {
        val op = SdkHttpOperation.build<UpdateDomainNameRequest, UpdateDomainNameResponse> {
            serializer = UpdateDomainNameOperationSerializer()
            deserializer = UpdateDomainNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainName"
            }
        }
        registerUpdateDomainNameMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a GatewayResponse of a specified response type on the given RestApi.
     */
    override suspend fun updateGatewayResponse(input: UpdateGatewayResponseRequest): UpdateGatewayResponseResponse {
        val op = SdkHttpOperation.build<UpdateGatewayResponseRequest, UpdateGatewayResponseResponse> {
            serializer = UpdateGatewayResponseOperationSerializer()
            deserializer = UpdateGatewayResponseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGatewayResponse"
            }
        }
        registerUpdateGatewayResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Represents an update integration.
     */
    override suspend fun updateIntegration(input: UpdateIntegrationRequest): UpdateIntegrationResponse {
        val op = SdkHttpOperation.build<UpdateIntegrationRequest, UpdateIntegrationResponse> {
            serializer = UpdateIntegrationOperationSerializer()
            deserializer = UpdateIntegrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIntegration"
            }
        }
        registerUpdateIntegrationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Represents an update integration response.
     */
    override suspend fun updateIntegrationResponse(input: UpdateIntegrationResponseRequest): UpdateIntegrationResponseResponse {
        val op = SdkHttpOperation.build<UpdateIntegrationResponseRequest, UpdateIntegrationResponseResponse> {
            serializer = UpdateIntegrationResponseOperationSerializer()
            deserializer = UpdateIntegrationResponseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIntegrationResponse"
            }
        }
        registerUpdateIntegrationResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Method resource.
     */
    override suspend fun updateMethod(input: UpdateMethodRequest): UpdateMethodResponse {
        val op = SdkHttpOperation.build<UpdateMethodRequest, UpdateMethodResponse> {
            serializer = UpdateMethodOperationSerializer()
            deserializer = UpdateMethodOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMethod"
            }
        }
        registerUpdateMethodMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing MethodResponse resource.
     */
    override suspend fun updateMethodResponse(input: UpdateMethodResponseRequest): UpdateMethodResponseResponse {
        val op = SdkHttpOperation.build<UpdateMethodResponseRequest, UpdateMethodResponseResponse> {
            serializer = UpdateMethodResponseOperationSerializer()
            deserializer = UpdateMethodResponseOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "UpdateMethodResponse"
            }
        }
        registerUpdateMethodResponseMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about a model.
     */
    override suspend fun updateModel(input: UpdateModelRequest): UpdateModelResponse {
        val op = SdkHttpOperation.build<UpdateModelRequest, UpdateModelResponse> {
            serializer = UpdateModelOperationSerializer()
            deserializer = UpdateModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateModel"
            }
        }
        registerUpdateModelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a RequestValidator of a given RestApi.
     */
    override suspend fun updateRequestValidator(input: UpdateRequestValidatorRequest): UpdateRequestValidatorResponse {
        val op = SdkHttpOperation.build<UpdateRequestValidatorRequest, UpdateRequestValidatorResponse> {
            serializer = UpdateRequestValidatorOperationSerializer()
            deserializer = UpdateRequestValidatorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRequestValidator"
            }
        }
        registerUpdateRequestValidatorMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about a Resource resource.
     */
    override suspend fun updateResource(input: UpdateResourceRequest): UpdateResourceResponse {
        val op = SdkHttpOperation.build<UpdateResourceRequest, UpdateResourceResponse> {
            serializer = UpdateResourceOperationSerializer()
            deserializer = UpdateResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateResource"
            }
        }
        registerUpdateResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about the specified API.
     */
    override suspend fun updateRestApi(input: UpdateRestApiRequest): UpdateRestApiResponse {
        val op = SdkHttpOperation.build<UpdateRestApiRequest, UpdateRestApiResponse> {
            serializer = UpdateRestApiOperationSerializer()
            deserializer = UpdateRestApiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRestApi"
            }
        }
        registerUpdateRestApiMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about a Stage resource.
     */
    override suspend fun updateStage(input: UpdateStageRequest): UpdateStageResponse {
        val op = SdkHttpOperation.build<UpdateStageRequest, UpdateStageResponse> {
            serializer = UpdateStageOperationSerializer()
            deserializer = UpdateStageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStage"
            }
        }
        registerUpdateStageMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     */
    override suspend fun updateUsage(input: UpdateUsageRequest): UpdateUsageResponse {
        val op = SdkHttpOperation.build<UpdateUsageRequest, UpdateUsageResponse> {
            serializer = UpdateUsageOperationSerializer()
            deserializer = UpdateUsageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUsage"
            }
        }
        registerUpdateUsageMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a usage plan of a given plan Id.
     */
    override suspend fun updateUsagePlan(input: UpdateUsagePlanRequest): UpdateUsagePlanResponse {
        val op = SdkHttpOperation.build<UpdateUsagePlanRequest, UpdateUsagePlanResponse> {
            serializer = UpdateUsagePlanOperationSerializer()
            deserializer = UpdateUsagePlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUsagePlan"
            }
        }
        registerUpdateUsagePlanMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing VpcLink of a specified identifier.
     */
    override suspend fun updateVpcLink(input: UpdateVpcLinkRequest): UpdateVpcLinkResponse {
        val op = SdkHttpOperation.build<UpdateVpcLinkRequest, UpdateVpcLinkResponse> {
            serializer = UpdateVpcLinkOperationSerializer()
            deserializer = UpdateVpcLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVpcLink"
            }
        }
        registerUpdateVpcLinkMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
