// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.apigateway.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.apigateway.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon API Gateway</fullname>
 * Amazon API Gateway helps developers deliver robust, secure, and scalable mobile and web application back ends. API Gateway allows developers to securely connect mobile and web applications to APIs that run on AWS Lambda, Amazon EC2, or other publicly addressable web services that are hosted outside of AWS.
 */
interface ApiGatewayClient : SdkClient {

    override val serviceName: String
        get() = "API Gateway"
    /**
     * ApiGatewayClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): ApiGatewayClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultApiGatewayClient(config)
        }

        operator fun invoke(config: Config): ApiGatewayClient = DefaultApiGatewayClient(config)

        /**
         * Construct a [ApiGatewayClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): ApiGatewayClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return ApiGatewayClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Create an ApiKey resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</div>
     */
    suspend fun createApiKey(input: CreateApiKeyRequest): CreateApiKeyResponse

    /**
     * Create an ApiKey resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</div>
     */
    suspend fun createApiKey(block: CreateApiKeyRequest.DslBuilder.() -> Unit) = createApiKey(CreateApiKeyRequest.builder().apply(block).build())

    /**
     * Adds a new Authorizer resource to an existing RestApi resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</div>
     */
    suspend fun createAuthorizer(input: CreateAuthorizerRequest): CreateAuthorizerResponse

    /**
     * Adds a new Authorizer resource to an existing RestApi resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</div>
     */
    suspend fun createAuthorizer(block: CreateAuthorizerRequest.DslBuilder.() -> Unit) = createAuthorizer(CreateAuthorizerRequest.builder().apply(block).build())

    /**
     * Creates a new BasePathMapping resource.
     */
    suspend fun createBasePathMapping(input: CreateBasePathMappingRequest): CreateBasePathMappingResponse

    /**
     * Creates a new BasePathMapping resource.
     */
    suspend fun createBasePathMapping(block: CreateBasePathMappingRequest.DslBuilder.() -> Unit) = createBasePathMapping(CreateBasePathMappingRequest.builder().apply(block).build())

    /**
     * Creates a Deployment resource, which makes a specified RestApi callable over the internet.
     */
    suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Creates a Deployment resource, which makes a specified RestApi callable over the internet.
     */
    suspend fun createDeployment(block: CreateDeploymentRequest.DslBuilder.() -> Unit) = createDeployment(CreateDeploymentRequest.builder().apply(block).build())

    suspend fun createDocumentationPart(input: CreateDocumentationPartRequest): CreateDocumentationPartResponse

    suspend fun createDocumentationPart(block: CreateDocumentationPartRequest.DslBuilder.() -> Unit) = createDocumentationPart(CreateDocumentationPartRequest.builder().apply(block).build())

    suspend fun createDocumentationVersion(input: CreateDocumentationVersionRequest): CreateDocumentationVersionResponse

    suspend fun createDocumentationVersion(block: CreateDocumentationVersionRequest.DslBuilder.() -> Unit) = createDocumentationVersion(CreateDocumentationVersionRequest.builder().apply(block).build())

    /**
     * Creates a new domain name.
     */
    suspend fun createDomainName(input: CreateDomainNameRequest): CreateDomainNameResponse

    /**
     * Creates a new domain name.
     */
    suspend fun createDomainName(block: CreateDomainNameRequest.DslBuilder.() -> Unit) = createDomainName(CreateDomainNameRequest.builder().apply(block).build())

    /**
     * Adds a new Model resource to an existing RestApi resource.
     */
    suspend fun createModel(input: CreateModelRequest): CreateModelResponse

    /**
     * Adds a new Model resource to an existing RestApi resource.
     */
    suspend fun createModel(block: CreateModelRequest.DslBuilder.() -> Unit) = createModel(CreateModelRequest.builder().apply(block).build())

    /**
     * Creates a ReqeustValidator of a given RestApi.
     */
    suspend fun createRequestValidator(input: CreateRequestValidatorRequest): CreateRequestValidatorResponse

    /**
     * Creates a ReqeustValidator of a given RestApi.
     */
    suspend fun createRequestValidator(block: CreateRequestValidatorRequest.DslBuilder.() -> Unit) = createRequestValidator(CreateRequestValidatorRequest.builder().apply(block).build())

    /**
     * Creates a Resource resource.
     */
    suspend fun createResource(input: CreateResourceRequest): CreateResourceResponse

    /**
     * Creates a Resource resource.
     */
    suspend fun createResource(block: CreateResourceRequest.DslBuilder.() -> Unit) = createResource(CreateResourceRequest.builder().apply(block).build())

    /**
     * Creates a new RestApi resource.
     */
    suspend fun createRestApi(input: CreateRestApiRequest): CreateRestApiResponse

    /**
     * Creates a new RestApi resource.
     */
    suspend fun createRestApi(block: CreateRestApiRequest.DslBuilder.() -> Unit) = createRestApi(CreateRestApiRequest.builder().apply(block).build())

    /**
     * Creates a new Stage resource that references a pre-existing Deployment for the API.
     * <!--   Creates a Stage resource.  -->
     */
    suspend fun createStage(input: CreateStageRequest): CreateStageResponse

    /**
     * Creates a new Stage resource that references a pre-existing Deployment for the API.
     * <!--   Creates a Stage resource.  -->
     */
    suspend fun createStage(block: CreateStageRequest.DslBuilder.() -> Unit) = createStage(CreateStageRequest.builder().apply(block).build())

    /**
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload.
     */
    suspend fun createUsagePlan(input: CreateUsagePlanRequest): CreateUsagePlanResponse

    /**
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload.
     */
    suspend fun createUsagePlan(block: CreateUsagePlanRequest.DslBuilder.() -> Unit) = createUsagePlan(CreateUsagePlanRequest.builder().apply(block).build())

    /**
     * Creates a usage plan key for adding an existing API key to a usage plan.
     */
    suspend fun createUsagePlanKey(input: CreateUsagePlanKeyRequest): CreateUsagePlanKeyResponse

    /**
     * Creates a usage plan key for adding an existing API key to a usage plan.
     */
    suspend fun createUsagePlanKey(block: CreateUsagePlanKeyRequest.DslBuilder.() -> Unit) = createUsagePlanKey(CreateUsagePlanKeyRequest.builder().apply(block).build())

    /**
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.
     */
    suspend fun createVpcLink(input: CreateVpcLinkRequest): CreateVpcLinkResponse

    /**
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.
     */
    suspend fun createVpcLink(block: CreateVpcLinkRequest.DslBuilder.() -> Unit) = createVpcLink(CreateVpcLinkRequest.builder().apply(block).build())

    /**
     * Deletes the ApiKey resource.
     */
    suspend fun deleteApiKey(input: DeleteApiKeyRequest): DeleteApiKeyResponse

    /**
     * Deletes the ApiKey resource.
     */
    suspend fun deleteApiKey(block: DeleteApiKeyRequest.DslBuilder.() -> Unit) = deleteApiKey(DeleteApiKeyRequest.builder().apply(block).build())

    /**
     * Deletes an existing Authorizer resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</div>
     */
    suspend fun deleteAuthorizer(input: DeleteAuthorizerRequest): DeleteAuthorizerResponse

    /**
     * Deletes an existing Authorizer resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</div>
     */
    suspend fun deleteAuthorizer(block: DeleteAuthorizerRequest.DslBuilder.() -> Unit) = deleteAuthorizer(DeleteAuthorizerRequest.builder().apply(block).build())

    /**
     * Deletes the BasePathMapping resource.
     */
    suspend fun deleteBasePathMapping(input: DeleteBasePathMappingRequest): DeleteBasePathMappingResponse

    /**
     * Deletes the BasePathMapping resource.
     */
    suspend fun deleteBasePathMapping(block: DeleteBasePathMappingRequest.DslBuilder.() -> Unit) = deleteBasePathMapping(DeleteBasePathMappingRequest.builder().apply(block).build())

    /**
     * Deletes the ClientCertificate resource.
     */
    suspend fun deleteClientCertificate(input: DeleteClientCertificateRequest): DeleteClientCertificateResponse

    /**
     * Deletes the ClientCertificate resource.
     */
    suspend fun deleteClientCertificate(block: DeleteClientCertificateRequest.DslBuilder.() -> Unit) = deleteClientCertificate(DeleteClientCertificateRequest.builder().apply(block).build())

    /**
     * Deletes a Deployment resource. Deleting a deployment will only succeed if there are no Stage resources associated with it.
     */
    suspend fun deleteDeployment(input: DeleteDeploymentRequest): DeleteDeploymentResponse

    /**
     * Deletes a Deployment resource. Deleting a deployment will only succeed if there are no Stage resources associated with it.
     */
    suspend fun deleteDeployment(block: DeleteDeploymentRequest.DslBuilder.() -> Unit) = deleteDeployment(DeleteDeploymentRequest.builder().apply(block).build())

    suspend fun deleteDocumentationPart(input: DeleteDocumentationPartRequest): DeleteDocumentationPartResponse

    suspend fun deleteDocumentationPart(block: DeleteDocumentationPartRequest.DslBuilder.() -> Unit) = deleteDocumentationPart(DeleteDocumentationPartRequest.builder().apply(block).build())

    suspend fun deleteDocumentationVersion(input: DeleteDocumentationVersionRequest): DeleteDocumentationVersionResponse

    suspend fun deleteDocumentationVersion(block: DeleteDocumentationVersionRequest.DslBuilder.() -> Unit) = deleteDocumentationVersion(DeleteDocumentationVersionRequest.builder().apply(block).build())

    /**
     * Deletes the DomainName resource.
     */
    suspend fun deleteDomainName(input: DeleteDomainNameRequest): DeleteDomainNameResponse

    /**
     * Deletes the DomainName resource.
     */
    suspend fun deleteDomainName(block: DeleteDomainNameRequest.DslBuilder.() -> Unit) = deleteDomainName(DeleteDomainNameRequest.builder().apply(block).build())

    /**
     * Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it with the default settings.
     */
    suspend fun deleteGatewayResponse(input: DeleteGatewayResponseRequest): DeleteGatewayResponseResponse

    /**
     * Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it with the default settings.
     */
    suspend fun deleteGatewayResponse(block: DeleteGatewayResponseRequest.DslBuilder.() -> Unit) = deleteGatewayResponse(DeleteGatewayResponseRequest.builder().apply(block).build())

    /**
     * Represents a delete integration.
     */
    suspend fun deleteIntegration(input: DeleteIntegrationRequest): DeleteIntegrationResponse

    /**
     * Represents a delete integration.
     */
    suspend fun deleteIntegration(block: DeleteIntegrationRequest.DslBuilder.() -> Unit) = deleteIntegration(DeleteIntegrationRequest.builder().apply(block).build())

    /**
     * Represents a delete integration response.
     */
    suspend fun deleteIntegrationResponse(input: DeleteIntegrationResponseRequest): DeleteIntegrationResponseResponse

    /**
     * Represents a delete integration response.
     */
    suspend fun deleteIntegrationResponse(block: DeleteIntegrationResponseRequest.DslBuilder.() -> Unit) = deleteIntegrationResponse(DeleteIntegrationResponseRequest.builder().apply(block).build())

    /**
     * Deletes an existing Method resource.
     */
    suspend fun deleteMethod(input: DeleteMethodRequest): DeleteMethodResponse

    /**
     * Deletes an existing Method resource.
     */
    suspend fun deleteMethod(block: DeleteMethodRequest.DslBuilder.() -> Unit) = deleteMethod(DeleteMethodRequest.builder().apply(block).build())

    /**
     * Deletes an existing MethodResponse resource.
     */
    suspend fun deleteMethodResponse(input: DeleteMethodResponseRequest): DeleteMethodResponseResponse

    /**
     * Deletes an existing MethodResponse resource.
     */
    suspend fun deleteMethodResponse(block: DeleteMethodResponseRequest.DslBuilder.() -> Unit) = deleteMethodResponse(DeleteMethodResponseRequest.builder().apply(block).build())

    /**
     * Deletes a model.
     */
    suspend fun deleteModel(input: DeleteModelRequest): DeleteModelResponse

    /**
     * Deletes a model.
     */
    suspend fun deleteModel(block: DeleteModelRequest.DslBuilder.() -> Unit) = deleteModel(DeleteModelRequest.builder().apply(block).build())

    /**
     * Deletes a RequestValidator of a given RestApi.
     */
    suspend fun deleteRequestValidator(input: DeleteRequestValidatorRequest): DeleteRequestValidatorResponse

    /**
     * Deletes a RequestValidator of a given RestApi.
     */
    suspend fun deleteRequestValidator(block: DeleteRequestValidatorRequest.DslBuilder.() -> Unit) = deleteRequestValidator(DeleteRequestValidatorRequest.builder().apply(block).build())

    /**
     * Deletes a Resource resource.
     */
    suspend fun deleteResource(input: DeleteResourceRequest): DeleteResourceResponse

    /**
     * Deletes a Resource resource.
     */
    suspend fun deleteResource(block: DeleteResourceRequest.DslBuilder.() -> Unit) = deleteResource(DeleteResourceRequest.builder().apply(block).build())

    /**
     * Deletes the specified API.
     */
    suspend fun deleteRestApi(input: DeleteRestApiRequest): DeleteRestApiResponse

    /**
     * Deletes the specified API.
     */
    suspend fun deleteRestApi(block: DeleteRestApiRequest.DslBuilder.() -> Unit) = deleteRestApi(DeleteRestApiRequest.builder().apply(block).build())

    /**
     * Deletes a Stage resource.
     */
    suspend fun deleteStage(input: DeleteStageRequest): DeleteStageResponse

    /**
     * Deletes a Stage resource.
     */
    suspend fun deleteStage(block: DeleteStageRequest.DslBuilder.() -> Unit) = deleteStage(DeleteStageRequest.builder().apply(block).build())

    /**
     * Deletes a usage plan of a given plan Id.
     */
    suspend fun deleteUsagePlan(input: DeleteUsagePlanRequest): DeleteUsagePlanResponse

    /**
     * Deletes a usage plan of a given plan Id.
     */
    suspend fun deleteUsagePlan(block: DeleteUsagePlanRequest.DslBuilder.() -> Unit) = deleteUsagePlan(DeleteUsagePlanRequest.builder().apply(block).build())

    /**
     * Deletes a usage plan key  and remove the underlying API key from the associated usage plan.
     */
    suspend fun deleteUsagePlanKey(input: DeleteUsagePlanKeyRequest): DeleteUsagePlanKeyResponse

    /**
     * Deletes a usage plan key  and remove the underlying API key from the associated usage plan.
     */
    suspend fun deleteUsagePlanKey(block: DeleteUsagePlanKeyRequest.DslBuilder.() -> Unit) = deleteUsagePlanKey(DeleteUsagePlanKeyRequest.builder().apply(block).build())

    /**
     * Deletes an existing VpcLink of a specified identifier.
     */
    suspend fun deleteVpcLink(input: DeleteVpcLinkRequest): DeleteVpcLinkResponse

    /**
     * Deletes an existing VpcLink of a specified identifier.
     */
    suspend fun deleteVpcLink(block: DeleteVpcLinkRequest.DslBuilder.() -> Unit) = deleteVpcLink(DeleteVpcLinkRequest.builder().apply(block).build())

    /**
     * Flushes all authorizer cache entries on a stage.
     */
    suspend fun flushStageAuthorizersCache(input: FlushStageAuthorizersCacheRequest): FlushStageAuthorizersCacheResponse

    /**
     * Flushes all authorizer cache entries on a stage.
     */
    suspend fun flushStageAuthorizersCache(block: FlushStageAuthorizersCacheRequest.DslBuilder.() -> Unit) = flushStageAuthorizersCache(FlushStageAuthorizersCacheRequest.builder().apply(block).build())

    /**
     * Flushes a stage's cache.
     */
    suspend fun flushStageCache(input: FlushStageCacheRequest): FlushStageCacheResponse

    /**
     * Flushes a stage's cache.
     */
    suspend fun flushStageCache(block: FlushStageCacheRequest.DslBuilder.() -> Unit) = flushStageCache(FlushStageCacheRequest.builder().apply(block).build())

    /**
     * Generates a ClientCertificate resource.
     */
    suspend fun generateClientCertificate(input: GenerateClientCertificateRequest): GenerateClientCertificateResponse

    /**
     * Generates a ClientCertificate resource.
     */
    suspend fun generateClientCertificate(block: GenerateClientCertificateRequest.DslBuilder.() -> Unit) = generateClientCertificate(GenerateClientCertificateRequest.builder().apply(block).build())

    /**
     * Gets information about the current Account resource.
     */
    suspend fun getAccount(input: GetAccountRequest): GetAccountResponse

    /**
     * Gets information about the current Account resource.
     */
    suspend fun getAccount(block: GetAccountRequest.DslBuilder.() -> Unit) = getAccount(GetAccountRequest.builder().apply(block).build())

    /**
     * Gets information about the current ApiKey resource.
     */
    suspend fun getApiKey(input: GetApiKeyRequest): GetApiKeyResponse

    /**
     * Gets information about the current ApiKey resource.
     */
    suspend fun getApiKey(block: GetApiKeyRequest.DslBuilder.() -> Unit) = getApiKey(GetApiKeyRequest.builder().apply(block).build())

    /**
     * Gets information about the current ApiKeys resource.
     */
    suspend fun getApiKeys(input: GetApiKeysRequest): GetApiKeysResponse

    /**
     * Gets information about the current ApiKeys resource.
     */
    suspend fun getApiKeys(block: GetApiKeysRequest.DslBuilder.() -> Unit) = getApiKeys(GetApiKeysRequest.builder().apply(block).build())

    /**
     * Describe an existing Authorizer resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</div>
     */
    suspend fun getAuthorizer(input: GetAuthorizerRequest): GetAuthorizerResponse

    /**
     * Describe an existing Authorizer resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</div>
     */
    suspend fun getAuthorizer(block: GetAuthorizerRequest.DslBuilder.() -> Unit) = getAuthorizer(GetAuthorizerRequest.builder().apply(block).build())

    /**
     * Describe an existing Authorizers resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</div>
     */
    suspend fun getAuthorizers(input: GetAuthorizersRequest): GetAuthorizersResponse

    /**
     * Describe an existing Authorizers resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</div>
     */
    suspend fun getAuthorizers(block: GetAuthorizersRequest.DslBuilder.() -> Unit) = getAuthorizers(GetAuthorizersRequest.builder().apply(block).build())

    /**
     * Describe a BasePathMapping resource.
     */
    suspend fun getBasePathMapping(input: GetBasePathMappingRequest): GetBasePathMappingResponse

    /**
     * Describe a BasePathMapping resource.
     */
    suspend fun getBasePathMapping(block: GetBasePathMappingRequest.DslBuilder.() -> Unit) = getBasePathMapping(GetBasePathMappingRequest.builder().apply(block).build())

    /**
     * Represents a collection of BasePathMapping resources.
     */
    suspend fun getBasePathMappings(input: GetBasePathMappingsRequest): GetBasePathMappingsResponse

    /**
     * Represents a collection of BasePathMapping resources.
     */
    suspend fun getBasePathMappings(block: GetBasePathMappingsRequest.DslBuilder.() -> Unit) = getBasePathMappings(GetBasePathMappingsRequest.builder().apply(block).build())

    /**
     * Gets information about the current ClientCertificate resource.
     */
    suspend fun getClientCertificate(input: GetClientCertificateRequest): GetClientCertificateResponse

    /**
     * Gets information about the current ClientCertificate resource.
     */
    suspend fun getClientCertificate(block: GetClientCertificateRequest.DslBuilder.() -> Unit) = getClientCertificate(GetClientCertificateRequest.builder().apply(block).build())

    /**
     * Gets a collection of ClientCertificate resources.
     */
    suspend fun getClientCertificates(input: GetClientCertificatesRequest): GetClientCertificatesResponse

    /**
     * Gets a collection of ClientCertificate resources.
     */
    suspend fun getClientCertificates(block: GetClientCertificatesRequest.DslBuilder.() -> Unit) = getClientCertificates(GetClientCertificatesRequest.builder().apply(block).build())

    /**
     * Gets information about a Deployment resource.
     */
    suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse

    /**
     * Gets information about a Deployment resource.
     */
    suspend fun getDeployment(block: GetDeploymentRequest.DslBuilder.() -> Unit) = getDeployment(GetDeploymentRequest.builder().apply(block).build())

    /**
     * Gets information about a Deployments collection.
     */
    suspend fun getDeployments(input: GetDeploymentsRequest): GetDeploymentsResponse

    /**
     * Gets information about a Deployments collection.
     */
    suspend fun getDeployments(block: GetDeploymentsRequest.DslBuilder.() -> Unit) = getDeployments(GetDeploymentsRequest.builder().apply(block).build())

    suspend fun getDocumentationPart(input: GetDocumentationPartRequest): GetDocumentationPartResponse

    suspend fun getDocumentationPart(block: GetDocumentationPartRequest.DslBuilder.() -> Unit) = getDocumentationPart(GetDocumentationPartRequest.builder().apply(block).build())

    suspend fun getDocumentationParts(input: GetDocumentationPartsRequest): GetDocumentationPartsResponse

    suspend fun getDocumentationParts(block: GetDocumentationPartsRequest.DslBuilder.() -> Unit) = getDocumentationParts(GetDocumentationPartsRequest.builder().apply(block).build())

    suspend fun getDocumentationVersion(input: GetDocumentationVersionRequest): GetDocumentationVersionResponse

    suspend fun getDocumentationVersion(block: GetDocumentationVersionRequest.DslBuilder.() -> Unit) = getDocumentationVersion(GetDocumentationVersionRequest.builder().apply(block).build())

    suspend fun getDocumentationVersions(input: GetDocumentationVersionsRequest): GetDocumentationVersionsResponse

    suspend fun getDocumentationVersions(block: GetDocumentationVersionsRequest.DslBuilder.() -> Unit) = getDocumentationVersions(GetDocumentationVersionsRequest.builder().apply(block).build())

    /**
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     */
    suspend fun getDomainName(input: GetDomainNameRequest): GetDomainNameResponse

    /**
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     */
    suspend fun getDomainName(block: GetDomainNameRequest.DslBuilder.() -> Unit) = getDomainName(GetDomainNameRequest.builder().apply(block).build())

    /**
     * Represents a collection of DomainName resources.
     */
    suspend fun getDomainNames(input: GetDomainNamesRequest): GetDomainNamesResponse

    /**
     * Represents a collection of DomainName resources.
     */
    suspend fun getDomainNames(block: GetDomainNamesRequest.DslBuilder.() -> Unit) = getDomainNames(GetDomainNamesRequest.builder().apply(block).build())

    /**
     * Exports a deployed version of a RestApi in a specified format.
     */
    suspend fun getExport(input: GetExportRequest): GetExportResponse

    /**
     * Exports a deployed version of a RestApi in a specified format.
     */
    suspend fun getExport(block: GetExportRequest.DslBuilder.() -> Unit) = getExport(GetExportRequest.builder().apply(block).build())

    /**
     * Gets a GatewayResponse of a specified response type on the given RestApi.
     */
    suspend fun getGatewayResponse(input: GetGatewayResponseRequest): GetGatewayResponseResponse

    /**
     * Gets a GatewayResponse of a specified response type on the given RestApi.
     */
    suspend fun getGatewayResponse(block: GetGatewayResponseRequest.DslBuilder.() -> Unit) = getGatewayResponse(GetGatewayResponseRequest.builder().apply(block).build())

    /**
     * Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the supported response types.
     */
    suspend fun getGatewayResponses(input: GetGatewayResponsesRequest): GetGatewayResponsesResponse

    /**
     * Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the supported response types.
     */
    suspend fun getGatewayResponses(block: GetGatewayResponsesRequest.DslBuilder.() -> Unit) = getGatewayResponses(GetGatewayResponsesRequest.builder().apply(block).build())

    /**
     * Get the integration settings.
     */
    suspend fun getIntegration(input: GetIntegrationRequest): GetIntegrationResponse

    /**
     * Get the integration settings.
     */
    suspend fun getIntegration(block: GetIntegrationRequest.DslBuilder.() -> Unit) = getIntegration(GetIntegrationRequest.builder().apply(block).build())

    /**
     * Represents a get integration response.
     */
    suspend fun getIntegrationResponse(input: GetIntegrationResponseRequest): GetIntegrationResponseResponse

    /**
     * Represents a get integration response.
     */
    suspend fun getIntegrationResponse(block: GetIntegrationResponseRequest.DslBuilder.() -> Unit) = getIntegrationResponse(GetIntegrationResponseRequest.builder().apply(block).build())

    /**
     * Describe an existing Method resource.
     */
    suspend fun getMethod(input: GetMethodRequest): GetMethodResponse

    /**
     * Describe an existing Method resource.
     */
    suspend fun getMethod(block: GetMethodRequest.DslBuilder.() -> Unit) = getMethod(GetMethodRequest.builder().apply(block).build())

    /**
     * Describes a MethodResponse resource.
     */
    suspend fun getMethodResponse(input: GetMethodResponseRequest): GetMethodResponseResponse

    /**
     * Describes a MethodResponse resource.
     */
    suspend fun getMethodResponse(block: GetMethodResponseRequest.DslBuilder.() -> Unit) = getMethodResponse(GetMethodResponseRequest.builder().apply(block).build())

    /**
     * Describes an existing model defined for a RestApi resource.
     */
    suspend fun getModel(input: GetModelRequest): GetModelResponse

    /**
     * Describes an existing model defined for a RestApi resource.
     */
    suspend fun getModel(block: GetModelRequest.DslBuilder.() -> Unit) = getModel(GetModelRequest.builder().apply(block).build())

    /**
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     */
    suspend fun getModelTemplate(input: GetModelTemplateRequest): GetModelTemplateResponse

    /**
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     */
    suspend fun getModelTemplate(block: GetModelTemplateRequest.DslBuilder.() -> Unit) = getModelTemplate(GetModelTemplateRequest.builder().apply(block).build())

    /**
     * Describes existing Models defined for a RestApi resource.
     */
    suspend fun getModels(input: GetModelsRequest): GetModelsResponse

    /**
     * Describes existing Models defined for a RestApi resource.
     */
    suspend fun getModels(block: GetModelsRequest.DslBuilder.() -> Unit) = getModels(GetModelsRequest.builder().apply(block).build())

    /**
     * Gets a RequestValidator of a given RestApi.
     */
    suspend fun getRequestValidator(input: GetRequestValidatorRequest): GetRequestValidatorResponse

    /**
     * Gets a RequestValidator of a given RestApi.
     */
    suspend fun getRequestValidator(block: GetRequestValidatorRequest.DslBuilder.() -> Unit) = getRequestValidator(GetRequestValidatorRequest.builder().apply(block).build())

    /**
     * Gets the RequestValidators collection of a given RestApi.
     */
    suspend fun getRequestValidators(input: GetRequestValidatorsRequest): GetRequestValidatorsResponse

    /**
     * Gets the RequestValidators collection of a given RestApi.
     */
    suspend fun getRequestValidators(block: GetRequestValidatorsRequest.DslBuilder.() -> Unit) = getRequestValidators(GetRequestValidatorsRequest.builder().apply(block).build())

    /**
     * Lists information about a resource.
     */
    suspend fun getResource(input: GetResourceRequest): GetResourceResponse

    /**
     * Lists information about a resource.
     */
    suspend fun getResource(block: GetResourceRequest.DslBuilder.() -> Unit) = getResource(GetResourceRequest.builder().apply(block).build())

    /**
     * Lists information about a collection of Resource resources.
     */
    suspend fun getResources(input: GetResourcesRequest): GetResourcesResponse

    /**
     * Lists information about a collection of Resource resources.
     */
    suspend fun getResources(block: GetResourcesRequest.DslBuilder.() -> Unit) = getResources(GetResourcesRequest.builder().apply(block).build())

    /**
     * Lists the RestApi resource in the collection.
     */
    suspend fun getRestApi(input: GetRestApiRequest): GetRestApiResponse

    /**
     * Lists the RestApi resource in the collection.
     */
    suspend fun getRestApi(block: GetRestApiRequest.DslBuilder.() -> Unit) = getRestApi(GetRestApiRequest.builder().apply(block).build())

    /**
     * Lists the RestApis resources for your collection.
     */
    suspend fun getRestApis(input: GetRestApisRequest): GetRestApisResponse

    /**
     * Lists the RestApis resources for your collection.
     */
    suspend fun getRestApis(block: GetRestApisRequest.DslBuilder.() -> Unit) = getRestApis(GetRestApisRequest.builder().apply(block).build())

    /**
     * Generates a client SDK for a RestApi and Stage.
     */
    suspend fun getSdk(input: GetSdkRequest): GetSdkResponse

    /**
     * Generates a client SDK for a RestApi and Stage.
     */
    suspend fun getSdk(block: GetSdkRequest.DslBuilder.() -> Unit) = getSdk(GetSdkRequest.builder().apply(block).build())

    suspend fun getSdkType(input: GetSdkTypeRequest): GetSdkTypeResponse

    suspend fun getSdkType(block: GetSdkTypeRequest.DslBuilder.() -> Unit) = getSdkType(GetSdkTypeRequest.builder().apply(block).build())

    suspend fun getSdkTypes(input: GetSdkTypesRequest): GetSdkTypesResponse

    suspend fun getSdkTypes(block: GetSdkTypesRequest.DslBuilder.() -> Unit) = getSdkTypes(GetSdkTypesRequest.builder().apply(block).build())

    /**
     * Gets information about a Stage resource.
     */
    suspend fun getStage(input: GetStageRequest): GetStageResponse

    /**
     * Gets information about a Stage resource.
     */
    suspend fun getStage(block: GetStageRequest.DslBuilder.() -> Unit) = getStage(GetStageRequest.builder().apply(block).build())

    /**
     * Gets information about one or more Stage resources.
     */
    suspend fun getStages(input: GetStagesRequest): GetStagesResponse

    /**
     * Gets information about one or more Stage resources.
     */
    suspend fun getStages(block: GetStagesRequest.DslBuilder.() -> Unit) = getStages(GetStagesRequest.builder().apply(block).build())

    /**
     * Gets the Tags collection for a given resource.
     */
    suspend fun getTags(input: GetTagsRequest): GetTagsResponse

    /**
     * Gets the Tags collection for a given resource.
     */
    suspend fun getTags(block: GetTagsRequest.DslBuilder.() -> Unit) = getTags(GetTagsRequest.builder().apply(block).build())

    /**
     * Gets the usage data of a usage plan in a specified time interval.
     */
    suspend fun getUsage(input: GetUsageRequest): GetUsageResponse

    /**
     * Gets the usage data of a usage plan in a specified time interval.
     */
    suspend fun getUsage(block: GetUsageRequest.DslBuilder.() -> Unit) = getUsage(GetUsageRequest.builder().apply(block).build())

    /**
     * Gets a usage plan of a given plan identifier.
     */
    suspend fun getUsagePlan(input: GetUsagePlanRequest): GetUsagePlanResponse

    /**
     * Gets a usage plan of a given plan identifier.
     */
    suspend fun getUsagePlan(block: GetUsagePlanRequest.DslBuilder.() -> Unit) = getUsagePlan(GetUsagePlanRequest.builder().apply(block).build())

    /**
     * Gets a usage plan key of a given key identifier.
     */
    suspend fun getUsagePlanKey(input: GetUsagePlanKeyRequest): GetUsagePlanKeyResponse

    /**
     * Gets a usage plan key of a given key identifier.
     */
    suspend fun getUsagePlanKey(block: GetUsagePlanKeyRequest.DslBuilder.() -> Unit) = getUsagePlanKey(GetUsagePlanKeyRequest.builder().apply(block).build())

    /**
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     */
    suspend fun getUsagePlanKeys(input: GetUsagePlanKeysRequest): GetUsagePlanKeysResponse

    /**
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     */
    suspend fun getUsagePlanKeys(block: GetUsagePlanKeysRequest.DslBuilder.() -> Unit) = getUsagePlanKeys(GetUsagePlanKeysRequest.builder().apply(block).build())

    /**
     * Gets all the usage plans of the caller's account.
     */
    suspend fun getUsagePlans(input: GetUsagePlansRequest): GetUsagePlansResponse

    /**
     * Gets all the usage plans of the caller's account.
     */
    suspend fun getUsagePlans(block: GetUsagePlansRequest.DslBuilder.() -> Unit) = getUsagePlans(GetUsagePlansRequest.builder().apply(block).build())

    /**
     * Gets a specified VPC link under the caller's account in a region.
     */
    suspend fun getVpcLink(input: GetVpcLinkRequest): GetVpcLinkResponse

    /**
     * Gets a specified VPC link under the caller's account in a region.
     */
    suspend fun getVpcLink(block: GetVpcLinkRequest.DslBuilder.() -> Unit) = getVpcLink(GetVpcLinkRequest.builder().apply(block).build())

    /**
     * Gets the VpcLinks collection under the caller's account in a selected region.
     */
    suspend fun getVpcLinks(input: GetVpcLinksRequest): GetVpcLinksResponse

    /**
     * Gets the VpcLinks collection under the caller's account in a selected region.
     */
    suspend fun getVpcLinks(block: GetVpcLinksRequest.DslBuilder.() -> Unit) = getVpcLinks(GetVpcLinksRequest.builder().apply(block).build())

    /**
     * Import API keys from an external source, such as a CSV-formatted file.
     */
    suspend fun importApiKeys(input: ImportApiKeysRequest): ImportApiKeysResponse

    /**
     * Import API keys from an external source, such as a CSV-formatted file.
     */
    suspend fun importApiKeys(block: ImportApiKeysRequest.DslBuilder.() -> Unit) = importApiKeys(ImportApiKeysRequest.builder().apply(block).build())

    suspend fun importDocumentationParts(input: ImportDocumentationPartsRequest): ImportDocumentationPartsResponse

    suspend fun importDocumentationParts(block: ImportDocumentationPartsRequest.DslBuilder.() -> Unit) = importDocumentationParts(ImportDocumentationPartsRequest.builder().apply(block).build())

    /**
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     */
    suspend fun importRestApi(input: ImportRestApiRequest): ImportRestApiResponse

    /**
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     */
    suspend fun importRestApi(block: ImportRestApiRequest.DslBuilder.() -> Unit) = importRestApi(ImportRestApiRequest.builder().apply(block).build())

    /**
     * Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.
     */
    suspend fun putGatewayResponse(input: PutGatewayResponseRequest): PutGatewayResponseResponse

    /**
     * Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.
     */
    suspend fun putGatewayResponse(block: PutGatewayResponseRequest.DslBuilder.() -> Unit) = putGatewayResponse(PutGatewayResponseRequest.builder().apply(block).build())

    /**
     * Sets up a method's integration.
     */
    suspend fun putIntegration(input: PutIntegrationRequest): PutIntegrationResponse

    /**
     * Sets up a method's integration.
     */
    suspend fun putIntegration(block: PutIntegrationRequest.DslBuilder.() -> Unit) = putIntegration(PutIntegrationRequest.builder().apply(block).build())

    /**
     * Represents a put integration.
     */
    suspend fun putIntegrationResponse(input: PutIntegrationResponseRequest): PutIntegrationResponseResponse

    /**
     * Represents a put integration.
     */
    suspend fun putIntegrationResponse(block: PutIntegrationResponseRequest.DslBuilder.() -> Unit) = putIntegrationResponse(PutIntegrationResponseRequest.builder().apply(block).build())

    /**
     * Add a method to an existing Resource resource.
     */
    suspend fun putMethod(input: PutMethodRequest): PutMethodResponse

    /**
     * Add a method to an existing Resource resource.
     */
    suspend fun putMethod(block: PutMethodRequest.DslBuilder.() -> Unit) = putMethod(PutMethodRequest.builder().apply(block).build())

    /**
     * Adds a MethodResponse to an existing Method resource.
     */
    suspend fun putMethodResponse(input: PutMethodResponseRequest): PutMethodResponseResponse

    /**
     * Adds a MethodResponse to an existing Method resource.
     */
    suspend fun putMethodResponse(block: PutMethodResponseRequest.DslBuilder.() -> Unit) = putMethodResponse(PutMethodResponseRequest.builder().apply(block).build())

    /**
     * A feature of the API Gateway control service for updating an existing API with an input of external API definitions.
     * The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.
     */
    suspend fun putRestApi(input: PutRestApiRequest): PutRestApiResponse

    /**
     * A feature of the API Gateway control service for updating an existing API with an input of external API definitions.
     * The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.
     */
    suspend fun putRestApi(block: PutRestApiRequest.DslBuilder.() -> Unit) = putRestApi(PutRestApiRequest.builder().apply(block).build())

    /**
     * Adds or updates a tag on a given resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds or updates a tag on a given resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Simulate the execution of an Authorizer in your RestApi with headers, parameters, and an incoming request body.
     * <div class="seeAlso">
     * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer
     * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer
     * </div>
     */
    suspend fun testInvokeAuthorizer(input: TestInvokeAuthorizerRequest): TestInvokeAuthorizerResponse

    /**
     * Simulate the execution of an Authorizer in your RestApi with headers, parameters, and an incoming request body.
     * <div class="seeAlso">
     * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer
     * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer
     * </div>
     */
    suspend fun testInvokeAuthorizer(block: TestInvokeAuthorizerRequest.DslBuilder.() -> Unit) = testInvokeAuthorizer(TestInvokeAuthorizerRequest.builder().apply(block).build())

    /**
     * Simulate the execution of a Method in your RestApi with headers, parameters, and an incoming request body.
     */
    suspend fun testInvokeMethod(input: TestInvokeMethodRequest): TestInvokeMethodResponse

    /**
     * Simulate the execution of a Method in your RestApi with headers, parameters, and an incoming request body.
     */
    suspend fun testInvokeMethod(block: TestInvokeMethodRequest.DslBuilder.() -> Unit) = testInvokeMethod(TestInvokeMethodRequest.builder().apply(block).build())

    /**
     * Removes a tag from a given resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from a given resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Changes information about the current Account resource.
     */
    suspend fun updateAccount(input: UpdateAccountRequest): UpdateAccountResponse

    /**
     * Changes information about the current Account resource.
     */
    suspend fun updateAccount(block: UpdateAccountRequest.DslBuilder.() -> Unit) = updateAccount(UpdateAccountRequest.builder().apply(block).build())

    /**
     * Changes information about an ApiKey resource.
     */
    suspend fun updateApiKey(input: UpdateApiKeyRequest): UpdateApiKeyResponse

    /**
     * Changes information about an ApiKey resource.
     */
    suspend fun updateApiKey(block: UpdateApiKeyRequest.DslBuilder.() -> Unit) = updateApiKey(UpdateApiKeyRequest.builder().apply(block).build())

    /**
     * Updates an existing Authorizer resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</div>
     */
    suspend fun updateAuthorizer(input: UpdateAuthorizerRequest): UpdateAuthorizerResponse

    /**
     * Updates an existing Authorizer resource.
     * <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</div>
     */
    suspend fun updateAuthorizer(block: UpdateAuthorizerRequest.DslBuilder.() -> Unit) = updateAuthorizer(UpdateAuthorizerRequest.builder().apply(block).build())

    /**
     * Changes information about the BasePathMapping resource.
     */
    suspend fun updateBasePathMapping(input: UpdateBasePathMappingRequest): UpdateBasePathMappingResponse

    /**
     * Changes information about the BasePathMapping resource.
     */
    suspend fun updateBasePathMapping(block: UpdateBasePathMappingRequest.DslBuilder.() -> Unit) = updateBasePathMapping(UpdateBasePathMappingRequest.builder().apply(block).build())

    /**
     * Changes information about an ClientCertificate resource.
     */
    suspend fun updateClientCertificate(input: UpdateClientCertificateRequest): UpdateClientCertificateResponse

    /**
     * Changes information about an ClientCertificate resource.
     */
    suspend fun updateClientCertificate(block: UpdateClientCertificateRequest.DslBuilder.() -> Unit) = updateClientCertificate(UpdateClientCertificateRequest.builder().apply(block).build())

    /**
     * Changes information about a Deployment resource.
     */
    suspend fun updateDeployment(input: UpdateDeploymentRequest): UpdateDeploymentResponse

    /**
     * Changes information about a Deployment resource.
     */
    suspend fun updateDeployment(block: UpdateDeploymentRequest.DslBuilder.() -> Unit) = updateDeployment(UpdateDeploymentRequest.builder().apply(block).build())

    suspend fun updateDocumentationPart(input: UpdateDocumentationPartRequest): UpdateDocumentationPartResponse

    suspend fun updateDocumentationPart(block: UpdateDocumentationPartRequest.DslBuilder.() -> Unit) = updateDocumentationPart(UpdateDocumentationPartRequest.builder().apply(block).build())

    suspend fun updateDocumentationVersion(input: UpdateDocumentationVersionRequest): UpdateDocumentationVersionResponse

    suspend fun updateDocumentationVersion(block: UpdateDocumentationVersionRequest.DslBuilder.() -> Unit) = updateDocumentationVersion(UpdateDocumentationVersionRequest.builder().apply(block).build())

    /**
     * Changes information about the DomainName resource.
     */
    suspend fun updateDomainName(input: UpdateDomainNameRequest): UpdateDomainNameResponse

    /**
     * Changes information about the DomainName resource.
     */
    suspend fun updateDomainName(block: UpdateDomainNameRequest.DslBuilder.() -> Unit) = updateDomainName(UpdateDomainNameRequest.builder().apply(block).build())

    /**
     * Updates a GatewayResponse of a specified response type on the given RestApi.
     */
    suspend fun updateGatewayResponse(input: UpdateGatewayResponseRequest): UpdateGatewayResponseResponse

    /**
     * Updates a GatewayResponse of a specified response type on the given RestApi.
     */
    suspend fun updateGatewayResponse(block: UpdateGatewayResponseRequest.DslBuilder.() -> Unit) = updateGatewayResponse(UpdateGatewayResponseRequest.builder().apply(block).build())

    /**
     * Represents an update integration.
     */
    suspend fun updateIntegration(input: UpdateIntegrationRequest): UpdateIntegrationResponse

    /**
     * Represents an update integration.
     */
    suspend fun updateIntegration(block: UpdateIntegrationRequest.DslBuilder.() -> Unit) = updateIntegration(UpdateIntegrationRequest.builder().apply(block).build())

    /**
     * Represents an update integration response.
     */
    suspend fun updateIntegrationResponse(input: UpdateIntegrationResponseRequest): UpdateIntegrationResponseResponse

    /**
     * Represents an update integration response.
     */
    suspend fun updateIntegrationResponse(block: UpdateIntegrationResponseRequest.DslBuilder.() -> Unit) = updateIntegrationResponse(UpdateIntegrationResponseRequest.builder().apply(block).build())

    /**
     * Updates an existing Method resource.
     */
    suspend fun updateMethod(input: UpdateMethodRequest): UpdateMethodResponse

    /**
     * Updates an existing Method resource.
     */
    suspend fun updateMethod(block: UpdateMethodRequest.DslBuilder.() -> Unit) = updateMethod(UpdateMethodRequest.builder().apply(block).build())

    /**
     * Updates an existing MethodResponse resource.
     */
    suspend fun updateMethodResponse(input: UpdateMethodResponseRequest): UpdateMethodResponseResponse

    /**
     * Updates an existing MethodResponse resource.
     */
    suspend fun updateMethodResponse(block: UpdateMethodResponseRequest.DslBuilder.() -> Unit) = updateMethodResponse(UpdateMethodResponseRequest.builder().apply(block).build())

    /**
     * Changes information about a model.
     */
    suspend fun updateModel(input: UpdateModelRequest): UpdateModelResponse

    /**
     * Changes information about a model.
     */
    suspend fun updateModel(block: UpdateModelRequest.DslBuilder.() -> Unit) = updateModel(UpdateModelRequest.builder().apply(block).build())

    /**
     * Updates a RequestValidator of a given RestApi.
     */
    suspend fun updateRequestValidator(input: UpdateRequestValidatorRequest): UpdateRequestValidatorResponse

    /**
     * Updates a RequestValidator of a given RestApi.
     */
    suspend fun updateRequestValidator(block: UpdateRequestValidatorRequest.DslBuilder.() -> Unit) = updateRequestValidator(UpdateRequestValidatorRequest.builder().apply(block).build())

    /**
     * Changes information about a Resource resource.
     */
    suspend fun updateResource(input: UpdateResourceRequest): UpdateResourceResponse

    /**
     * Changes information about a Resource resource.
     */
    suspend fun updateResource(block: UpdateResourceRequest.DslBuilder.() -> Unit) = updateResource(UpdateResourceRequest.builder().apply(block).build())

    /**
     * Changes information about the specified API.
     */
    suspend fun updateRestApi(input: UpdateRestApiRequest): UpdateRestApiResponse

    /**
     * Changes information about the specified API.
     */
    suspend fun updateRestApi(block: UpdateRestApiRequest.DslBuilder.() -> Unit) = updateRestApi(UpdateRestApiRequest.builder().apply(block).build())

    /**
     * Changes information about a Stage resource.
     */
    suspend fun updateStage(input: UpdateStageRequest): UpdateStageResponse

    /**
     * Changes information about a Stage resource.
     */
    suspend fun updateStage(block: UpdateStageRequest.DslBuilder.() -> Unit) = updateStage(UpdateStageRequest.builder().apply(block).build())

    /**
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     */
    suspend fun updateUsage(input: UpdateUsageRequest): UpdateUsageResponse

    /**
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     */
    suspend fun updateUsage(block: UpdateUsageRequest.DslBuilder.() -> Unit) = updateUsage(UpdateUsageRequest.builder().apply(block).build())

    /**
     * Updates a usage plan of a given plan Id.
     */
    suspend fun updateUsagePlan(input: UpdateUsagePlanRequest): UpdateUsagePlanResponse

    /**
     * Updates a usage plan of a given plan Id.
     */
    suspend fun updateUsagePlan(block: UpdateUsagePlanRequest.DslBuilder.() -> Unit) = updateUsagePlan(UpdateUsagePlanRequest.builder().apply(block).build())

    /**
     * Updates an existing VpcLink of a specified identifier.
     */
    suspend fun updateVpcLink(input: UpdateVpcLinkRequest): UpdateVpcLinkResponse

    /**
     * Updates an existing VpcLink of a specified identifier.
     */
    suspend fun updateVpcLink(block: UpdateVpcLinkRequest.DslBuilder.() -> Unit) = updateVpcLink(UpdateVpcLinkRequest.builder().apply(block).build())
}
