// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.UpdateBasePathMappingResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBasePathMappingOperationDeserializer: HttpDeserializer.NonStreaming<UpdateBasePathMappingResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateBasePathMappingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateBasePathMappingError(context, call, payload)
        }
        val builder = UpdateBasePathMappingResponse.Builder()

        if (payload != null) {
            deserializeUpdateBasePathMappingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateBasePathMappingError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateBasePathMappingOperationBody(builder: UpdateBasePathMappingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("basePath"))
    val RESTAPIID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("restApiId"))
    val STAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASEPATH_DESCRIPTOR)
        field(RESTAPIID_DESCRIPTOR)
        field(STAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASEPATH_DESCRIPTOR.index -> builder.basePath = deserializeString()
                RESTAPIID_DESCRIPTOR.index -> builder.restApiId = deserializeString()
                STAGE_DESCRIPTOR.index -> builder.stage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
