// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class TestInvokeMethodOperationDeserializer: HttpDeserializer.NonStreaming<TestInvokeMethodResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): TestInvokeMethodResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwTestInvokeMethodError(context, call, payload)
        }
        val builder = TestInvokeMethodResponse.Builder()

        if (payload != null) {
            deserializeTestInvokeMethodOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwTestInvokeMethodError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeTestInvokeMethodOperationBody(builder: TestInvokeMethodResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("body"))
    val HEADERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("headers"))
    val LATENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("latency"))
    val LOG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("log"))
    val MULTIVALUEHEADERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("multiValueHeaders"))
    val MULTIVALUEHEADERS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BODY_DESCRIPTOR)
        field(HEADERS_DESCRIPTOR)
        field(LATENCY_DESCRIPTOR)
        field(LOG_DESCRIPTOR)
        field(MULTIVALUEHEADERS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BODY_DESCRIPTOR.index -> builder.body = deserializeString()
                HEADERS_DESCRIPTOR.index -> builder.headers =
                    deserializer.deserializeMap(HEADERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                LATENCY_DESCRIPTOR.index -> builder.latency = deserializeLong()
                LOG_DESCRIPTOR.index -> builder.log = deserializeString()
                MULTIVALUEHEADERS_DESCRIPTOR.index -> builder.multiValueHeaders =
                    deserializer.deserializeMap(MULTIVALUEHEADERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<String>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(MULTIVALUEHEADERS_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<String>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
