// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.PutMode
import aws.sdk.kotlin.services.apigateway.model.PutRestApiRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutRestApiOperationSerializer: HttpSerializer.NonStreaming<PutRestApiRequest> {
    override fun serialize(context: ExecutionContext, input: PutRestApiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.restApiId) { "restApiId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("restapis"))
                add(PercentEncoding.SmithyLabel.encode(input.restApiId))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.failOnWarnings != null) add("failonwarnings", input.failOnWarnings.toString())
                if (input.mode != null) add("mode", input.mode.value)
                input.parameters
                    ?.filterNot{ contains(it.key) }
                    ?.forEach { (key, value) ->
                        add(key, value)
                    }
            }
        }

        if (input.body != null) {
            builder.body = HttpBody.fromBytes(input.body)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.body == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
