// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.ConnectionType
import aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy
import aws.sdk.kotlin.services.apigateway.model.IntegrationResponse
import aws.sdk.kotlin.services.apigateway.model.IntegrationType
import aws.sdk.kotlin.services.apigateway.model.PutIntegrationResponse
import aws.sdk.kotlin.services.apigateway.model.TlsConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class PutIntegrationOperationDeserializer: HttpDeserializer.NonStreaming<PutIntegrationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutIntegrationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutIntegrationError(context, call, payload)
        }
        val builder = PutIntegrationResponse.Builder()

        if (payload != null) {
            deserializePutIntegrationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutIntegrationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutIntegrationOperationBody(builder: PutIntegrationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CACHEKEYPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("cacheKeyParameters"))
    val CACHENAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cacheNamespace"))
    val CONNECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectionId"))
    val CONNECTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("connectionType"))
    val CONTENTHANDLING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("contentHandling"))
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("credentials"))
    val HTTPMETHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("httpMethod"))
    val INTEGRATIONRESPONSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("integrationResponses"))
    val PASSTHROUGHBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("passthroughBehavior"))
    val REQUESTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestParameters"))
    val REQUESTTEMPLATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestTemplates"))
    val TIMEOUTINMILLIS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("timeoutInMillis"))
    val TLSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tlsConfig"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val URI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("uri"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CACHEKEYPARAMETERS_DESCRIPTOR)
        field(CACHENAMESPACE_DESCRIPTOR)
        field(CONNECTIONID_DESCRIPTOR)
        field(CONNECTIONTYPE_DESCRIPTOR)
        field(CONTENTHANDLING_DESCRIPTOR)
        field(CREDENTIALS_DESCRIPTOR)
        field(HTTPMETHOD_DESCRIPTOR)
        field(INTEGRATIONRESPONSES_DESCRIPTOR)
        field(PASSTHROUGHBEHAVIOR_DESCRIPTOR)
        field(REQUESTPARAMETERS_DESCRIPTOR)
        field(REQUESTTEMPLATES_DESCRIPTOR)
        field(TIMEOUTINMILLIS_DESCRIPTOR)
        field(TLSCONFIG_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(URI_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CACHEKEYPARAMETERS_DESCRIPTOR.index -> builder.cacheKeyParameters =
                    deserializer.deserializeList(CACHEKEYPARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CACHENAMESPACE_DESCRIPTOR.index -> builder.cacheNamespace = deserializeString()
                CONNECTIONID_DESCRIPTOR.index -> builder.connectionId = deserializeString()
                CONNECTIONTYPE_DESCRIPTOR.index -> builder.connectionType = deserializeString().let { ConnectionType.fromValue(it) }
                CONTENTHANDLING_DESCRIPTOR.index -> builder.contentHandling = deserializeString().let { ContentHandlingStrategy.fromValue(it) }
                CREDENTIALS_DESCRIPTOR.index -> builder.credentials = deserializeString()
                HTTPMETHOD_DESCRIPTOR.index -> builder.httpMethod = deserializeString()
                INTEGRATIONRESPONSES_DESCRIPTOR.index -> builder.integrationResponses =
                    deserializer.deserializeMap(INTEGRATIONRESPONSES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, IntegrationResponse>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeIntegrationResponseDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                PASSTHROUGHBEHAVIOR_DESCRIPTOR.index -> builder.passthroughBehavior = deserializeString()
                REQUESTPARAMETERS_DESCRIPTOR.index -> builder.requestParameters =
                    deserializer.deserializeMap(REQUESTPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                REQUESTTEMPLATES_DESCRIPTOR.index -> builder.requestTemplates =
                    deserializer.deserializeMap(REQUESTTEMPLATES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TIMEOUTINMILLIS_DESCRIPTOR.index -> builder.timeoutInMillis = deserializeInt()
                TLSCONFIG_DESCRIPTOR.index -> builder.tlsConfig = deserializeTlsConfigDocument(deserializer)
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { IntegrationType.fromValue(it) }
                URI_DESCRIPTOR.index -> builder.uri = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
