// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.ApiStage
import aws.sdk.kotlin.services.apigateway.model.GetUsagePlanResponse
import aws.sdk.kotlin.services.apigateway.model.QuotaSettings
import aws.sdk.kotlin.services.apigateway.model.ThrottleSettings
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetUsagePlanOperationDeserializer: HttpDeserializer.NonStreaming<GetUsagePlanResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetUsagePlanResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetUsagePlanError(context, call, payload)
        }
        val builder = GetUsagePlanResponse.Builder()

        if (payload != null) {
            deserializeGetUsagePlanOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetUsagePlanError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetUsagePlanOperationBody(builder: GetUsagePlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APISTAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("apiStages"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PRODUCTCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("productCode"))
    val QUOTA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("quota"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val THROTTLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("throttle"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APISTAGES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PRODUCTCODE_DESCRIPTOR)
        field(QUOTA_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(THROTTLE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APISTAGES_DESCRIPTOR.index -> builder.apiStages =
                    deserializer.deserializeList(APISTAGES_DESCRIPTOR) {
                        val col0 = mutableListOf<ApiStage>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeApiStageDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PRODUCTCODE_DESCRIPTOR.index -> builder.productCode = deserializeString()
                QUOTA_DESCRIPTOR.index -> builder.quota = deserializeQuotaSettingsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                THROTTLE_DESCRIPTOR.index -> builder.throttle = deserializeThrottleSettingsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
