// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.DomainNameStatus
import aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration
import aws.sdk.kotlin.services.apigateway.model.GetDomainNameResponse
import aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication
import aws.sdk.kotlin.services.apigateway.model.SecurityPolicy
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class GetDomainNameOperationDeserializer: HttpDeserializer.NonStreaming<GetDomainNameResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetDomainNameResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDomainNameError(context, call, payload)
        }
        val builder = GetDomainNameResponse.Builder()

        if (payload != null) {
            deserializeGetDomainNameOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetDomainNameError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDomainNameOperationBody(builder: GetDomainNameResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateArn"))
    val CERTIFICATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateName"))
    val CERTIFICATEUPLOADDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("certificateUploadDate"))
    val DISTRIBUTIONDOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("distributionDomainName"))
    val DISTRIBUTIONHOSTEDZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("distributionHostedZoneId"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainName"))
    val DOMAINNAMEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainNameArn"))
    val DOMAINNAMEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainNameId"))
    val DOMAINNAMESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("domainNameStatus"))
    val DOMAINNAMESTATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainNameStatusMessage"))
    val ENDPOINTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("endpointConfiguration"))
    val MANAGEMENTPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("managementPolicy"))
    val MUTUALTLSAUTHENTICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("mutualTlsAuthentication"))
    val OWNERSHIPVERIFICATIONCERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ownershipVerificationCertificateArn"))
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policy"))
    val REGIONALCERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("regionalCertificateArn"))
    val REGIONALCERTIFICATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("regionalCertificateName"))
    val REGIONALDOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("regionalDomainName"))
    val REGIONALHOSTEDZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("regionalHostedZoneId"))
    val SECURITYPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("securityPolicy"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CERTIFICATEARN_DESCRIPTOR)
        field(CERTIFICATENAME_DESCRIPTOR)
        field(CERTIFICATEUPLOADDATE_DESCRIPTOR)
        field(DISTRIBUTIONDOMAINNAME_DESCRIPTOR)
        field(DISTRIBUTIONHOSTEDZONEID_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(DOMAINNAMEARN_DESCRIPTOR)
        field(DOMAINNAMEID_DESCRIPTOR)
        field(DOMAINNAMESTATUS_DESCRIPTOR)
        field(DOMAINNAMESTATUSMESSAGE_DESCRIPTOR)
        field(ENDPOINTCONFIGURATION_DESCRIPTOR)
        field(MANAGEMENTPOLICY_DESCRIPTOR)
        field(MUTUALTLSAUTHENTICATION_DESCRIPTOR)
        field(OWNERSHIPVERIFICATIONCERTIFICATEARN_DESCRIPTOR)
        field(POLICY_DESCRIPTOR)
        field(REGIONALCERTIFICATEARN_DESCRIPTOR)
        field(REGIONALCERTIFICATENAME_DESCRIPTOR)
        field(REGIONALDOMAINNAME_DESCRIPTOR)
        field(REGIONALHOSTEDZONEID_DESCRIPTOR)
        field(SECURITYPOLICY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CERTIFICATEARN_DESCRIPTOR.index -> builder.certificateArn = deserializeString()
                CERTIFICATENAME_DESCRIPTOR.index -> builder.certificateName = deserializeString()
                CERTIFICATEUPLOADDATE_DESCRIPTOR.index -> builder.certificateUploadDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DISTRIBUTIONDOMAINNAME_DESCRIPTOR.index -> builder.distributionDomainName = deserializeString()
                DISTRIBUTIONHOSTEDZONEID_DESCRIPTOR.index -> builder.distributionHostedZoneId = deserializeString()
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                DOMAINNAMEARN_DESCRIPTOR.index -> builder.domainNameArn = deserializeString()
                DOMAINNAMEID_DESCRIPTOR.index -> builder.domainNameId = deserializeString()
                DOMAINNAMESTATUS_DESCRIPTOR.index -> builder.domainNameStatus = deserializeString().let { DomainNameStatus.fromValue(it) }
                DOMAINNAMESTATUSMESSAGE_DESCRIPTOR.index -> builder.domainNameStatusMessage = deserializeString()
                ENDPOINTCONFIGURATION_DESCRIPTOR.index -> builder.endpointConfiguration = deserializeEndpointConfigurationDocument(deserializer)
                MANAGEMENTPOLICY_DESCRIPTOR.index -> builder.managementPolicy = deserializeString()
                MUTUALTLSAUTHENTICATION_DESCRIPTOR.index -> builder.mutualTlsAuthentication = deserializeMutualTlsAuthenticationDocument(deserializer)
                OWNERSHIPVERIFICATIONCERTIFICATEARN_DESCRIPTOR.index -> builder.ownershipVerificationCertificateArn = deserializeString()
                POLICY_DESCRIPTOR.index -> builder.policy = deserializeString()
                REGIONALCERTIFICATEARN_DESCRIPTOR.index -> builder.regionalCertificateArn = deserializeString()
                REGIONALCERTIFICATENAME_DESCRIPTOR.index -> builder.regionalCertificateName = deserializeString()
                REGIONALDOMAINNAME_DESCRIPTOR.index -> builder.regionalDomainName = deserializeString()
                REGIONALHOSTEDZONEID_DESCRIPTOR.index -> builder.regionalHostedZoneId = deserializeString()
                SECURITYPOLICY_DESCRIPTOR.index -> builder.securityPolicy = deserializeString().let { SecurityPolicy.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
