// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.AccessAssociationSourceType
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.CreateDomainNameAccessAssociationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class CreateDomainNameAccessAssociationOperationDeserializer: HttpDeserializer.NonStreaming<CreateDomainNameAccessAssociationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDomainNameAccessAssociationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDomainNameAccessAssociationError(context, call, payload)
        }
        val builder = CreateDomainNameAccessAssociationResponse.Builder()

        if (payload != null) {
            deserializeCreateDomainNameAccessAssociationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDomainNameAccessAssociationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDomainNameAccessAssociationOperationBody(builder: CreateDomainNameAccessAssociationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSASSOCIATIONSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessAssociationSource"))
    val ACCESSASSOCIATIONSOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("accessAssociationSourceType"))
    val DOMAINNAMEACCESSASSOCIATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainNameAccessAssociationArn"))
    val DOMAINNAMEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainNameArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSASSOCIATIONSOURCE_DESCRIPTOR)
        field(ACCESSASSOCIATIONSOURCETYPE_DESCRIPTOR)
        field(DOMAINNAMEACCESSASSOCIATIONARN_DESCRIPTOR)
        field(DOMAINNAMEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSASSOCIATIONSOURCE_DESCRIPTOR.index -> builder.accessAssociationSource = deserializeString()
                ACCESSASSOCIATIONSOURCETYPE_DESCRIPTOR.index -> builder.accessAssociationSourceType = deserializeString().let { AccessAssociationSourceType.fromValue(it) }
                DOMAINNAMEACCESSASSOCIATIONARN_DESCRIPTOR.index -> builder.domainNameAccessAssociationArn = deserializeString()
                DOMAINNAMEARN_DESCRIPTOR.index -> builder.domainNameArn = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
