// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a usage plan used to specify who can assess associated API stages. Optionally, target request rate and quota limits can be set. In some cases clients can exceed the targets that you set. Don’t rely on usage plans to control costs. Consider using [Amazon Web Services Budgets](https://docs.aws.amazon.com/cost-management/latest/userguide/budgets-managing-costs.html) to monitor costs and [WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) to manage API requests.
 */
public class UsagePlan private constructor(builder: Builder) {
    /**
     * The associated API stages of a usage plan.
     */
    public val apiStages: List<ApiStage>? = builder.apiStages
    /**
     * The description of a usage plan.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of a UsagePlan resource.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of a usage plan.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services Marketplace product identifier to associate with the usage plan as a SaaS product on the Amazon Web Services Marketplace.
     */
    public val productCode: kotlin.String? = builder.productCode
    /**
     * The target maximum number of permitted requests per a given unit time interval.
     */
    public val quota: aws.sdk.kotlin.services.apigateway.model.QuotaSettings? = builder.quota
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A map containing method level throttling information for API stage in a usage plan.
     */
    public val throttle: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = builder.throttle

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UsagePlan = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UsagePlan(")
        append("apiStages=$apiStages,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("productCode=$productCode,")
        append("quota=$quota,")
        append("tags=$tags,")
        append("throttle=$throttle")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiStages?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (productCode?.hashCode() ?: 0)
        result = 31 * result + (quota?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throttle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UsagePlan

        if (apiStages != other.apiStages) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (productCode != other.productCode) return false
        if (quota != other.quota) return false
        if (tags != other.tags) return false
        if (throttle != other.throttle) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UsagePlan = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The associated API stages of a usage plan.
         */
        public var apiStages: List<ApiStage>? = null
        /**
         * The description of a usage plan.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of a UsagePlan resource.
         */
        public var id: kotlin.String? = null
        /**
         * The name of a usage plan.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services Marketplace product identifier to associate with the usage plan as a SaaS product on the Amazon Web Services Marketplace.
         */
        public var productCode: kotlin.String? = null
        /**
         * The target maximum number of permitted requests per a given unit time interval.
         */
        public var quota: aws.sdk.kotlin.services.apigateway.model.QuotaSettings? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * A map containing method level throttling information for API stage in a usage plan.
         */
        public var throttle: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UsagePlan) : this() {
            this.apiStages = x.apiStages
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.productCode = x.productCode
            this.quota = x.quota
            this.tags = x.tags
            this.throttle = x.throttle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UsagePlan = UsagePlan(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.QuotaSettings] inside the given [block]
         */
        public fun quota(block: aws.sdk.kotlin.services.apigateway.model.QuotaSettings.Builder.() -> kotlin.Unit) {
            this.quota = aws.sdk.kotlin.services.apigateway.model.QuotaSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.ThrottleSettings] inside the given [block]
         */
        public fun throttle(block: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.Builder.() -> kotlin.Unit) {
            this.throttle = aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
