// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents an authorization layer for methods. If enabled on a method, API Gateway will activate the authorizer when a client calls the method.
 */
public class UpdateAuthorizerResponse private constructor(builder: Builder) {
    /**
     * Optional customer-defined field, used in OpenAPI imports and exports without functional impact.
     */
    public val authType: kotlin.String? = builder.authType
    /**
     * Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.
     */
    public val authorizerCredentials: kotlin.String? = builder.authorizerCredentials
    /**
     * The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.
     */
    public val authorizerResultTtlInSeconds: kotlin.Int? = builder.authorizerResultTtlInSeconds
    /**
     * Specifies the authorizer's Uniform Resource Identifier (URI). For `TOKEN` or `REQUEST` authorizers, this must be a well-formed Lambda function URI, for example, `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations`. In general, the URI has this form `arn:aws:apigateway:{region}:lambda:path/{service_api}`, where `{region}` is the same as the region hosting the Lambda function, `path` indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial `/`. For Lambda functions, this is usually of the form `/2015-03-31/functions/[FunctionARN]/invocations`.
     */
    public val authorizerUri: kotlin.String? = builder.authorizerUri
    /**
     * The identifier for the authorizer resource.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The identity source for which authorization is requested. For a `TOKEN` or `COGNITO_USER_POOLS` authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is `Auth`, the header mapping expression is `method.request.header.Auth`. For the `REQUEST` authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an `Auth` header, a `Name` query string parameter are defined as identity sources, this value is `method.request.header.Auth`, `method.request.querystring.Name`. These parameters will be used to derive the authorization caching key and to perform runtime validation of the `REQUEST` authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.
     */
    public val identitySource: kotlin.String? = builder.identitySource
    /**
     * A validation expression for the incoming identity token. For `TOKEN` authorizers, this value is a regular expression. For `COGNITO_USER_POOLS` authorizers, API Gateway will match the `aud` field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the `REQUEST` authorizer.
     */
    public val identityValidationExpression: kotlin.String? = builder.identityValidationExpression
    /**
     * The name of the authorizer.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of the Amazon Cognito user pool ARNs for the `COGNITO_USER_POOLS` authorizer. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`. For a `TOKEN` or `REQUEST` authorizer, this is not defined.
     */
    public val providerArns: List<String>? = builder.providerArns
    /**
     * The authorizer type. Valid values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, and `COGNITO_USER_POOLS` for using an Amazon Cognito user pool.
     */
    public val type: aws.sdk.kotlin.services.apigateway.model.AuthorizerType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateAuthorizerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAuthorizerResponse(")
        append("authType=$authType,")
        append("authorizerCredentials=$authorizerCredentials,")
        append("authorizerResultTtlInSeconds=$authorizerResultTtlInSeconds,")
        append("authorizerUri=$authorizerUri,")
        append("id=$id,")
        append("identitySource=$identitySource,")
        append("identityValidationExpression=$identityValidationExpression,")
        append("name=$name,")
        append("providerArns=$providerArns,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authType?.hashCode() ?: 0
        result = 31 * result + (authorizerCredentials?.hashCode() ?: 0)
        result = 31 * result + (authorizerResultTtlInSeconds ?: 0)
        result = 31 * result + (authorizerUri?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (identitySource?.hashCode() ?: 0)
        result = 31 * result + (identityValidationExpression?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (providerArns?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAuthorizerResponse

        if (authType != other.authType) return false
        if (authorizerCredentials != other.authorizerCredentials) return false
        if (authorizerResultTtlInSeconds != other.authorizerResultTtlInSeconds) return false
        if (authorizerUri != other.authorizerUri) return false
        if (id != other.id) return false
        if (identitySource != other.identitySource) return false
        if (identityValidationExpression != other.identityValidationExpression) return false
        if (name != other.name) return false
        if (providerArns != other.providerArns) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateAuthorizerResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Optional customer-defined field, used in OpenAPI imports and exports without functional impact.
         */
        public var authType: kotlin.String? = null
        /**
         * Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.
         */
        public var authorizerCredentials: kotlin.String? = null
        /**
         * The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.
         */
        public var authorizerResultTtlInSeconds: kotlin.Int? = null
        /**
         * Specifies the authorizer's Uniform Resource Identifier (URI). For `TOKEN` or `REQUEST` authorizers, this must be a well-formed Lambda function URI, for example, `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations`. In general, the URI has this form `arn:aws:apigateway:{region}:lambda:path/{service_api}`, where `{region}` is the same as the region hosting the Lambda function, `path` indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial `/`. For Lambda functions, this is usually of the form `/2015-03-31/functions/[FunctionARN]/invocations`.
         */
        public var authorizerUri: kotlin.String? = null
        /**
         * The identifier for the authorizer resource.
         */
        public var id: kotlin.String? = null
        /**
         * The identity source for which authorization is requested. For a `TOKEN` or `COGNITO_USER_POOLS` authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is `Auth`, the header mapping expression is `method.request.header.Auth`. For the `REQUEST` authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an `Auth` header, a `Name` query string parameter are defined as identity sources, this value is `method.request.header.Auth`, `method.request.querystring.Name`. These parameters will be used to derive the authorization caching key and to perform runtime validation of the `REQUEST` authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.
         */
        public var identitySource: kotlin.String? = null
        /**
         * A validation expression for the incoming identity token. For `TOKEN` authorizers, this value is a regular expression. For `COGNITO_USER_POOLS` authorizers, API Gateway will match the `aud` field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the `REQUEST` authorizer.
         */
        public var identityValidationExpression: kotlin.String? = null
        /**
         * The name of the authorizer.
         */
        public var name: kotlin.String? = null
        /**
         * A list of the Amazon Cognito user pool ARNs for the `COGNITO_USER_POOLS` authorizer. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`. For a `TOKEN` or `REQUEST` authorizer, this is not defined.
         */
        public var providerArns: List<String>? = null
        /**
         * The authorizer type. Valid values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, and `COGNITO_USER_POOLS` for using an Amazon Cognito user pool.
         */
        public var type: aws.sdk.kotlin.services.apigateway.model.AuthorizerType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateAuthorizerResponse) : this() {
            this.authType = x.authType
            this.authorizerCredentials = x.authorizerCredentials
            this.authorizerResultTtlInSeconds = x.authorizerResultTtlInSeconds
            this.authorizerUri = x.authorizerUri
            this.id = x.id
            this.identitySource = x.identitySource
            this.identityValidationExpression = x.identityValidationExpression
            this.name = x.name
            this.providerArns = x.providerArns
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateAuthorizerResponse = UpdateAuthorizerResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
