// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a REST API.
 */
public class RestApi private constructor(builder: Builder) {
    /**
     * The source of the API key for metering requests according to a usage plan. Valid values are: >`HEADER` to read the API key from the `X-API-Key` header of a request. `AUTHORIZER` to read the API key from the `UsageIdentifierKey` from a custom authorizer.
     */
    public val apiKeySource: aws.sdk.kotlin.services.apigateway.model.ApiKeySourceType? = builder.apiKeySource
    /**
     * The list of binary media types supported by the RestApi. By default, the RestApi supports only UTF-8-encoded text payloads.
     */
    public val binaryMediaTypes: List<String>? = builder.binaryMediaTypes
    /**
     * The timestamp when the API was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The API's description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether clients can invoke your API by using the default `execute-api` endpoint. By default, clients can invoke your API with the default `https://{api_id}.execute-api.{region}.amazonaws.com` endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
     */
    public val disableExecuteApiEndpoint: kotlin.Boolean = builder.disableExecuteApiEndpoint
    /**
     * The endpoint configuration of this RestApi showing the endpoint types of the API.
     */
    public val endpointConfiguration: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration? = builder.endpointConfiguration
    /**
     * The API's identifier. This identifier is unique across all of your APIs in API Gateway.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.
     */
    public val minimumCompressionSize: kotlin.Int? = builder.minimumCompressionSize
    /**
     * The API's name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A stringified JSON policy document that applies to this RestApi regardless of the caller and Method configuration.
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * The API's root resource ID.
     */
    public val rootResourceId: kotlin.String? = builder.rootResourceId
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A version identifier for the API.
     */
    public val version: kotlin.String? = builder.version
    /**
     * The warning messages reported when `failonwarnings` is turned on during API import.
     */
    public val warnings: List<String>? = builder.warnings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.RestApi = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestApi(")
        append("apiKeySource=$apiKeySource,")
        append("binaryMediaTypes=$binaryMediaTypes,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("disableExecuteApiEndpoint=$disableExecuteApiEndpoint,")
        append("endpointConfiguration=$endpointConfiguration,")
        append("id=$id,")
        append("minimumCompressionSize=$minimumCompressionSize,")
        append("name=$name,")
        append("policy=$policy,")
        append("rootResourceId=$rootResourceId,")
        append("tags=$tags,")
        append("version=$version,")
        append("warnings=$warnings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeySource?.hashCode() ?: 0
        result = 31 * result + (binaryMediaTypes?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (disableExecuteApiEndpoint.hashCode())
        result = 31 * result + (endpointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (minimumCompressionSize ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (rootResourceId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestApi

        if (apiKeySource != other.apiKeySource) return false
        if (binaryMediaTypes != other.binaryMediaTypes) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (disableExecuteApiEndpoint != other.disableExecuteApiEndpoint) return false
        if (endpointConfiguration != other.endpointConfiguration) return false
        if (id != other.id) return false
        if (minimumCompressionSize != other.minimumCompressionSize) return false
        if (name != other.name) return false
        if (policy != other.policy) return false
        if (rootResourceId != other.rootResourceId) return false
        if (tags != other.tags) return false
        if (version != other.version) return false
        if (warnings != other.warnings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.RestApi = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The source of the API key for metering requests according to a usage plan. Valid values are: >`HEADER` to read the API key from the `X-API-Key` header of a request. `AUTHORIZER` to read the API key from the `UsageIdentifierKey` from a custom authorizer.
         */
        public var apiKeySource: aws.sdk.kotlin.services.apigateway.model.ApiKeySourceType? = null
        /**
         * The list of binary media types supported by the RestApi. By default, the RestApi supports only UTF-8-encoded text payloads.
         */
        public var binaryMediaTypes: List<String>? = null
        /**
         * The timestamp when the API was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The API's description.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether clients can invoke your API by using the default `execute-api` endpoint. By default, clients can invoke your API with the default `https://{api_id}.execute-api.{region}.amazonaws.com` endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         */
        public var disableExecuteApiEndpoint: kotlin.Boolean = false
        /**
         * The endpoint configuration of this RestApi showing the endpoint types of the API.
         */
        public var endpointConfiguration: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration? = null
        /**
         * The API's identifier. This identifier is unique across all of your APIs in API Gateway.
         */
        public var id: kotlin.String? = null
        /**
         * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.
         */
        public var minimumCompressionSize: kotlin.Int? = null
        /**
         * The API's name.
         */
        public var name: kotlin.String? = null
        /**
         * A stringified JSON policy document that applies to this RestApi regardless of the caller and Method configuration.
         */
        public var policy: kotlin.String? = null
        /**
         * The API's root resource ID.
         */
        public var rootResourceId: kotlin.String? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * A version identifier for the API.
         */
        public var version: kotlin.String? = null
        /**
         * The warning messages reported when `failonwarnings` is turned on during API import.
         */
        public var warnings: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.RestApi) : this() {
            this.apiKeySource = x.apiKeySource
            this.binaryMediaTypes = x.binaryMediaTypes
            this.createdDate = x.createdDate
            this.description = x.description
            this.disableExecuteApiEndpoint = x.disableExecuteApiEndpoint
            this.endpointConfiguration = x.endpointConfiguration
            this.id = x.id
            this.minimumCompressionSize = x.minimumCompressionSize
            this.name = x.name
            this.policy = x.policy
            this.rootResourceId = x.rootResourceId
            this.tags = x.tags
            this.version = x.version
            this.warnings = x.warnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.RestApi = RestApi(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration] inside the given [block]
         */
        public fun endpointConfiguration(block: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration.Builder.() -> kotlin.Unit) {
            this.endpointConfiguration = aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
