// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Import documentation parts from an external (e.g., OpenAPI) definition file.
 */
public class ImportDocumentationPartsRequest private constructor(builder: Builder) {
    /**
     * Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.
     */
    public val body: kotlin.ByteArray? = builder.body
    /**
     * A query parameter to specify whether to rollback the documentation importation (`true`) or not (`false`) when a warning is encountered. The default value is `false`.
     */
    public val failOnWarnings: kotlin.Boolean? = builder.failOnWarnings
    /**
     * A query parameter to indicate whether to overwrite (`overwrite`) any existing DocumentationParts definition or to merge (`merge`) the new definition into the existing one. The default value is `merge`.
     */
    public val mode: aws.sdk.kotlin.services.apigateway.model.PutMode? = builder.mode
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = builder.restApiId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.ImportDocumentationPartsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportDocumentationPartsRequest(")
        append("body=$body,")
        append("failOnWarnings=$failOnWarnings,")
        append("mode=$mode,")
        append("restApiId=$restApiId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.contentHashCode() ?: 0
        result = 31 * result + (failOnWarnings?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportDocumentationPartsRequest

        if (body != null) {
            if (other.body == null) return false
            if (!body.contentEquals(other.body)) return false
        } else if (other.body != null) return false
        if (failOnWarnings != other.failOnWarnings) return false
        if (mode != other.mode) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.ImportDocumentationPartsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.
         */
        public var body: kotlin.ByteArray? = null
        /**
         * A query parameter to specify whether to rollback the documentation importation (`true`) or not (`false`) when a warning is encountered. The default value is `false`.
         */
        public var failOnWarnings: kotlin.Boolean? = null
        /**
         * A query parameter to indicate whether to overwrite (`overwrite`) any existing DocumentationParts definition or to merge (`merge`) the new definition into the existing one. The default value is `merge`.
         */
        public var mode: aws.sdk.kotlin.services.apigateway.model.PutMode? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.ImportDocumentationPartsRequest) : this() {
            this.body = x.body
            this.failOnWarnings = x.failOnWarnings
            this.mode = x.mode
            this.restApiId = x.restApiId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.ImportDocumentationPartsRequest = ImportDocumentationPartsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
