// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A gateway response of a given response type and status code, with optional response parameters and mapping templates.
 */
public class GetGatewayResponseResponse private constructor(builder: Builder) {
    /**
     * A Boolean flag to indicate whether this GatewayResponse is the default gateway response (`true`) or not (`false`). A default gateway response is one generated by API Gateway without any customization by an API developer.
     */
    public val defaultResponse: kotlin.Boolean = builder.defaultResponse
    /**
     * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value pairs.
     */
    public val responseParameters: Map<String, String>? = builder.responseParameters
    /**
     * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
     */
    public val responseTemplates: Map<String, String>? = builder.responseTemplates
    /**
     * The response type of the associated GatewayResponse.
     */
    public val responseType: aws.sdk.kotlin.services.apigateway.model.GatewayResponseType? = builder.responseType
    /**
     * The HTTP status code for this GatewayResponse.
     */
    public val statusCode: kotlin.String? = builder.statusCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetGatewayResponseResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetGatewayResponseResponse(")
        append("defaultResponse=$defaultResponse,")
        append("responseParameters=$responseParameters,")
        append("responseTemplates=$responseTemplates,")
        append("responseType=$responseType,")
        append("statusCode=$statusCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultResponse.hashCode()
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (responseTemplates?.hashCode() ?: 0)
        result = 31 * result + (responseType?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetGatewayResponseResponse

        if (defaultResponse != other.defaultResponse) return false
        if (responseParameters != other.responseParameters) return false
        if (responseTemplates != other.responseTemplates) return false
        if (responseType != other.responseType) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetGatewayResponseResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Boolean flag to indicate whether this GatewayResponse is the default gateway response (`true`) or not (`false`). A default gateway response is one generated by API Gateway without any customization by an API developer.
         */
        public var defaultResponse: kotlin.Boolean = false
        /**
         * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value pairs.
         */
        public var responseParameters: Map<String, String>? = null
        /**
         * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
         */
        public var responseTemplates: Map<String, String>? = null
        /**
         * The response type of the associated GatewayResponse.
         */
        public var responseType: aws.sdk.kotlin.services.apigateway.model.GatewayResponseType? = null
        /**
         * The HTTP status code for this GatewayResponse.
         */
        public var statusCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetGatewayResponseResponse) : this() {
            this.defaultResponse = x.defaultResponse
            this.responseParameters = x.responseParameters
            this.responseTemplates = x.responseTemplates
            this.responseType = x.responseType
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetGatewayResponseResponse = GetGatewayResponseResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
