// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Request to describe a BasePathMapping resource.
 */
public class GetBasePathMappingRequest private constructor(builder: Builder) {
    /**
     * The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.
     */
    public val basePath: kotlin.String? = builder.basePath
    /**
     * The domain name of the BasePathMapping resource to be described.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The identifier for the domain name resource. Supported only for private custom domain names.
     */
    public val domainNameId: kotlin.String? = builder.domainNameId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetBasePathMappingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetBasePathMappingRequest(")
        append("basePath=$basePath,")
        append("domainName=$domainName,")
        append("domainNameId=$domainNameId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = basePath?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainNameId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetBasePathMappingRequest

        if (basePath != other.basePath) return false
        if (domainName != other.domainName) return false
        if (domainNameId != other.domainNameId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetBasePathMappingRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.
         */
        public var basePath: kotlin.String? = null
        /**
         * The domain name of the BasePathMapping resource to be described.
         */
        public var domainName: kotlin.String? = null
        /**
         * The identifier for the domain name resource. Supported only for private custom domain names.
         */
        public var domainNameId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetBasePathMappingRequest) : this() {
            this.basePath = x.basePath
            this.domainName = x.domainName
            this.domainNameId = x.domainNameId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetBasePathMappingRequest = GetBasePathMappingRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
