// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a domain name access association between an access association source and a private custom domain name. With a domain name access association, an access association source can invoke a private custom domain name while isolated from the public internet.
 */
public class DomainNameAccessAssociation private constructor(builder: Builder) {
    /**
     * The ARN of the domain name access association source. For a VPCE, the ARN must be a VPC endpoint.
     */
    public val accessAssociationSource: kotlin.String? = builder.accessAssociationSource
    /**
     * The type of the domain name access association source.
     */
    public val accessAssociationSourceType: aws.sdk.kotlin.services.apigateway.model.AccessAssociationSourceType? = builder.accessAssociationSourceType
    /**
     * The ARN of the domain name access association resource.
     */
    public val domainNameAccessAssociationArn: kotlin.String? = builder.domainNameAccessAssociationArn
    /**
     * The ARN of the domain name.
     */
    public val domainNameArn: kotlin.String? = builder.domainNameArn
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.DomainNameAccessAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainNameAccessAssociation(")
        append("accessAssociationSource=$accessAssociationSource,")
        append("accessAssociationSourceType=$accessAssociationSourceType,")
        append("domainNameAccessAssociationArn=$domainNameAccessAssociationArn,")
        append("domainNameArn=$domainNameArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessAssociationSource?.hashCode() ?: 0
        result = 31 * result + (accessAssociationSourceType?.hashCode() ?: 0)
        result = 31 * result + (domainNameAccessAssociationArn?.hashCode() ?: 0)
        result = 31 * result + (domainNameArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainNameAccessAssociation

        if (accessAssociationSource != other.accessAssociationSource) return false
        if (accessAssociationSourceType != other.accessAssociationSourceType) return false
        if (domainNameAccessAssociationArn != other.domainNameAccessAssociationArn) return false
        if (domainNameArn != other.domainNameArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.DomainNameAccessAssociation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the domain name access association source. For a VPCE, the ARN must be a VPC endpoint.
         */
        public var accessAssociationSource: kotlin.String? = null
        /**
         * The type of the domain name access association source.
         */
        public var accessAssociationSourceType: aws.sdk.kotlin.services.apigateway.model.AccessAssociationSourceType? = null
        /**
         * The ARN of the domain name access association resource.
         */
        public var domainNameAccessAssociationArn: kotlin.String? = null
        /**
         * The ARN of the domain name.
         */
        public var domainNameArn: kotlin.String? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.DomainNameAccessAssociation) : this() {
            this.accessAssociationSource = x.accessAssociationSource
            this.accessAssociationSourceType = x.accessAssociationSourceType
            this.domainNameAccessAssociationArn = x.domainNameAccessAssociationArn
            this.domainNameArn = x.domainNameArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.DomainNameAccessAssociation = DomainNameAccessAssociation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
