// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.
 */
public class CreateVpcLinkRequest private constructor(builder: Builder) {
    /**
     * The description of the VPC link.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name used to label and identify the VPC link.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same Amazon Web Services account of the API owner.
     */
    public val targetArns: List<String>? = builder.targetArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateVpcLinkRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVpcLinkRequest(")
        append("description=$description,")
        append("name=$name,")
        append("tags=$tags,")
        append("targetArns=$targetArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVpcLinkRequest

        if (description != other.description) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (targetArns != other.targetArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateVpcLinkRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the VPC link.
         */
        public var description: kotlin.String? = null
        /**
         * The name used to label and identify the VPC link.
         */
        public var name: kotlin.String? = null
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
         */
        public var tags: Map<String, String>? = null
        /**
         * The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same Amazon Web Services account of the API owner.
         */
        public var targetArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateVpcLinkRequest) : this() {
            this.description = x.description
            this.name = x.name
            this.tags = x.tags
            this.targetArns = x.targetArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateVpcLinkRequest = CreateVpcLinkRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
