// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The POST request to create a usage plan with the name, description, throttle limits and quota limits, as well as the associated API stages, specified in the payload.
 */
public class CreateUsagePlanRequest private constructor(builder: Builder) {
    /**
     * The associated API stages of the usage plan.
     */
    public val apiStages: List<ApiStage>? = builder.apiStages
    /**
     * The description of the usage plan.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the usage plan.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The quota of the usage plan.
     */
    public val quota: aws.sdk.kotlin.services.apigateway.model.QuotaSettings? = builder.quota
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The throttling limits of the usage plan.
     */
    public val throttle: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = builder.throttle

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateUsagePlanRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUsagePlanRequest(")
        append("apiStages=$apiStages,")
        append("description=$description,")
        append("name=$name,")
        append("quota=$quota,")
        append("tags=$tags,")
        append("throttle=$throttle")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiStages?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (quota?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throttle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUsagePlanRequest

        if (apiStages != other.apiStages) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (quota != other.quota) return false
        if (tags != other.tags) return false
        if (throttle != other.throttle) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateUsagePlanRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The associated API stages of the usage plan.
         */
        public var apiStages: List<ApiStage>? = null
        /**
         * The description of the usage plan.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the usage plan.
         */
        public var name: kotlin.String? = null
        /**
         * The quota of the usage plan.
         */
        public var quota: aws.sdk.kotlin.services.apigateway.model.QuotaSettings? = null
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
         */
        public var tags: Map<String, String>? = null
        /**
         * The throttling limits of the usage plan.
         */
        public var throttle: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateUsagePlanRequest) : this() {
            this.apiStages = x.apiStages
            this.description = x.description
            this.name = x.name
            this.quota = x.quota
            this.tags = x.tags
            this.throttle = x.throttle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateUsagePlanRequest = CreateUsagePlanRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.QuotaSettings] inside the given [block]
         */
        public fun quota(block: aws.sdk.kotlin.services.apigateway.model.QuotaSettings.Builder.() -> kotlin.Unit) {
            this.quota = aws.sdk.kotlin.services.apigateway.model.QuotaSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.ThrottleSettings] inside the given [block]
         */
        public fun throttle(block: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.Builder.() -> kotlin.Unit) {
            this.throttle = aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
