// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Requests API Gateway to create a new BasePathMapping resource.
 */
public class CreateBasePathMappingRequest private constructor(builder: Builder) {
    /**
     * The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.
     */
    public val basePath: kotlin.String? = builder.basePath
    /**
     * The domain name of the BasePathMapping resource to create.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The identifier for the domain name resource. Required for private custom domain names.
     */
    public val domainNameId: kotlin.String? = builder.domainNameId
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = builder.restApiId
    /**
     * The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.
     */
    public val stage: kotlin.String? = builder.stage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateBasePathMappingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBasePathMappingRequest(")
        append("basePath=$basePath,")
        append("domainName=$domainName,")
        append("domainNameId=$domainNameId,")
        append("restApiId=$restApiId,")
        append("stage=$stage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = basePath?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainNameId?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBasePathMappingRequest

        if (basePath != other.basePath) return false
        if (domainName != other.domainName) return false
        if (domainNameId != other.domainNameId) return false
        if (restApiId != other.restApiId) return false
        if (stage != other.stage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateBasePathMappingRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name.
         */
        public var basePath: kotlin.String? = null
        /**
         * The domain name of the BasePathMapping resource to create.
         */
        public var domainName: kotlin.String? = null
        /**
         * The identifier for the domain name resource. Required for private custom domain names.
         */
        public var domainNameId: kotlin.String? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null
        /**
         * The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name.
         */
        public var stage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateBasePathMappingRequest) : this() {
            this.basePath = x.basePath
            this.domainName = x.domainName
            this.domainNameId = x.domainNameId
            this.restApiId = x.restApiId
            this.stage = x.stage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateBasePathMappingRequest = CreateBasePathMappingRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
