// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Request to create an ApiKey resource.
 */
public class CreateApiKeyRequest private constructor(builder: Builder) {
    /**
     * An Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.
     */
    public val customerId: kotlin.String? = builder.customerId
    /**
     * The description of the ApiKey.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether the ApiKey can be used by callers.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Specifies whether (`true`) or not (`false`) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
     */
    public val generateDistinctId: kotlin.Boolean? = builder.generateDistinctId
    /**
     * The name of the ApiKey.
     */
    public val name: kotlin.String? = builder.name
    /**
     * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
     */
    public val stageKeys: List<StageKey>? = builder.stageKeys
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies a value of the API key.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateApiKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApiKeyRequest(")
        append("customerId=$customerId,")
        append("description=$description,")
        append("enabled=$enabled,")
        append("generateDistinctId=$generateDistinctId,")
        append("name=$name,")
        append("stageKeys=$stageKeys,")
        append("tags=$tags,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (generateDistinctId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stageKeys?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApiKeyRequest

        if (customerId != other.customerId) return false
        if (description != other.description) return false
        if (enabled != other.enabled) return false
        if (generateDistinctId != other.generateDistinctId) return false
        if (name != other.name) return false
        if (stageKeys != other.stageKeys) return false
        if (tags != other.tags) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateApiKeyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.
         */
        public var customerId: kotlin.String? = null
        /**
         * The description of the ApiKey.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether the ApiKey can be used by callers.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Specifies whether (`true`) or not (`false`) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
         */
        public var generateDistinctId: kotlin.Boolean? = null
        /**
         * The name of the ApiKey.
         */
        public var name: kotlin.String? = null
        /**
         * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
         */
        public var stageKeys: List<StageKey>? = null
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies a value of the API key.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateApiKeyRequest) : this() {
            this.customerId = x.customerId
            this.description = x.description
            this.enabled = x.enabled
            this.generateDistinctId = x.generateDistinctId
            this.name = x.name
            this.stageKeys = x.stageKeys
            this.tags = x.tags
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateApiKeyRequest = CreateApiKeyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
