// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway

import aws.sdk.kotlin.runtime.auth.credentials.StaticCredentialsProvider
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.AwsBusinessMetric
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.apigateway.auth.ApiGatewayAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.apigateway.auth.ApiGatewayIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.apigateway.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.apigateway.model.*
import aws.sdk.kotlin.services.apigateway.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.businessmetrics.emitBusinessMetric
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultApiGatewayClient(override val config: ApiGatewayClient.Config) : ApiGatewayClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = ApiGatewayIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "apigateway")
        }
        toMap()
    }
    private val authSchemeAdapter = ApiGatewayAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.apigateway"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Create an ApiKey resource.
     */
    override suspend fun createApiKey(input: CreateApiKeyRequest): CreateApiKeyResponse {
        val op = SdkHttpOperation.build<CreateApiKeyRequest, CreateApiKeyResponse> {
            serializeWith = CreateApiKeyOperationSerializer()
            deserializeWith = CreateApiKeyOperationDeserializer()
            operationName = "CreateApiKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new Authorizer resource to an existing RestApi resource.
     */
    override suspend fun createAuthorizer(input: CreateAuthorizerRequest): CreateAuthorizerResponse {
        val op = SdkHttpOperation.build<CreateAuthorizerRequest, CreateAuthorizerResponse> {
            serializeWith = CreateAuthorizerOperationSerializer()
            deserializeWith = CreateAuthorizerOperationDeserializer()
            operationName = "CreateAuthorizer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new BasePathMapping resource.
     */
    override suspend fun createBasePathMapping(input: CreateBasePathMappingRequest): CreateBasePathMappingResponse {
        val op = SdkHttpOperation.build<CreateBasePathMappingRequest, CreateBasePathMappingResponse> {
            serializeWith = CreateBasePathMappingOperationSerializer()
            deserializeWith = CreateBasePathMappingOperationDeserializer()
            operationName = "CreateBasePathMapping"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Deployment resource, which makes a specified RestApi callable over the internet.
     */
    override suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse {
        val op = SdkHttpOperation.build<CreateDeploymentRequest, CreateDeploymentResponse> {
            serializeWith = CreateDeploymentOperationSerializer()
            deserializeWith = CreateDeploymentOperationDeserializer()
            operationName = "CreateDeployment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a documentation part.
     */
    override suspend fun createDocumentationPart(input: CreateDocumentationPartRequest): CreateDocumentationPartResponse {
        val op = SdkHttpOperation.build<CreateDocumentationPartRequest, CreateDocumentationPartResponse> {
            serializeWith = CreateDocumentationPartOperationSerializer()
            deserializeWith = CreateDocumentationPartOperationDeserializer()
            operationName = "CreateDocumentationPart"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a documentation version
     */
    override suspend fun createDocumentationVersion(input: CreateDocumentationVersionRequest): CreateDocumentationVersionResponse {
        val op = SdkHttpOperation.build<CreateDocumentationVersionRequest, CreateDocumentationVersionResponse> {
            serializeWith = CreateDocumentationVersionOperationSerializer()
            deserializeWith = CreateDocumentationVersionOperationDeserializer()
            operationName = "CreateDocumentationVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new domain name.
     */
    override suspend fun createDomainName(input: CreateDomainNameRequest): CreateDomainNameResponse {
        val op = SdkHttpOperation.build<CreateDomainNameRequest, CreateDomainNameResponse> {
            serializeWith = CreateDomainNameOperationSerializer()
            deserializeWith = CreateDomainNameOperationDeserializer()
            operationName = "CreateDomainName"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a domain name access association resource between an access association source and a private custom domain name.
     */
    override suspend fun createDomainNameAccessAssociation(input: CreateDomainNameAccessAssociationRequest): CreateDomainNameAccessAssociationResponse {
        val op = SdkHttpOperation.build<CreateDomainNameAccessAssociationRequest, CreateDomainNameAccessAssociationResponse> {
            serializeWith = CreateDomainNameAccessAssociationOperationSerializer()
            deserializeWith = CreateDomainNameAccessAssociationOperationDeserializer()
            operationName = "CreateDomainNameAccessAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new Model resource to an existing RestApi resource.
     */
    override suspend fun createModel(input: CreateModelRequest): CreateModelResponse {
        val op = SdkHttpOperation.build<CreateModelRequest, CreateModelResponse> {
            serializeWith = CreateModelOperationSerializer()
            deserializeWith = CreateModelOperationDeserializer()
            operationName = "CreateModel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a RequestValidator of a given RestApi.
     */
    override suspend fun createRequestValidator(input: CreateRequestValidatorRequest): CreateRequestValidatorResponse {
        val op = SdkHttpOperation.build<CreateRequestValidatorRequest, CreateRequestValidatorResponse> {
            serializeWith = CreateRequestValidatorOperationSerializer()
            deserializeWith = CreateRequestValidatorOperationDeserializer()
            operationName = "CreateRequestValidator"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Resource resource.
     */
    override suspend fun createResource(input: CreateResourceRequest): CreateResourceResponse {
        val op = SdkHttpOperation.build<CreateResourceRequest, CreateResourceResponse> {
            serializeWith = CreateResourceOperationSerializer()
            deserializeWith = CreateResourceOperationDeserializer()
            operationName = "CreateResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new RestApi resource.
     */
    override suspend fun createRestApi(input: CreateRestApiRequest): CreateRestApiResponse {
        val op = SdkHttpOperation.build<CreateRestApiRequest, CreateRestApiResponse> {
            serializeWith = CreateRestApiOperationSerializer()
            deserializeWith = CreateRestApiOperationDeserializer()
            operationName = "CreateRestApi"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Stage resource that references a pre-existing Deployment for the API.
     */
    override suspend fun createStage(input: CreateStageRequest): CreateStageResponse {
        val op = SdkHttpOperation.build<CreateStageRequest, CreateStageResponse> {
            serializeWith = CreateStageOperationSerializer()
            deserializeWith = CreateStageOperationDeserializer()
            operationName = "CreateStage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload.
     */
    override suspend fun createUsagePlan(input: CreateUsagePlanRequest): CreateUsagePlanResponse {
        val op = SdkHttpOperation.build<CreateUsagePlanRequest, CreateUsagePlanResponse> {
            serializeWith = CreateUsagePlanOperationSerializer()
            deserializeWith = CreateUsagePlanOperationDeserializer()
            operationName = "CreateUsagePlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a usage plan key for adding an existing API key to a usage plan.
     */
    override suspend fun createUsagePlanKey(input: CreateUsagePlanKeyRequest): CreateUsagePlanKeyResponse {
        val op = SdkHttpOperation.build<CreateUsagePlanKeyRequest, CreateUsagePlanKeyResponse> {
            serializeWith = CreateUsagePlanKeyOperationSerializer()
            deserializeWith = CreateUsagePlanKeyOperationDeserializer()
            operationName = "CreateUsagePlanKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.
     */
    override suspend fun createVpcLink(input: CreateVpcLinkRequest): CreateVpcLinkResponse {
        val op = SdkHttpOperation.build<CreateVpcLinkRequest, CreateVpcLinkResponse> {
            serializeWith = CreateVpcLinkOperationSerializer()
            deserializeWith = CreateVpcLinkOperationDeserializer()
            operationName = "CreateVpcLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the ApiKey resource.
     */
    override suspend fun deleteApiKey(input: DeleteApiKeyRequest): DeleteApiKeyResponse {
        val op = SdkHttpOperation.build<DeleteApiKeyRequest, DeleteApiKeyResponse> {
            serializeWith = DeleteApiKeyOperationSerializer()
            deserializeWith = DeleteApiKeyOperationDeserializer()
            operationName = "DeleteApiKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Authorizer resource.
     */
    override suspend fun deleteAuthorizer(input: DeleteAuthorizerRequest): DeleteAuthorizerResponse {
        val op = SdkHttpOperation.build<DeleteAuthorizerRequest, DeleteAuthorizerResponse> {
            serializeWith = DeleteAuthorizerOperationSerializer()
            deserializeWith = DeleteAuthorizerOperationDeserializer()
            operationName = "DeleteAuthorizer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the BasePathMapping resource.
     */
    override suspend fun deleteBasePathMapping(input: DeleteBasePathMappingRequest): DeleteBasePathMappingResponse {
        val op = SdkHttpOperation.build<DeleteBasePathMappingRequest, DeleteBasePathMappingResponse> {
            serializeWith = DeleteBasePathMappingOperationSerializer()
            deserializeWith = DeleteBasePathMappingOperationDeserializer()
            operationName = "DeleteBasePathMapping"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the ClientCertificate resource.
     */
    override suspend fun deleteClientCertificate(input: DeleteClientCertificateRequest): DeleteClientCertificateResponse {
        val op = SdkHttpOperation.build<DeleteClientCertificateRequest, DeleteClientCertificateResponse> {
            serializeWith = DeleteClientCertificateOperationSerializer()
            deserializeWith = DeleteClientCertificateOperationDeserializer()
            operationName = "DeleteClientCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Deployment resource. Deleting a deployment will only succeed if there are no Stage resources associated with it.
     */
    override suspend fun deleteDeployment(input: DeleteDeploymentRequest): DeleteDeploymentResponse {
        val op = SdkHttpOperation.build<DeleteDeploymentRequest, DeleteDeploymentResponse> {
            serializeWith = DeleteDeploymentOperationSerializer()
            deserializeWith = DeleteDeploymentOperationDeserializer()
            operationName = "DeleteDeployment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a documentation part
     */
    override suspend fun deleteDocumentationPart(input: DeleteDocumentationPartRequest): DeleteDocumentationPartResponse {
        val op = SdkHttpOperation.build<DeleteDocumentationPartRequest, DeleteDocumentationPartResponse> {
            serializeWith = DeleteDocumentationPartOperationSerializer()
            deserializeWith = DeleteDocumentationPartOperationDeserializer()
            operationName = "DeleteDocumentationPart"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a documentation version.
     */
    override suspend fun deleteDocumentationVersion(input: DeleteDocumentationVersionRequest): DeleteDocumentationVersionResponse {
        val op = SdkHttpOperation.build<DeleteDocumentationVersionRequest, DeleteDocumentationVersionResponse> {
            serializeWith = DeleteDocumentationVersionOperationSerializer()
            deserializeWith = DeleteDocumentationVersionOperationDeserializer()
            operationName = "DeleteDocumentationVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the DomainName resource.
     */
    override suspend fun deleteDomainName(input: DeleteDomainNameRequest): DeleteDomainNameResponse {
        val op = SdkHttpOperation.build<DeleteDomainNameRequest, DeleteDomainNameResponse> {
            serializeWith = DeleteDomainNameOperationSerializer()
            deserializeWith = DeleteDomainNameOperationDeserializer()
            operationName = "DeleteDomainName"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the DomainNameAccessAssociation resource.
     *
     * Only the AWS account that created the DomainNameAccessAssociation resource can delete it. To stop an access association source in another AWS account from accessing your private custom domain name, use the RejectDomainNameAccessAssociation operation.
     */
    override suspend fun deleteDomainNameAccessAssociation(input: DeleteDomainNameAccessAssociationRequest): DeleteDomainNameAccessAssociationResponse {
        val op = SdkHttpOperation.build<DeleteDomainNameAccessAssociationRequest, DeleteDomainNameAccessAssociationResponse> {
            serializeWith = DeleteDomainNameAccessAssociationOperationSerializer()
            deserializeWith = DeleteDomainNameAccessAssociationOperationDeserializer()
            operationName = "DeleteDomainNameAccessAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it with the default settings.
     */
    override suspend fun deleteGatewayResponse(input: DeleteGatewayResponseRequest): DeleteGatewayResponseResponse {
        val op = SdkHttpOperation.build<DeleteGatewayResponseRequest, DeleteGatewayResponseResponse> {
            serializeWith = DeleteGatewayResponseOperationSerializer()
            deserializeWith = DeleteGatewayResponseOperationDeserializer()
            operationName = "DeleteGatewayResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a delete integration.
     */
    override suspend fun deleteIntegration(input: DeleteIntegrationRequest): DeleteIntegrationResponse {
        val op = SdkHttpOperation.build<DeleteIntegrationRequest, DeleteIntegrationResponse> {
            serializeWith = DeleteIntegrationOperationSerializer()
            deserializeWith = DeleteIntegrationOperationDeserializer()
            operationName = "DeleteIntegration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a delete integration response.
     */
    override suspend fun deleteIntegrationResponse(input: DeleteIntegrationResponseRequest): DeleteIntegrationResponseResponse {
        val op = SdkHttpOperation.build<DeleteIntegrationResponseRequest, DeleteIntegrationResponseResponse> {
            serializeWith = DeleteIntegrationResponseOperationSerializer()
            deserializeWith = DeleteIntegrationResponseOperationDeserializer()
            operationName = "DeleteIntegrationResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Method resource.
     */
    override suspend fun deleteMethod(input: DeleteMethodRequest): DeleteMethodResponse {
        val op = SdkHttpOperation.build<DeleteMethodRequest, DeleteMethodResponse> {
            serializeWith = DeleteMethodOperationSerializer()
            deserializeWith = DeleteMethodOperationDeserializer()
            operationName = "DeleteMethod"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing MethodResponse resource.
     */
    override suspend fun deleteMethodResponse(input: DeleteMethodResponseRequest): DeleteMethodResponseResponse {
        val op = SdkHttpOperation.build<DeleteMethodResponseRequest, DeleteMethodResponseResponse> {
            serializeWith = DeleteMethodResponseOperationSerializer()
            deserializeWith = DeleteMethodResponseOperationDeserializer()
            operationName = "DeleteMethodResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a model.
     */
    override suspend fun deleteModel(input: DeleteModelRequest): DeleteModelResponse {
        val op = SdkHttpOperation.build<DeleteModelRequest, DeleteModelResponse> {
            serializeWith = DeleteModelOperationSerializer()
            deserializeWith = DeleteModelOperationDeserializer()
            operationName = "DeleteModel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a RequestValidator of a given RestApi.
     */
    override suspend fun deleteRequestValidator(input: DeleteRequestValidatorRequest): DeleteRequestValidatorResponse {
        val op = SdkHttpOperation.build<DeleteRequestValidatorRequest, DeleteRequestValidatorResponse> {
            serializeWith = DeleteRequestValidatorOperationSerializer()
            deserializeWith = DeleteRequestValidatorOperationDeserializer()
            operationName = "DeleteRequestValidator"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Resource resource.
     */
    override suspend fun deleteResource(input: DeleteResourceRequest): DeleteResourceResponse {
        val op = SdkHttpOperation.build<DeleteResourceRequest, DeleteResourceResponse> {
            serializeWith = DeleteResourceOperationSerializer()
            deserializeWith = DeleteResourceOperationDeserializer()
            operationName = "DeleteResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified API.
     */
    override suspend fun deleteRestApi(input: DeleteRestApiRequest): DeleteRestApiResponse {
        val op = SdkHttpOperation.build<DeleteRestApiRequest, DeleteRestApiResponse> {
            serializeWith = DeleteRestApiOperationSerializer()
            deserializeWith = DeleteRestApiOperationDeserializer()
            operationName = "DeleteRestApi"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Stage resource.
     */
    override suspend fun deleteStage(input: DeleteStageRequest): DeleteStageResponse {
        val op = SdkHttpOperation.build<DeleteStageRequest, DeleteStageResponse> {
            serializeWith = DeleteStageOperationSerializer()
            deserializeWith = DeleteStageOperationDeserializer()
            operationName = "DeleteStage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a usage plan of a given plan Id.
     */
    override suspend fun deleteUsagePlan(input: DeleteUsagePlanRequest): DeleteUsagePlanResponse {
        val op = SdkHttpOperation.build<DeleteUsagePlanRequest, DeleteUsagePlanResponse> {
            serializeWith = DeleteUsagePlanOperationSerializer()
            deserializeWith = DeleteUsagePlanOperationDeserializer()
            operationName = "DeleteUsagePlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a usage plan key and remove the underlying API key from the associated usage plan.
     */
    override suspend fun deleteUsagePlanKey(input: DeleteUsagePlanKeyRequest): DeleteUsagePlanKeyResponse {
        val op = SdkHttpOperation.build<DeleteUsagePlanKeyRequest, DeleteUsagePlanKeyResponse> {
            serializeWith = DeleteUsagePlanKeyOperationSerializer()
            deserializeWith = DeleteUsagePlanKeyOperationDeserializer()
            operationName = "DeleteUsagePlanKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing VpcLink of a specified identifier.
     */
    override suspend fun deleteVpcLink(input: DeleteVpcLinkRequest): DeleteVpcLinkResponse {
        val op = SdkHttpOperation.build<DeleteVpcLinkRequest, DeleteVpcLinkResponse> {
            serializeWith = DeleteVpcLinkOperationSerializer()
            deserializeWith = DeleteVpcLinkOperationDeserializer()
            operationName = "DeleteVpcLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Flushes all authorizer cache entries on a stage.
     */
    override suspend fun flushStageAuthorizersCache(input: FlushStageAuthorizersCacheRequest): FlushStageAuthorizersCacheResponse {
        val op = SdkHttpOperation.build<FlushStageAuthorizersCacheRequest, FlushStageAuthorizersCacheResponse> {
            serializeWith = FlushStageAuthorizersCacheOperationSerializer()
            deserializeWith = FlushStageAuthorizersCacheOperationDeserializer()
            operationName = "FlushStageAuthorizersCache"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Flushes a stage's cache.
     */
    override suspend fun flushStageCache(input: FlushStageCacheRequest): FlushStageCacheResponse {
        val op = SdkHttpOperation.build<FlushStageCacheRequest, FlushStageCacheResponse> {
            serializeWith = FlushStageCacheOperationSerializer()
            deserializeWith = FlushStageCacheOperationDeserializer()
            operationName = "FlushStageCache"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Generates a ClientCertificate resource.
     */
    override suspend fun generateClientCertificate(input: GenerateClientCertificateRequest): GenerateClientCertificateResponse {
        val op = SdkHttpOperation.build<GenerateClientCertificateRequest, GenerateClientCertificateResponse> {
            serializeWith = GenerateClientCertificateOperationSerializer()
            deserializeWith = GenerateClientCertificateOperationDeserializer()
            operationName = "GenerateClientCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the current Account resource.
     */
    override suspend fun getAccount(input: GetAccountRequest): GetAccountResponse {
        val op = SdkHttpOperation.build<GetAccountRequest, GetAccountResponse> {
            serializeWith = GetAccountOperationSerializer()
            deserializeWith = GetAccountOperationDeserializer()
            operationName = "GetAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the current ApiKey resource.
     */
    override suspend fun getApiKey(input: GetApiKeyRequest): GetApiKeyResponse {
        val op = SdkHttpOperation.build<GetApiKeyRequest, GetApiKeyResponse> {
            serializeWith = GetApiKeyOperationSerializer()
            deserializeWith = GetApiKeyOperationDeserializer()
            operationName = "GetApiKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the current ApiKeys resource.
     */
    override suspend fun getApiKeys(input: GetApiKeysRequest): GetApiKeysResponse {
        val op = SdkHttpOperation.build<GetApiKeysRequest, GetApiKeysResponse> {
            serializeWith = GetApiKeysOperationSerializer()
            deserializeWith = GetApiKeysOperationDeserializer()
            operationName = "GetApiKeys"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describe an existing Authorizer resource.
     */
    override suspend fun getAuthorizer(input: GetAuthorizerRequest): GetAuthorizerResponse {
        val op = SdkHttpOperation.build<GetAuthorizerRequest, GetAuthorizerResponse> {
            serializeWith = GetAuthorizerOperationSerializer()
            deserializeWith = GetAuthorizerOperationDeserializer()
            operationName = "GetAuthorizer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describe an existing Authorizers resource.
     */
    override suspend fun getAuthorizers(input: GetAuthorizersRequest): GetAuthorizersResponse {
        val op = SdkHttpOperation.build<GetAuthorizersRequest, GetAuthorizersResponse> {
            serializeWith = GetAuthorizersOperationSerializer()
            deserializeWith = GetAuthorizersOperationDeserializer()
            operationName = "GetAuthorizers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describe a BasePathMapping resource.
     */
    override suspend fun getBasePathMapping(input: GetBasePathMappingRequest): GetBasePathMappingResponse {
        val op = SdkHttpOperation.build<GetBasePathMappingRequest, GetBasePathMappingResponse> {
            serializeWith = GetBasePathMappingOperationSerializer()
            deserializeWith = GetBasePathMappingOperationDeserializer()
            operationName = "GetBasePathMapping"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a collection of BasePathMapping resources.
     */
    override suspend fun getBasePathMappings(input: GetBasePathMappingsRequest): GetBasePathMappingsResponse {
        val op = SdkHttpOperation.build<GetBasePathMappingsRequest, GetBasePathMappingsResponse> {
            serializeWith = GetBasePathMappingsOperationSerializer()
            deserializeWith = GetBasePathMappingsOperationDeserializer()
            operationName = "GetBasePathMappings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the current ClientCertificate resource.
     */
    override suspend fun getClientCertificate(input: GetClientCertificateRequest): GetClientCertificateResponse {
        val op = SdkHttpOperation.build<GetClientCertificateRequest, GetClientCertificateResponse> {
            serializeWith = GetClientCertificateOperationSerializer()
            deserializeWith = GetClientCertificateOperationDeserializer()
            operationName = "GetClientCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a collection of ClientCertificate resources.
     */
    override suspend fun getClientCertificates(input: GetClientCertificatesRequest): GetClientCertificatesResponse {
        val op = SdkHttpOperation.build<GetClientCertificatesRequest, GetClientCertificatesResponse> {
            serializeWith = GetClientCertificatesOperationSerializer()
            deserializeWith = GetClientCertificatesOperationDeserializer()
            operationName = "GetClientCertificates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Deployment resource.
     */
    override suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse {
        val op = SdkHttpOperation.build<GetDeploymentRequest, GetDeploymentResponse> {
            serializeWith = GetDeploymentOperationSerializer()
            deserializeWith = GetDeploymentOperationDeserializer()
            operationName = "GetDeployment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Deployments collection.
     */
    override suspend fun getDeployments(input: GetDeploymentsRequest): GetDeploymentsResponse {
        val op = SdkHttpOperation.build<GetDeploymentsRequest, GetDeploymentsResponse> {
            serializeWith = GetDeploymentsOperationSerializer()
            deserializeWith = GetDeploymentsOperationDeserializer()
            operationName = "GetDeployments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a documentation part.
     */
    override suspend fun getDocumentationPart(input: GetDocumentationPartRequest): GetDocumentationPartResponse {
        val op = SdkHttpOperation.build<GetDocumentationPartRequest, GetDocumentationPartResponse> {
            serializeWith = GetDocumentationPartOperationSerializer()
            deserializeWith = GetDocumentationPartOperationDeserializer()
            operationName = "GetDocumentationPart"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets documentation parts.
     */
    override suspend fun getDocumentationParts(input: GetDocumentationPartsRequest): GetDocumentationPartsResponse {
        val op = SdkHttpOperation.build<GetDocumentationPartsRequest, GetDocumentationPartsResponse> {
            serializeWith = GetDocumentationPartsOperationSerializer()
            deserializeWith = GetDocumentationPartsOperationDeserializer()
            operationName = "GetDocumentationParts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a documentation version.
     */
    override suspend fun getDocumentationVersion(input: GetDocumentationVersionRequest): GetDocumentationVersionResponse {
        val op = SdkHttpOperation.build<GetDocumentationVersionRequest, GetDocumentationVersionResponse> {
            serializeWith = GetDocumentationVersionOperationSerializer()
            deserializeWith = GetDocumentationVersionOperationDeserializer()
            operationName = "GetDocumentationVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets documentation versions.
     */
    override suspend fun getDocumentationVersions(input: GetDocumentationVersionsRequest): GetDocumentationVersionsResponse {
        val op = SdkHttpOperation.build<GetDocumentationVersionsRequest, GetDocumentationVersionsResponse> {
            serializeWith = GetDocumentationVersionsOperationSerializer()
            deserializeWith = GetDocumentationVersionsOperationDeserializer()
            operationName = "GetDocumentationVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     */
    override suspend fun getDomainName(input: GetDomainNameRequest): GetDomainNameResponse {
        val op = SdkHttpOperation.build<GetDomainNameRequest, GetDomainNameResponse> {
            serializeWith = GetDomainNameOperationSerializer()
            deserializeWith = GetDomainNameOperationDeserializer()
            operationName = "GetDomainName"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a collection on DomainNameAccessAssociations resources.
     */
    override suspend fun getDomainNameAccessAssociations(input: GetDomainNameAccessAssociationsRequest): GetDomainNameAccessAssociationsResponse {
        val op = SdkHttpOperation.build<GetDomainNameAccessAssociationsRequest, GetDomainNameAccessAssociationsResponse> {
            serializeWith = GetDomainNameAccessAssociationsOperationSerializer()
            deserializeWith = GetDomainNameAccessAssociationsOperationDeserializer()
            operationName = "GetDomainNameAccessAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a collection of DomainName resources.
     */
    override suspend fun getDomainNames(input: GetDomainNamesRequest): GetDomainNamesResponse {
        val op = SdkHttpOperation.build<GetDomainNamesRequest, GetDomainNamesResponse> {
            serializeWith = GetDomainNamesOperationSerializer()
            deserializeWith = GetDomainNamesOperationDeserializer()
            operationName = "GetDomainNames"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Exports a deployed version of a RestApi in a specified format.
     */
    override suspend fun getExport(input: GetExportRequest): GetExportResponse {
        val op = SdkHttpOperation.build<GetExportRequest, GetExportResponse> {
            serializeWith = GetExportOperationSerializer()
            deserializeWith = GetExportOperationDeserializer()
            operationName = "GetExport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a GatewayResponse of a specified response type on the given RestApi.
     */
    override suspend fun getGatewayResponse(input: GetGatewayResponseRequest): GetGatewayResponseResponse {
        val op = SdkHttpOperation.build<GetGatewayResponseRequest, GetGatewayResponseResponse> {
            serializeWith = GetGatewayResponseOperationSerializer()
            deserializeWith = GetGatewayResponseOperationDeserializer()
            operationName = "GetGatewayResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the supported response types.
     */
    override suspend fun getGatewayResponses(input: GetGatewayResponsesRequest): GetGatewayResponsesResponse {
        val op = SdkHttpOperation.build<GetGatewayResponsesRequest, GetGatewayResponsesResponse> {
            serializeWith = GetGatewayResponsesOperationSerializer()
            deserializeWith = GetGatewayResponsesOperationDeserializer()
            operationName = "GetGatewayResponses"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the integration settings.
     */
    override suspend fun getIntegration(input: GetIntegrationRequest): GetIntegrationResponse {
        val op = SdkHttpOperation.build<GetIntegrationRequest, GetIntegrationResponse> {
            serializeWith = GetIntegrationOperationSerializer()
            deserializeWith = GetIntegrationOperationDeserializer()
            operationName = "GetIntegration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a get integration response.
     */
    override suspend fun getIntegrationResponse(input: GetIntegrationResponseRequest): GetIntegrationResponseResponse {
        val op = SdkHttpOperation.build<GetIntegrationResponseRequest, GetIntegrationResponseResponse> {
            serializeWith = GetIntegrationResponseOperationSerializer()
            deserializeWith = GetIntegrationResponseOperationDeserializer()
            operationName = "GetIntegrationResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describe an existing Method resource.
     */
    override suspend fun getMethod(input: GetMethodRequest): GetMethodResponse {
        val op = SdkHttpOperation.build<GetMethodRequest, GetMethodResponse> {
            serializeWith = GetMethodOperationSerializer()
            deserializeWith = GetMethodOperationDeserializer()
            operationName = "GetMethod"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a MethodResponse resource.
     */
    override suspend fun getMethodResponse(input: GetMethodResponseRequest): GetMethodResponseResponse {
        val op = SdkHttpOperation.build<GetMethodResponseRequest, GetMethodResponseResponse> {
            serializeWith = GetMethodResponseOperationSerializer()
            deserializeWith = GetMethodResponseOperationDeserializer()
            operationName = "GetMethodResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing model defined for a RestApi resource.
     */
    override suspend fun getModel(input: GetModelRequest): GetModelResponse {
        val op = SdkHttpOperation.build<GetModelRequest, GetModelResponse> {
            serializeWith = GetModelOperationSerializer()
            deserializeWith = GetModelOperationDeserializer()
            operationName = "GetModel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     */
    override suspend fun getModelTemplate(input: GetModelTemplateRequest): GetModelTemplateResponse {
        val op = SdkHttpOperation.build<GetModelTemplateRequest, GetModelTemplateResponse> {
            serializeWith = GetModelTemplateOperationSerializer()
            deserializeWith = GetModelTemplateOperationDeserializer()
            operationName = "GetModelTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes existing Models defined for a RestApi resource.
     */
    override suspend fun getModels(input: GetModelsRequest): GetModelsResponse {
        val op = SdkHttpOperation.build<GetModelsRequest, GetModelsResponse> {
            serializeWith = GetModelsOperationSerializer()
            deserializeWith = GetModelsOperationDeserializer()
            operationName = "GetModels"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a RequestValidator of a given RestApi.
     */
    override suspend fun getRequestValidator(input: GetRequestValidatorRequest): GetRequestValidatorResponse {
        val op = SdkHttpOperation.build<GetRequestValidatorRequest, GetRequestValidatorResponse> {
            serializeWith = GetRequestValidatorOperationSerializer()
            deserializeWith = GetRequestValidatorOperationDeserializer()
            operationName = "GetRequestValidator"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the RequestValidators collection of a given RestApi.
     */
    override suspend fun getRequestValidators(input: GetRequestValidatorsRequest): GetRequestValidatorsResponse {
        val op = SdkHttpOperation.build<GetRequestValidatorsRequest, GetRequestValidatorsResponse> {
            serializeWith = GetRequestValidatorsOperationSerializer()
            deserializeWith = GetRequestValidatorsOperationDeserializer()
            operationName = "GetRequestValidators"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about a resource.
     */
    override suspend fun getResource(input: GetResourceRequest): GetResourceResponse {
        val op = SdkHttpOperation.build<GetResourceRequest, GetResourceResponse> {
            serializeWith = GetResourceOperationSerializer()
            deserializeWith = GetResourceOperationDeserializer()
            operationName = "GetResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about a collection of Resource resources.
     */
    override suspend fun getResources(input: GetResourcesRequest): GetResourcesResponse {
        val op = SdkHttpOperation.build<GetResourcesRequest, GetResourcesResponse> {
            serializeWith = GetResourcesOperationSerializer()
            deserializeWith = GetResourcesOperationDeserializer()
            operationName = "GetResources"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the RestApi resource in the collection.
     */
    override suspend fun getRestApi(input: GetRestApiRequest): GetRestApiResponse {
        val op = SdkHttpOperation.build<GetRestApiRequest, GetRestApiResponse> {
            serializeWith = GetRestApiOperationSerializer()
            deserializeWith = GetRestApiOperationDeserializer()
            operationName = "GetRestApi"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the RestApis resources for your collection.
     */
    override suspend fun getRestApis(input: GetRestApisRequest): GetRestApisResponse {
        val op = SdkHttpOperation.build<GetRestApisRequest, GetRestApisResponse> {
            serializeWith = GetRestApisOperationSerializer()
            deserializeWith = GetRestApisOperationDeserializer()
            operationName = "GetRestApis"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Generates a client SDK for a RestApi and Stage.
     */
    override suspend fun getSdk(input: GetSdkRequest): GetSdkResponse {
        val op = SdkHttpOperation.build<GetSdkRequest, GetSdkResponse> {
            serializeWith = GetSdkOperationSerializer()
            deserializeWith = GetSdkOperationDeserializer()
            operationName = "GetSdk"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an SDK type.
     */
    override suspend fun getSdkType(input: GetSdkTypeRequest): GetSdkTypeResponse {
        val op = SdkHttpOperation.build<GetSdkTypeRequest, GetSdkTypeResponse> {
            serializeWith = GetSdkTypeOperationSerializer()
            deserializeWith = GetSdkTypeOperationDeserializer()
            operationName = "GetSdkType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets SDK types
     */
    override suspend fun getSdkTypes(input: GetSdkTypesRequest): GetSdkTypesResponse {
        val op = SdkHttpOperation.build<GetSdkTypesRequest, GetSdkTypesResponse> {
            serializeWith = GetSdkTypesOperationSerializer()
            deserializeWith = GetSdkTypesOperationDeserializer()
            operationName = "GetSdkTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Stage resource.
     */
    override suspend fun getStage(input: GetStageRequest): GetStageResponse {
        val op = SdkHttpOperation.build<GetStageRequest, GetStageResponse> {
            serializeWith = GetStageOperationSerializer()
            deserializeWith = GetStageOperationDeserializer()
            operationName = "GetStage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more Stage resources.
     */
    override suspend fun getStages(input: GetStagesRequest): GetStagesResponse {
        val op = SdkHttpOperation.build<GetStagesRequest, GetStagesResponse> {
            serializeWith = GetStagesOperationSerializer()
            deserializeWith = GetStagesOperationDeserializer()
            operationName = "GetStages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the Tags collection for a given resource.
     */
    override suspend fun getTags(input: GetTagsRequest): GetTagsResponse {
        val op = SdkHttpOperation.build<GetTagsRequest, GetTagsResponse> {
            serializeWith = GetTagsOperationSerializer()
            deserializeWith = GetTagsOperationDeserializer()
            operationName = "GetTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the usage data of a usage plan in a specified time interval.
     */
    override suspend fun getUsage(input: GetUsageRequest): GetUsageResponse {
        val op = SdkHttpOperation.build<GetUsageRequest, GetUsageResponse> {
            serializeWith = GetUsageOperationSerializer()
            deserializeWith = GetUsageOperationDeserializer()
            operationName = "GetUsage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a usage plan of a given plan identifier.
     */
    override suspend fun getUsagePlan(input: GetUsagePlanRequest): GetUsagePlanResponse {
        val op = SdkHttpOperation.build<GetUsagePlanRequest, GetUsagePlanResponse> {
            serializeWith = GetUsagePlanOperationSerializer()
            deserializeWith = GetUsagePlanOperationDeserializer()
            operationName = "GetUsagePlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a usage plan key of a given key identifier.
     */
    override suspend fun getUsagePlanKey(input: GetUsagePlanKeyRequest): GetUsagePlanKeyResponse {
        val op = SdkHttpOperation.build<GetUsagePlanKeyRequest, GetUsagePlanKeyResponse> {
            serializeWith = GetUsagePlanKeyOperationSerializer()
            deserializeWith = GetUsagePlanKeyOperationDeserializer()
            operationName = "GetUsagePlanKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     */
    override suspend fun getUsagePlanKeys(input: GetUsagePlanKeysRequest): GetUsagePlanKeysResponse {
        val op = SdkHttpOperation.build<GetUsagePlanKeysRequest, GetUsagePlanKeysResponse> {
            serializeWith = GetUsagePlanKeysOperationSerializer()
            deserializeWith = GetUsagePlanKeysOperationDeserializer()
            operationName = "GetUsagePlanKeys"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets all the usage plans of the caller's account.
     */
    override suspend fun getUsagePlans(input: GetUsagePlansRequest): GetUsagePlansResponse {
        val op = SdkHttpOperation.build<GetUsagePlansRequest, GetUsagePlansResponse> {
            serializeWith = GetUsagePlansOperationSerializer()
            deserializeWith = GetUsagePlansOperationDeserializer()
            operationName = "GetUsagePlans"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a specified VPC link under the caller's account in a region.
     */
    override suspend fun getVpcLink(input: GetVpcLinkRequest): GetVpcLinkResponse {
        val op = SdkHttpOperation.build<GetVpcLinkRequest, GetVpcLinkResponse> {
            serializeWith = GetVpcLinkOperationSerializer()
            deserializeWith = GetVpcLinkOperationDeserializer()
            operationName = "GetVpcLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the VpcLinks collection under the caller's account in a selected region.
     */
    override suspend fun getVpcLinks(input: GetVpcLinksRequest): GetVpcLinksResponse {
        val op = SdkHttpOperation.build<GetVpcLinksRequest, GetVpcLinksResponse> {
            serializeWith = GetVpcLinksOperationSerializer()
            deserializeWith = GetVpcLinksOperationDeserializer()
            operationName = "GetVpcLinks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Import API keys from an external source, such as a CSV-formatted file.
     */
    override suspend fun importApiKeys(input: ImportApiKeysRequest): ImportApiKeysResponse {
        val op = SdkHttpOperation.build<ImportApiKeysRequest, ImportApiKeysResponse> {
            serializeWith = ImportApiKeysOperationSerializer()
            deserializeWith = ImportApiKeysOperationDeserializer()
            operationName = "ImportApiKeys"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Imports documentation parts
     */
    override suspend fun importDocumentationParts(input: ImportDocumentationPartsRequest): ImportDocumentationPartsResponse {
        val op = SdkHttpOperation.build<ImportDocumentationPartsRequest, ImportDocumentationPartsResponse> {
            serializeWith = ImportDocumentationPartsOperationSerializer()
            deserializeWith = ImportDocumentationPartsOperationDeserializer()
            operationName = "ImportDocumentationParts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     */
    override suspend fun importRestApi(input: ImportRestApiRequest): ImportRestApiResponse {
        val op = SdkHttpOperation.build<ImportRestApiRequest, ImportRestApiResponse> {
            serializeWith = ImportRestApiOperationSerializer()
            deserializeWith = ImportRestApiOperationDeserializer()
            operationName = "ImportRestApi"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.
     */
    override suspend fun putGatewayResponse(input: PutGatewayResponseRequest): PutGatewayResponseResponse {
        val op = SdkHttpOperation.build<PutGatewayResponseRequest, PutGatewayResponseResponse> {
            serializeWith = PutGatewayResponseOperationSerializer()
            deserializeWith = PutGatewayResponseOperationDeserializer()
            operationName = "PutGatewayResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets up a method's integration.
     */
    override suspend fun putIntegration(input: PutIntegrationRequest): PutIntegrationResponse {
        val op = SdkHttpOperation.build<PutIntegrationRequest, PutIntegrationResponse> {
            serializeWith = PutIntegrationOperationSerializer()
            deserializeWith = PutIntegrationOperationDeserializer()
            operationName = "PutIntegration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Represents a put integration.
     */
    override suspend fun putIntegrationResponse(input: PutIntegrationResponseRequest): PutIntegrationResponseResponse {
        val op = SdkHttpOperation.build<PutIntegrationResponseRequest, PutIntegrationResponseResponse> {
            serializeWith = PutIntegrationResponseOperationSerializer()
            deserializeWith = PutIntegrationResponseOperationDeserializer()
            operationName = "PutIntegrationResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Add a method to an existing Resource resource.
     */
    override suspend fun putMethod(input: PutMethodRequest): PutMethodResponse {
        val op = SdkHttpOperation.build<PutMethodRequest, PutMethodResponse> {
            serializeWith = PutMethodOperationSerializer()
            deserializeWith = PutMethodOperationDeserializer()
            operationName = "PutMethod"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a MethodResponse to an existing Method resource.
     */
    override suspend fun putMethodResponse(input: PutMethodResponseRequest): PutMethodResponseResponse {
        val op = SdkHttpOperation.build<PutMethodResponseRequest, PutMethodResponseResponse> {
            serializeWith = PutMethodResponseOperationSerializer()
            deserializeWith = PutMethodResponseOperationDeserializer()
            operationName = "PutMethodResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * A feature of the API Gateway control service for updating an existing API with an input of external API definitions. The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.
     */
    override suspend fun putRestApi(input: PutRestApiRequest): PutRestApiResponse {
        val op = SdkHttpOperation.build<PutRestApiRequest, PutRestApiResponse> {
            serializeWith = PutRestApiOperationSerializer()
            deserializeWith = PutRestApiOperationDeserializer()
            operationName = "PutRestApi"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Rejects a domain name access association with a private custom domain name.
     *
     * To reject a domain name access association with an access association source in another AWS account, use this operation. To remove a domain name access association with an access association source in your own account, use the DeleteDomainNameAccessAssociation operation.
     */
    override suspend fun rejectDomainNameAccessAssociation(input: RejectDomainNameAccessAssociationRequest): RejectDomainNameAccessAssociationResponse {
        val op = SdkHttpOperation.build<RejectDomainNameAccessAssociationRequest, RejectDomainNameAccessAssociationResponse> {
            serializeWith = RejectDomainNameAccessAssociationOperationSerializer()
            deserializeWith = RejectDomainNameAccessAssociationOperationDeserializer()
            operationName = "RejectDomainNameAccessAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates a tag on a given resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Simulate the execution of an Authorizer in your RestApi with headers, parameters, and an incoming request body.
     */
    override suspend fun testInvokeAuthorizer(input: TestInvokeAuthorizerRequest): TestInvokeAuthorizerResponse {
        val op = SdkHttpOperation.build<TestInvokeAuthorizerRequest, TestInvokeAuthorizerResponse> {
            serializeWith = TestInvokeAuthorizerOperationSerializer()
            deserializeWith = TestInvokeAuthorizerOperationDeserializer()
            operationName = "TestInvokeAuthorizer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Simulate the invocation of a Method in your RestApi with headers, parameters, and an incoming request body.
     */
    override suspend fun testInvokeMethod(input: TestInvokeMethodRequest): TestInvokeMethodResponse {
        val op = SdkHttpOperation.build<TestInvokeMethodRequest, TestInvokeMethodResponse> {
            serializeWith = TestInvokeMethodOperationSerializer()
            deserializeWith = TestInvokeMethodOperationDeserializer()
            operationName = "TestInvokeMethod"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from a given resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about the current Account resource.
     */
    override suspend fun updateAccount(input: UpdateAccountRequest): UpdateAccountResponse {
        val op = SdkHttpOperation.build<UpdateAccountRequest, UpdateAccountResponse> {
            serializeWith = UpdateAccountOperationSerializer()
            deserializeWith = UpdateAccountOperationDeserializer()
            operationName = "UpdateAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about an ApiKey resource.
     */
    override suspend fun updateApiKey(input: UpdateApiKeyRequest): UpdateApiKeyResponse {
        val op = SdkHttpOperation.build<UpdateApiKeyRequest, UpdateApiKeyResponse> {
            serializeWith = UpdateApiKeyOperationSerializer()
            deserializeWith = UpdateApiKeyOperationDeserializer()
            operationName = "UpdateApiKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Authorizer resource.
     */
    override suspend fun updateAuthorizer(input: UpdateAuthorizerRequest): UpdateAuthorizerResponse {
        val op = SdkHttpOperation.build<UpdateAuthorizerRequest, UpdateAuthorizerResponse> {
            serializeWith = UpdateAuthorizerOperationSerializer()
            deserializeWith = UpdateAuthorizerOperationDeserializer()
            operationName = "UpdateAuthorizer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about the BasePathMapping resource.
     */
    override suspend fun updateBasePathMapping(input: UpdateBasePathMappingRequest): UpdateBasePathMappingResponse {
        val op = SdkHttpOperation.build<UpdateBasePathMappingRequest, UpdateBasePathMappingResponse> {
            serializeWith = UpdateBasePathMappingOperationSerializer()
            deserializeWith = UpdateBasePathMappingOperationDeserializer()
            operationName = "UpdateBasePathMapping"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about an ClientCertificate resource.
     */
    override suspend fun updateClientCertificate(input: UpdateClientCertificateRequest): UpdateClientCertificateResponse {
        val op = SdkHttpOperation.build<UpdateClientCertificateRequest, UpdateClientCertificateResponse> {
            serializeWith = UpdateClientCertificateOperationSerializer()
            deserializeWith = UpdateClientCertificateOperationDeserializer()
            operationName = "UpdateClientCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about a Deployment resource.
     */
    override suspend fun updateDeployment(input: UpdateDeploymentRequest): UpdateDeploymentResponse {
        val op = SdkHttpOperation.build<UpdateDeploymentRequest, UpdateDeploymentResponse> {
            serializeWith = UpdateDeploymentOperationSerializer()
            deserializeWith = UpdateDeploymentOperationDeserializer()
            operationName = "UpdateDeployment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a documentation part.
     */
    override suspend fun updateDocumentationPart(input: UpdateDocumentationPartRequest): UpdateDocumentationPartResponse {
        val op = SdkHttpOperation.build<UpdateDocumentationPartRequest, UpdateDocumentationPartResponse> {
            serializeWith = UpdateDocumentationPartOperationSerializer()
            deserializeWith = UpdateDocumentationPartOperationDeserializer()
            operationName = "UpdateDocumentationPart"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a documentation version.
     */
    override suspend fun updateDocumentationVersion(input: UpdateDocumentationVersionRequest): UpdateDocumentationVersionResponse {
        val op = SdkHttpOperation.build<UpdateDocumentationVersionRequest, UpdateDocumentationVersionResponse> {
            serializeWith = UpdateDocumentationVersionOperationSerializer()
            deserializeWith = UpdateDocumentationVersionOperationDeserializer()
            operationName = "UpdateDocumentationVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about the DomainName resource.
     */
    override suspend fun updateDomainName(input: UpdateDomainNameRequest): UpdateDomainNameResponse {
        val op = SdkHttpOperation.build<UpdateDomainNameRequest, UpdateDomainNameResponse> {
            serializeWith = UpdateDomainNameOperationSerializer()
            deserializeWith = UpdateDomainNameOperationDeserializer()
            operationName = "UpdateDomainName"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a GatewayResponse of a specified response type on the given RestApi.
     */
    override suspend fun updateGatewayResponse(input: UpdateGatewayResponseRequest): UpdateGatewayResponseResponse {
        val op = SdkHttpOperation.build<UpdateGatewayResponseRequest, UpdateGatewayResponseResponse> {
            serializeWith = UpdateGatewayResponseOperationSerializer()
            deserializeWith = UpdateGatewayResponseOperationDeserializer()
            operationName = "UpdateGatewayResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Represents an update integration.
     */
    override suspend fun updateIntegration(input: UpdateIntegrationRequest): UpdateIntegrationResponse {
        val op = SdkHttpOperation.build<UpdateIntegrationRequest, UpdateIntegrationResponse> {
            serializeWith = UpdateIntegrationOperationSerializer()
            deserializeWith = UpdateIntegrationOperationDeserializer()
            operationName = "UpdateIntegration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Represents an update integration response.
     */
    override suspend fun updateIntegrationResponse(input: UpdateIntegrationResponseRequest): UpdateIntegrationResponseResponse {
        val op = SdkHttpOperation.build<UpdateIntegrationResponseRequest, UpdateIntegrationResponseResponse> {
            serializeWith = UpdateIntegrationResponseOperationSerializer()
            deserializeWith = UpdateIntegrationResponseOperationDeserializer()
            operationName = "UpdateIntegrationResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Method resource.
     */
    override suspend fun updateMethod(input: UpdateMethodRequest): UpdateMethodResponse {
        val op = SdkHttpOperation.build<UpdateMethodRequest, UpdateMethodResponse> {
            serializeWith = UpdateMethodOperationSerializer()
            deserializeWith = UpdateMethodOperationDeserializer()
            operationName = "UpdateMethod"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing MethodResponse resource.
     */
    override suspend fun updateMethodResponse(input: UpdateMethodResponseRequest): UpdateMethodResponseResponse {
        val op = SdkHttpOperation.build<UpdateMethodResponseRequest, UpdateMethodResponseResponse> {
            serializeWith = UpdateMethodResponseOperationSerializer()
            deserializeWith = UpdateMethodResponseOperationDeserializer()
            operationName = "UpdateMethodResponse"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about a model. The maximum size of the model is 400 KB.
     */
    override suspend fun updateModel(input: UpdateModelRequest): UpdateModelResponse {
        val op = SdkHttpOperation.build<UpdateModelRequest, UpdateModelResponse> {
            serializeWith = UpdateModelOperationSerializer()
            deserializeWith = UpdateModelOperationDeserializer()
            operationName = "UpdateModel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a RequestValidator of a given RestApi.
     */
    override suspend fun updateRequestValidator(input: UpdateRequestValidatorRequest): UpdateRequestValidatorResponse {
        val op = SdkHttpOperation.build<UpdateRequestValidatorRequest, UpdateRequestValidatorResponse> {
            serializeWith = UpdateRequestValidatorOperationSerializer()
            deserializeWith = UpdateRequestValidatorOperationDeserializer()
            operationName = "UpdateRequestValidator"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about a Resource resource.
     */
    override suspend fun updateResource(input: UpdateResourceRequest): UpdateResourceResponse {
        val op = SdkHttpOperation.build<UpdateResourceRequest, UpdateResourceResponse> {
            serializeWith = UpdateResourceOperationSerializer()
            deserializeWith = UpdateResourceOperationDeserializer()
            operationName = "UpdateResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about the specified API.
     */
    override suspend fun updateRestApi(input: UpdateRestApiRequest): UpdateRestApiResponse {
        val op = SdkHttpOperation.build<UpdateRestApiRequest, UpdateRestApiResponse> {
            serializeWith = UpdateRestApiOperationSerializer()
            deserializeWith = UpdateRestApiOperationDeserializer()
            operationName = "UpdateRestApi"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Changes information about a Stage resource.
     */
    override suspend fun updateStage(input: UpdateStageRequest): UpdateStageResponse {
        val op = SdkHttpOperation.build<UpdateStageRequest, UpdateStageResponse> {
            serializeWith = UpdateStageOperationSerializer()
            deserializeWith = UpdateStageOperationDeserializer()
            operationName = "UpdateStage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     */
    override suspend fun updateUsage(input: UpdateUsageRequest): UpdateUsageResponse {
        val op = SdkHttpOperation.build<UpdateUsageRequest, UpdateUsageResponse> {
            serializeWith = UpdateUsageOperationSerializer()
            deserializeWith = UpdateUsageOperationDeserializer()
            operationName = "UpdateUsage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a usage plan of a given plan Id.
     */
    override suspend fun updateUsagePlan(input: UpdateUsagePlanRequest): UpdateUsagePlanResponse {
        val op = SdkHttpOperation.build<UpdateUsagePlanRequest, UpdateUsagePlanResponse> {
            serializeWith = UpdateUsagePlanOperationSerializer()
            deserializeWith = UpdateUsagePlanOperationDeserializer()
            operationName = "UpdateUsagePlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing VpcLink of a specified identifier.
     */
    override suspend fun updateVpcLink(input: UpdateVpcLinkRequest): UpdateVpcLinkResponse {
        val op = SdkHttpOperation.build<UpdateVpcLinkRequest, UpdateVpcLinkResponse> {
            serializeWith = UpdateVpcLinkOperationSerializer()
            deserializeWith = UpdateVpcLinkOperationDeserializer()
            operationName = "UpdateVpcLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(
            MutateHeaders().apply {
                append("Accept", "application/json")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "apigateway")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
