// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.UpdateUsageResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class UpdateUsageOperationDeserializer: HttpDeserialize<UpdateUsageResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateUsageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateUsageError(context, call)
        }
        val builder = UpdateUsageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateUsageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateUsageError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateUsageOperationBody(builder: UpdateUsageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("endDate"))
    val ITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("values"))
    val ITEMS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val ITEMS_C1_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val POSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("position"))
    val STARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("startDate"))
    val USAGEPLANID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("usagePlanId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDDATE_DESCRIPTOR)
        field(ITEMS_DESCRIPTOR)
        field(POSITION_DESCRIPTOR)
        field(STARTDATE_DESCRIPTOR)
        field(USAGEPLANID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDDATE_DESCRIPTOR.index -> builder.endDate = deserializeString()
                ITEMS_DESCRIPTOR.index -> builder.items =
                    deserializer.deserializeMap(ITEMS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<List<Long>>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(ITEMS_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<List<Long>>()
                                        while (hasNextElement()) {
                                            val el1 = deserializer.deserializeList(ITEMS_C1_DESCRIPTOR) {
                                                val col2 = mutableListOf<Long>()
                                                while (hasNextElement()) {
                                                    val el2 = if (nextHasValue()) { deserializeLong() } else { deserializeNull(); continue }
                                                    col2.add(el2)
                                                }
                                                col2
                                            }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                POSITION_DESCRIPTOR.index -> builder.position = deserializeString()
                STARTDATE_DESCRIPTOR.index -> builder.startDate = deserializeString()
                USAGEPLANID_DESCRIPTOR.index -> builder.usagePlanId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
