// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.PatchOperation
import aws.sdk.kotlin.services.apigateway.model.UpdateMethodRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateMethodOperationSerializer: HttpSerialize<UpdateMethodRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateMethodRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.restApiId) { "restApiId is bound to the URI and must not be null" }
            requireNotNull(input.resourceId) { "resourceId is bound to the URI and must not be null" }
            requireNotNull(input.httpMethod) { "httpMethod is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("restapis"))
                add(PercentEncoding.SmithyLabel.encode("${input.restApiId}"))
                add(PercentEncoding.Path.encode("resources"))
                add(PercentEncoding.SmithyLabel.encode("${input.resourceId}"))
                add(PercentEncoding.Path.encode("methods"))
                add(PercentEncoding.SmithyLabel.encode("${input.httpMethod}"))
            }
        }

        val payload = serializeUpdateMethodOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateMethodOperationBody(context: ExecutionContext, input: UpdateMethodRequest): ByteArray {
    val serializer = JsonSerializer()
    val PATCHOPERATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("patchOperations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PATCHOPERATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.patchOperations != null) {
            listField(PATCHOPERATIONS_DESCRIPTOR) {
                for (el0 in input.patchOperations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializePatchOperationDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
