// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.Integration
import aws.sdk.kotlin.services.apigateway.model.MethodResponse
import aws.sdk.kotlin.services.apigateway.model.UpdateMethodResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class UpdateMethodOperationDeserializer: HttpDeserialize<UpdateMethodResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateMethodResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateMethodError(context, call)
        }
        val builder = UpdateMethodResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateMethodOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateMethodError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateMethodOperationBody(builder: UpdateMethodResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIKEYREQUIRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("apiKeyRequired"))
    val AUTHORIZATIONSCOPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("authorizationScopes"))
    val AUTHORIZATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizationType"))
    val AUTHORIZERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerId"))
    val HTTPMETHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("httpMethod"))
    val METHODINTEGRATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("methodIntegration"))
    val METHODRESPONSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("methodResponses"))
    val OPERATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("operationName"))
    val REQUESTMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestModels"))
    val REQUESTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestParameters"))
    val REQUESTVALIDATORID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestValidatorId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIKEYREQUIRED_DESCRIPTOR)
        field(AUTHORIZATIONSCOPES_DESCRIPTOR)
        field(AUTHORIZATIONTYPE_DESCRIPTOR)
        field(AUTHORIZERID_DESCRIPTOR)
        field(HTTPMETHOD_DESCRIPTOR)
        field(METHODINTEGRATION_DESCRIPTOR)
        field(METHODRESPONSES_DESCRIPTOR)
        field(OPERATIONNAME_DESCRIPTOR)
        field(REQUESTMODELS_DESCRIPTOR)
        field(REQUESTPARAMETERS_DESCRIPTOR)
        field(REQUESTVALIDATORID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIKEYREQUIRED_DESCRIPTOR.index -> builder.apiKeyRequired = deserializeBoolean()
                AUTHORIZATIONSCOPES_DESCRIPTOR.index -> builder.authorizationScopes =
                    deserializer.deserializeList(AUTHORIZATIONSCOPES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUTHORIZATIONTYPE_DESCRIPTOR.index -> builder.authorizationType = deserializeString()
                AUTHORIZERID_DESCRIPTOR.index -> builder.authorizerId = deserializeString()
                HTTPMETHOD_DESCRIPTOR.index -> builder.httpMethod = deserializeString()
                METHODINTEGRATION_DESCRIPTOR.index -> builder.methodIntegration = deserializeIntegrationDocument(deserializer)
                METHODRESPONSES_DESCRIPTOR.index -> builder.methodResponses =
                    deserializer.deserializeMap(METHODRESPONSES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, MethodResponse>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeMethodResponseDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                OPERATIONNAME_DESCRIPTOR.index -> builder.operationName = deserializeString()
                REQUESTMODELS_DESCRIPTOR.index -> builder.requestModels =
                    deserializer.deserializeMap(REQUESTMODELS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                REQUESTPARAMETERS_DESCRIPTOR.index -> builder.requestParameters =
                    deserializer.deserializeMap(REQUESTPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Boolean>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeBoolean() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                REQUESTVALIDATORID_DESCRIPTOR.index -> builder.requestValidatorId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
