// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.GetDeploymentResponse
import aws.sdk.kotlin.services.apigateway.model.MethodSnapshot
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class GetDeploymentOperationDeserializer: HttpDeserialize<GetDeploymentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDeploymentError(context, call)
        }
        val builder = GetDeploymentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDeploymentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetDeploymentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDeploymentOperationBody(builder: GetDeploymentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APISUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("apiSummary"))
    val APISUMMARY_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APISUMMARY_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APISUMMARY_DESCRIPTOR.index -> builder.apiSummary =
                    deserializer.deserializeMap(APISUMMARY_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Map<String, MethodSnapshot>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeMap(APISUMMARY_C0_DESCRIPTOR) {
                                        val map1 = mutableMapOf<String, MethodSnapshot>()
                                        while (hasNextEntry()) {
                                            val k1 = key()
                                            val v1 = if (nextHasValue()) { deserializeMethodSnapshotDocument(deserializer) } else { deserializeNull(); continue }
                                            map1[k1] = v1
                                        }
                                        map1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
