// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.AuthorizerType
import aws.sdk.kotlin.services.apigateway.model.GetAuthorizerResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetAuthorizerOperationDeserializer: HttpDeserialize<GetAuthorizerResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetAuthorizerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAuthorizerError(context, call)
        }
        val builder = GetAuthorizerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAuthorizerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetAuthorizerError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAuthorizerOperationBody(builder: GetAuthorizerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authType"))
    val AUTHORIZERCREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerCredentials"))
    val AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("authorizerResultTtlInSeconds"))
    val AUTHORIZERURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerUri"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val IDENTITYSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identitySource"))
    val IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identityValidationExpression"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROVIDERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("providerARNs"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHTYPE_DESCRIPTOR)
        field(AUTHORIZERCREDENTIALS_DESCRIPTOR)
        field(AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR)
        field(AUTHORIZERURI_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(IDENTITYSOURCE_DESCRIPTOR)
        field(IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROVIDERARNS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHTYPE_DESCRIPTOR.index -> builder.authType = deserializeString()
                AUTHORIZERCREDENTIALS_DESCRIPTOR.index -> builder.authorizerCredentials = deserializeString()
                AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR.index -> builder.authorizerResultTtlInSeconds = deserializeInt()
                AUTHORIZERURI_DESCRIPTOR.index -> builder.authorizerUri = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                IDENTITYSOURCE_DESCRIPTOR.index -> builder.identitySource = deserializeString()
                IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR.index -> builder.identityValidationExpression = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PROVIDERARNS_DESCRIPTOR.index -> builder.providerArns =
                    deserializer.deserializeList(PROVIDERARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { AuthorizerType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
