// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.AccessLogSettings
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.CacheClusterSize
import aws.sdk.kotlin.services.apigateway.model.CacheClusterStatus
import aws.sdk.kotlin.services.apigateway.model.CanarySettings
import aws.sdk.kotlin.services.apigateway.model.CreateStageResponse
import aws.sdk.kotlin.services.apigateway.model.MethodSetting
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class CreateStageOperationDeserializer: HttpDeserialize<CreateStageResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateStageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateStageError(context, call)
        }
        val builder = CreateStageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateStageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateStageError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateStageOperationBody(builder: CreateStageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSLOGSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessLogSettings"))
    val CACHECLUSTERENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("cacheClusterEnabled"))
    val CACHECLUSTERSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("cacheClusterSize"))
    val CACHECLUSTERSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("cacheClusterStatus"))
    val CANARYSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("canarySettings"))
    val CLIENTCERTIFICATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientCertificateId"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DOCUMENTATIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("documentationVersion"))
    val LASTUPDATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDate"))
    val METHODSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("methodSettings"))
    val STAGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stageName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TRACINGENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("tracingEnabled"))
    val VARIABLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("variables"))
    val WEBACLARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("webAclArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSLOGSETTINGS_DESCRIPTOR)
        field(CACHECLUSTERENABLED_DESCRIPTOR)
        field(CACHECLUSTERSIZE_DESCRIPTOR)
        field(CACHECLUSTERSTATUS_DESCRIPTOR)
        field(CANARYSETTINGS_DESCRIPTOR)
        field(CLIENTCERTIFICATEID_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DEPLOYMENTID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOCUMENTATIONVERSION_DESCRIPTOR)
        field(LASTUPDATEDDATE_DESCRIPTOR)
        field(METHODSETTINGS_DESCRIPTOR)
        field(STAGENAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRACINGENABLED_DESCRIPTOR)
        field(VARIABLES_DESCRIPTOR)
        field(WEBACLARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSLOGSETTINGS_DESCRIPTOR.index -> builder.accessLogSettings = deserializeAccessLogSettingsDocument(deserializer)
                CACHECLUSTERENABLED_DESCRIPTOR.index -> builder.cacheClusterEnabled = deserializeBoolean()
                CACHECLUSTERSIZE_DESCRIPTOR.index -> builder.cacheClusterSize = deserializeString().let { CacheClusterSize.fromValue(it) }
                CACHECLUSTERSTATUS_DESCRIPTOR.index -> builder.cacheClusterStatus = deserializeString().let { CacheClusterStatus.fromValue(it) }
                CANARYSETTINGS_DESCRIPTOR.index -> builder.canarySettings = deserializeCanarySettingsDocument(deserializer)
                CLIENTCERTIFICATEID_DESCRIPTOR.index -> builder.clientCertificateId = deserializeString()
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEPLOYMENTID_DESCRIPTOR.index -> builder.deploymentId = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DOCUMENTATIONVERSION_DESCRIPTOR.index -> builder.documentationVersion = deserializeString()
                LASTUPDATEDDATE_DESCRIPTOR.index -> builder.lastUpdatedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                METHODSETTINGS_DESCRIPTOR.index -> builder.methodSettings =
                    deserializer.deserializeMap(METHODSETTINGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, MethodSetting>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeMethodSettingDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                STAGENAME_DESCRIPTOR.index -> builder.stageName = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TRACINGENABLED_DESCRIPTOR.index -> builder.tracingEnabled = deserializeBoolean()
                VARIABLES_DESCRIPTOR.index -> builder.variables =
                    deserializer.deserializeMap(VARIABLES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                WEBACLARN_DESCRIPTOR.index -> builder.webAclArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
