// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.AuthorizerType
import aws.sdk.kotlin.services.apigateway.model.CreateAuthorizerRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateAuthorizerOperationSerializer: HttpSerialize<CreateAuthorizerRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateAuthorizerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.restApiId) { "restApiId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("restapis"))
                add(PercentEncoding.SmithyLabel.encode("${input.restApiId}"))
                add(PercentEncoding.Path.encode("authorizers"))
            }
        }

        val payload = serializeCreateAuthorizerOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAuthorizerOperationBody(context: ExecutionContext, input: CreateAuthorizerRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authType"))
    val AUTHORIZERCREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerCredentials"))
    val AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("authorizerResultTtlInSeconds"))
    val AUTHORIZERURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerUri"))
    val IDENTITYSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identitySource"))
    val IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identityValidationExpression"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROVIDERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("providerARNs"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHTYPE_DESCRIPTOR)
        field(AUTHORIZERCREDENTIALS_DESCRIPTOR)
        field(AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR)
        field(AUTHORIZERURI_DESCRIPTOR)
        field(IDENTITYSOURCE_DESCRIPTOR)
        field(IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROVIDERARNS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authType?.let { field(AUTHTYPE_DESCRIPTOR, it) }
        input.authorizerCredentials?.let { field(AUTHORIZERCREDENTIALS_DESCRIPTOR, it) }
        input.authorizerResultTtlInSeconds?.let { field(AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR, it) }
        input.authorizerUri?.let { field(AUTHORIZERURI_DESCRIPTOR, it) }
        input.identitySource?.let { field(IDENTITYSOURCE_DESCRIPTOR, it) }
        input.identityValidationExpression?.let { field(IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        if (input.providerArns != null) {
            listField(PROVIDERARNS_DESCRIPTOR) {
                for (el0 in input.providerArns) {
                    serializeString(el0)
                }
            }
        }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
