// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents an AWS account that is associated with API Gateway.
 */
public class UpdateAccountResponse private constructor(builder: Builder) {
    /**
     * The version of the API keys used for the account.
     */
    public val apiKeyVersion: kotlin.String? = builder.apiKeyVersion
    /**
     * The ARN of an Amazon CloudWatch role for the current Account.
     */
    public val cloudwatchRoleArn: kotlin.String? = builder.cloudwatchRoleArn
    /**
     * A list of features supported for the account. When usage plans are enabled, the features list will include an entry of `"UsagePlans"`.
     */
    public val features: List<String>? = builder.features
    /**
     * Specifies the API request limits configured for the current Account.
     */
    public val throttleSettings: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = builder.throttleSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateAccountResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAccountResponse(")
        append("apiKeyVersion=$apiKeyVersion,")
        append("cloudwatchRoleArn=$cloudwatchRoleArn,")
        append("features=$features,")
        append("throttleSettings=$throttleSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeyVersion?.hashCode() ?: 0
        result = 31 * result + (cloudwatchRoleArn?.hashCode() ?: 0)
        result = 31 * result + (features?.hashCode() ?: 0)
        result = 31 * result + (throttleSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAccountResponse

        if (apiKeyVersion != other.apiKeyVersion) return false
        if (cloudwatchRoleArn != other.cloudwatchRoleArn) return false
        if (features != other.features) return false
        if (throttleSettings != other.throttleSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateAccountResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The version of the API keys used for the account.
         */
        public var apiKeyVersion: kotlin.String? = null
        /**
         * The ARN of an Amazon CloudWatch role for the current Account.
         */
        public var cloudwatchRoleArn: kotlin.String? = null
        /**
         * A list of features supported for the account. When usage plans are enabled, the features list will include an entry of `"UsagePlans"`.
         */
        public var features: List<String>? = null
        /**
         * Specifies the API request limits configured for the current Account.
         */
        public var throttleSettings: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateAccountResponse) : this() {
            this.apiKeyVersion = x.apiKeyVersion
            this.cloudwatchRoleArn = x.cloudwatchRoleArn
            this.features = x.features
            this.throttleSettings = x.throttleSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateAccountResponse = UpdateAccountResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.ThrottleSettings] inside the given [block]
         */
        public fun throttleSettings(block: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.Builder.() -> kotlin.Unit) {
            this.throttleSettings = aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
